/*
 * Decompiled with CFR 0.152.
 */
package org.xplanner.soap.XPlanner;

import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;
import org.apache.axis.transport.http.HTTPConstants;
import org.xplanner.soap.XPlanner.XPlanner;
import org.xplanner.soap.XPlanner.XPlannerService;
import org.xplanner.soap.XPlanner.XPlannerSoapBindingStub;

public class XPlannerServiceLocator
extends Service
implements XPlannerService {
    private Proxy proxy;
    private String httpUser;
    private String httpPassword;
    private boolean compression;
    private String XPlanner_address = "http://jbproxy.inprise.com:7070/soap/XPlanner";
    private String XPlannerWSDDServiceName = "XPlanner";
    private HashSet ports = null;

    public XPlannerServiceLocator() {
    }

    public XPlannerServiceLocator(EngineConfiguration config) {
        super(config);
    }

    public XPlannerServiceLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    public String getXPlannerAddress() {
        return this.XPlanner_address;
    }

    public String getXPlannerWSDDServiceName() {
        return this.XPlannerWSDDServiceName;
    }

    public void setXPlannerWSDDServiceName(String name) {
        this.XPlannerWSDDServiceName = name;
    }

    public XPlanner getXPlanner() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.XPlanner_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getXPlanner(endpoint);
    }

    public XPlanner getXPlanner(URL portAddress) throws ServiceException {
        try {
            XPlannerSoapBindingStub _stub = new XPlannerSoapBindingStub(portAddress, this);
            _stub.setPortName(this.getXPlannerWSDDServiceName());
            return _stub;
        }
        catch (AxisFault axisFault) {
            return null;
        }
    }

    public void setXPlannerEndpointAddress(String address) {
        this.XPlanner_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (XPlanner.class.isAssignableFrom(serviceEndpointInterface)) {
                XPlannerSoapBindingStub _stub = new XPlannerSoapBindingStub(new URL(this.XPlanner_address), this);
                _stub.setPortName(this.getXPlannerWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("XPlanner".equals(inputPortName)) {
            return this.getXPlanner();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("http://xplanner.org:8080/soap/XPlanner", "XPlannerService");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("http://xplanner.org:8080/soap/XPlanner", "XPlanner"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"XPlanner".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setXPlannerEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }

    public Call createCall() throws ServiceException {
        Call call = super.createCall();
        if (this.compression) {
            call.setProperty("transport.http.acceptGzip", (Object)Boolean.TRUE);
        }
        if (this.httpUser != null && this.httpPassword != null) {
            call.setProperty("org.eclipse.mylyn.xplanner.httpUser", (Object)this.httpUser);
            call.setProperty("org.eclipse.mylyn.xplanner.httpPassword", (Object)this.httpPassword);
        }
        if (this.proxy != null) {
            call.setProperty("org.eclipse.mylyn.xplanner.proxy", (Object)this.proxy);
        }
        Hashtable<String, Boolean> headers = new Hashtable<String, Boolean>();
        headers.put(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED, Boolean.FALSE);
        call.setProperty("HTTP-Request-Headers", headers);
        return call;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public String getHttpUser() {
        return this.httpUser;
    }

    public void setHttpUser(String httpUser) {
        this.httpUser = httpUser;
    }

    public String getHttpPassword() {
        return this.httpPassword;
    }

    public void setHttpPassword(String httpPassword) {
        this.httpPassword = httpPassword;
    }

    public boolean isCompression() {
        return this.compression;
    }

    public void setCompression(boolean compression) {
        this.compression = compression;
    }
}

