/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaCustomField
implements Serializable {
    private static final long serialVersionUID = 7273310489883205486L;
    public static final String CUSTOM_FIELD_PREFIX = "cf_";
    private final String name;
    private final String description;
    private List<String> options = new ArrayList<String>();
    private final int type;
    private final String typeDesc;
    private final boolean enterBug;

    public BugzillaCustomField(String description, String name, String type, String typeDesc, String enterBug) {
        this.description = description;
        this.name = name;
        this.type = this.parseInt(type);
        this.typeDesc = typeDesc;
        this.enterBug = "1".equals(enterBug);
    }

    private int parseInt(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    public void addOption(String option) {
        this.options.add(option);
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return this.typeDesc;
    }

    public boolean isEnterBug() {
        return this.enterBug;
    }
}

