/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.wizard;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.NewTaskWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class NewBugzillaTaskWizard
extends NewTaskWizard
implements INewWizard {
    private IStructuredSelection selection;

    public NewBugzillaTaskWizard(TaskRepository taskRepository, ITaskMapping taskSelection) {
        super(taskRepository, taskSelection);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected ITaskMapping getInitializationData() {
        ISelection sel;
        IWorkbenchWindow window;
        if (this.getTaskSelection() != null) {
            return this.getTaskSelection();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && (sel = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)sel;
        }
        if (this.selection == null || this.selection.isEmpty()) {
            final String lastSelection = this.getTaskRepository().getProperty("last.selection.product");
            return new TaskMapping(){

                public String getProduct() {
                    return lastSelection;
                }
            };
        }
        final ArrayList<String> products = new ArrayList<String>();
        Object element = this.selection.getFirstElement();
        if (element instanceof ITask) {
            ITask bugzillaTask = (ITask)element;
            if (bugzillaTask.getAttribute(BugzillaAttribute.PRODUCT.getKey()) != null) {
                products.add(bugzillaTask.getAttribute(BugzillaAttribute.PRODUCT.getKey()));
            }
        } else {
            ITask bugzillaTask;
            IAdaptable adaptable;
            ITask task;
            IRepositoryQuery query = null;
            if (element instanceof IRepositoryQuery) {
                query = (IRepositoryQuery)element;
            }
            if (query != null && query.getConnectorKind().equals("bugzilla")) {
                String[] options;
                String queryUrl = query.getUrl();
                queryUrl = queryUrl.substring(queryUrl.indexOf("?") + 1);
                String[] stringArray = options = queryUrl.split("&");
                int n = options.length;
                int n2 = 0;
                while (n2 < n) {
                    String key;
                    String option = stringArray[n2];
                    int index = option.indexOf("=");
                    if (index != -1 && "product".equals(key = option.substring(0, index))) {
                        try {
                            products.add(URLDecoder.decode(option.substring(index + 1), this.getTaskRepository().getCharacterEncoding()));
                            break;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    }
                    ++n2;
                }
            } else if (element instanceof IAdaptable && (task = (ITask)(adaptable = (IAdaptable)element).getAdapter(ITask.class)) != null && (bugzillaTask = (ITask)element).getAttribute(BugzillaAttribute.PRODUCT.getKey()) != null) {
                products.add(bugzillaTask.getAttribute(BugzillaAttribute.PRODUCT.getKey()));
            }
        }
        if (products.size() > 0) {
            return new TaskMapping(){

                public String getProduct() {
                    return (String)products.get(0);
                }
            };
        }
        return null;
    }
}

