/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.resources.ui;

import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.monitor.ui.AbstractUserInteractionMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.EditorPart;

public class ResourceInteractionMonitor
extends AbstractUserInteractionMonitor {
    private static final String ID_SYNCHRONIZE_VIEW = "org.eclipse.team.sync.views.SynchronizeView";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleWorkbenchPartSelection(IWorkbenchPart part, ISelection selection, boolean contributeToContext) {
        if (ID_SYNCHRONIZE_VIEW.equals(part.getSite().getId())) {
            return;
        }
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            for (Object selectedObject : structuredSelection) {
                if (!(selectedObject instanceof File)) continue;
                File file = (File)selectedObject;
                super.handleElementSelection(part, (Object)file, contributeToContext);
            }
            return;
        } else {
            if (!(selection instanceof TextSelection) || !(part instanceof EditorPart)) return;
            try {
                IFile file;
                Object object = ((EditorPart)part).getEditorInput().getAdapter(IResource.class);
                if (!(object instanceof IFile) || (file = (IFile)object).getFileExtension() == null || ContextCore.getContentTypes().contains(file.getFileExtension())) return;
                super.handleElementEdit(part, object, contributeToContext);
                return;
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.resources.ui", "Failed to resolve resource edit", t));
            }
        }
    }
}

