/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.provisional.tasks.bugs.AbstractTaskContributor;
import org.eclipse.mylyn.internal.tasks.bugs.Messages;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.ErrorLogStatus;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.FeatureStatus;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskContributor
extends AbstractTaskContributor {
    public void appendErrorDetails(StringBuilder sb, IStatus status, Date date) {
        sb.append(Messages.DefaultTaskContributor_Error_DETAILS);
        if (date != null) {
            sb.append(Messages.DefaultTaskContributor_DATE);
            sb.append(date);
        }
        sb.append(Messages.DefaultTaskContributor_MESSAGE);
        sb.append(status.getMessage());
        sb.append(Messages.DefaultTaskContributor_SEVERITY);
        sb.append(this.getSeverityText(status.getSeverity()));
        sb.append(Messages.DefaultTaskContributor_PLUGIN);
        sb.append(status.getPlugin());
    }

    @Override
    public Map<String, String> getAttributes(IStatus status) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("description", this.getDescription(status));
        return attributes;
    }

    public String getDescription(IStatus status) {
        if (status instanceof FeatureStatus) {
            IBundleGroup[] bundleGroups;
            StringBuilder sb = new StringBuilder();
            sb.append("\n\n\n");
            sb.append(Messages.DefaultTaskContributor_INSTALLED_FEATURES_AND_PLUGINS);
            IBundleGroup[] iBundleGroupArray = bundleGroups = ((FeatureStatus)status).getBundleGroup();
            int n = bundleGroups.length;
            int n2 = 0;
            while (n2 < n) {
                IBundleGroup bundleGroup = iBundleGroupArray[n2];
                sb.append(bundleGroup.getIdentifier());
                sb.append(" ");
                sb.append(bundleGroup.getVersion());
                sb.append("\n");
                Bundle[] bundles = bundleGroup.getBundles();
                if (bundles != null) {
                    Bundle[] bundleArray = bundles;
                    int n3 = bundles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Bundle bundle = bundleArray[n4];
                        sb.append("  ");
                        sb.append(bundle.getSymbolicName());
                        String version = (String)bundle.getHeaders().get(Messages.DefaultTaskContributor_Bundle_Version);
                        if (version != null) {
                            sb.append(" ");
                            sb.append(version);
                        }
                        sb.append("\n");
                        ++n4;
                    }
                }
                ++n2;
            }
            return sb.toString();
        }
        if (status instanceof ErrorLogStatus) {
            ErrorLogStatus errorLogStatus = (ErrorLogStatus)status;
            StringBuilder sb = new StringBuilder();
            this.appendErrorDetails(sb, (IStatus)errorLogStatus, errorLogStatus.getDate());
            if (errorLogStatus.getLogSessionData() != null) {
                sb.append(Messages.DefaultTaskContributor_SESSION_DATA);
                sb.append(errorLogStatus.getLogSessionData());
            }
            if (errorLogStatus.getStack() != null) {
                sb.append(Messages.DefaultTaskContributor_EXCEPTION_STACK_TRACE);
                sb.append(errorLogStatus.getStack());
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        this.appendErrorDetails(sb, status, new Date());
        if (status.getException() != null) {
            sb.append(Messages.DefaultTaskContributor_EXCEPTION_STACK_TRACE);
            StringWriter writer = new StringWriter();
            status.getException().printStackTrace(new PrintWriter(writer));
            sb.append(writer.getBuffer());
        }
        return sb.toString();
    }

    @Override
    public String getEditorId(IStatus status) {
        return "org.eclipse.mylyn.tasks.ui.editors.task";
    }

    private String getSeverityText(int severity) {
        switch (severity) {
            case 4: {
                return Messages.DefaultTaskContributor_Error;
            }
            case 2: {
                return Messages.DefaultTaskContributor_Warning;
            }
            case 1: {
                return Messages.DefaultTaskContributor_Info;
            }
            case 0: {
                return Messages.DefaultTaskContributor_OK;
            }
        }
        return "?";
    }
}

