/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.internal.commons.core.ErrorReporterManager;
import org.eclipse.mylyn.internal.tasks.bugs.actions.Messages;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.ErrorLogStatus;
import org.eclipse.pde.internal.runtime.logview.LogEntry;
import org.eclipse.pde.internal.runtime.logview.LogSession;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class NewTaskFromErrorAction
implements IViewActionDelegate,
ISelectionChangedListener {
    public static final String ID = "org.eclipse.mylyn.tasklist.ui.repositories.actions.create";
    private TreeViewer treeViewer;

    private void buildDescriptionFromLogEntry(LogEntry entry, StringBuilder sb, boolean includeChildren) {
        sb.append(Messages.NewTaskFromErrorAction_ERROR_LOG_DATE);
        sb.append(entry.getDate());
        sb.append(Messages.NewTaskFromErrorAction_MESSGAE);
        sb.append(entry.getMessage());
        sb.append(String.valueOf(Messages.NewTaskFromErrorAction_SEVERITY) + entry.getSeverityText());
        sb.append(Messages.NewTaskFromErrorAction_PLUGIN_ID);
        sb.append(entry.getPluginId());
        sb.append(Messages.NewTaskFromErrorAction_STACK_TRACE);
        if (entry.getStack() == null) {
            sb.append(Messages.NewTaskFromErrorAction_no_stack_trace_available);
        } else {
            sb.append(entry.getStack());
        }
        if (includeChildren && entry.hasChildren()) {
            Object[] children;
            Object[] objectArray = children = entry.getChildren(null);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child instanceof LogEntry) {
                    this.buildDescriptionFromLogEntry((LogEntry)child, sb, includeChildren);
                }
                ++n2;
            }
        }
    }

    private void createTask(LogEntry entry) {
        ErrorLogStatus status = new ErrorLogStatus(entry.getSeverity(), entry.getPluginId(), entry.getCode(), entry.getMessage());
        status.setDate(entry.getDate());
        status.setStack(entry.getStack());
        LogSession session = entry.getSession();
        if (session != null) {
            status.setLogSessionData(session.getSessionData());
        }
        new ErrorReporterManager().fail((IStatus)status);
    }

    public void run() {
        TreeItem[] items = this.treeViewer.getTree().getSelection();
        LogEntry entry = null;
        if (items.length > 0) {
            entry = (LogEntry)items[0].getData();
        }
        if (entry == null) {
            return;
        }
        this.createTask(entry);
    }

    public void run(IAction action) {
        this.run();
    }

    public void init(IViewPart view) {
        ISelectionProvider sp = view.getViewSite().getSelectionProvider();
        sp.addSelectionChangedListener((ISelectionChangedListener)this);
        sp.setSelection(sp.getSelection());
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.treeViewer = (TreeViewer)event.getSource();
    }
}

