/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs.wizards;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.bugs.AttributeTaskMapper;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.Messages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ReportErrorPage
extends WizardPage {
    private final IStatus status;
    private final AttributeTaskMapper mapper;
    protected TaskRepository taskRepository;

    public ReportErrorPage(AttributeTaskMapper mapper, IStatus status) {
        super("reportError");
        this.mapper = mapper;
        this.status = status;
        this.setTitle(Messages.ReportErrorPage_Report_as_Bug);
        this.setMessage(MessageFormat.format(Messages.ReportErrorPage_AN_UNEXPETED_ERROR_HAS_OCCURED_IN_PLUGIN, status.getPlugin()));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        Label label = new Label(composite, 0);
        label.setText(Messages.ReportErrorPage_Details);
        Text text = new Text(composite, 2634);
        text.setText(this.status.getMessage());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)text);
        new Label(composite, 0);
        if (this.mapper.isMappingComplete()) {
            final Button defaultRepositoryButton = new Button(composite, 16);
            defaultRepositoryButton.setText(String.valueOf(Messages.ReportErrorPage_Report_to_) + this.mapper.getTaskRepository().getRepositoryLabel());
            defaultRepositoryButton.setSelection(true);
            final Button selectRepositoryButton = new Button(composite, 16);
            selectRepositoryButton.setText(Messages.ReportErrorPage_Select_repository);
            defaultRepositoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (defaultRepositoryButton.getSelection()) {
                        selectRepositoryButton.setSelection(false);
                    }
                    ReportErrorPage.this.taskRepository = ReportErrorPage.this.mapper.getTaskRepository();
                    ReportErrorPage.this.getContainer().updateButtons();
                }
            });
            selectRepositoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (selectRepositoryButton.getSelection()) {
                        defaultRepositoryButton.setSelection(false);
                    }
                    ReportErrorPage.this.taskRepository = null;
                    ReportErrorPage.this.getContainer().updateButtons();
                }
            });
            this.taskRepository = this.mapper.getTaskRepository();
        } else {
            this.taskRepository = null;
        }
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public boolean canFlipToNextPage() {
        return this.taskRepository == null;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public boolean isPageComplete() {
        return true;
    }
}

