/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.TaskActivationHistory;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.ActivateTaskDialogAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskActivateAction;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.ui.TaskElementLabelProvider;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;

public class TaskHistoryDropDown
extends CompoundContributionItem {
    private static final int MAX_ITEMS_TO_DISPLAY = 16;
    private final TaskElementLabelProvider labelProvider = new TaskElementLabelProvider(false);
    private boolean scopedToWorkingSet;
    private final TaskActivationHistory taskHistory;

    public TaskHistoryDropDown() {
        this(null);
    }

    public TaskHistoryDropDown(String id) {
        this(id, TasksUiPlugin.getTaskActivityManager().getTaskActivationHistory());
    }

    public TaskHistoryDropDown(String id, TaskActivationHistory taskHistory) {
        super(id);
        this.taskHistory = taskHistory;
    }

    protected IContributionItem[] getContributionItems() {
        ActionContributionItem item;
        List tasks = new ArrayList(this.taskHistory.getPreviousTasks());
        Set<IWorkingSet> sets = TaskListView.getActiveWorkingSets();
        if (this.scopedToWorkingSet && !sets.isEmpty()) {
            HashSet allWorkingSetTasks = new HashSet();
            for (IWorkingSet workingSet : sets) {
                Object elements;
                Object object = elements = workingSet.getElements();
                int n = ((Object)object).length;
                int n2 = 0;
                while (n2 < n) {
                    Object adaptable = object[n2];
                    if (adaptable instanceof ITaskContainer) {
                        allWorkingSetTasks.addAll(((ITaskContainer)adaptable).getChildren());
                    }
                    ++n2;
                }
            }
            ArrayList allScopedTasks = new ArrayList(tasks);
            for (ITask task : tasks) {
                if (allWorkingSetTasks.contains(task)) continue;
                allScopedTasks.remove(task);
            }
            tasks = allScopedTasks;
        }
        if (tasks.size() > 16) {
            tasks = tasks.subList(tasks.size() - 16, tasks.size());
        }
        ArrayList<Object> items = new ArrayList<Object>();
        int i = tasks.size() - 1;
        while (i >= 0) {
            AbstractTask currTask = (AbstractTask)tasks.get(i);
            ActivateTaskAction taskNavAction = new ActivateTaskAction(currTask);
            item = new ActionContributionItem((IAction)taskNavAction);
            if (currTask.isActive()) {
                taskNavAction.setChecked(true);
            }
            items.add(item);
            --i;
        }
        Separator separator = new Separator();
        items.add(separator);
        ITask active = TasksUi.getTaskActivityManager().getActiveTask();
        if (active != null) {
            DeactivateTaskAction deactivateAction = new DeactivateTaskAction();
            item = new ActionContributionItem((IAction)deactivateAction);
            items.add(item);
        } else {
            ActivateDialogAction activateDialogAction = new ActivateDialogAction(new ActivateTaskDialogAction());
            item = new ActionContributionItem((IAction)activateDialogAction);
            items.add(item);
        }
        return items.toArray(new IContributionItem[items.size()]);
    }

    public boolean isScopedToWorkingSet() {
        return this.scopedToWorkingSet;
    }

    public void setScopedToWorkingSet(boolean scopedToWorkingSet) {
        this.scopedToWorkingSet = scopedToWorkingSet;
    }

    private class ActivateDialogAction
    extends Action {
        private final ActivateTaskDialogAction dialogAction;

        public ActivateDialogAction(ActivateTaskDialogAction action) {
            this.dialogAction = action;
            this.dialogAction.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            this.setText(Messages.TaskHistoryDropDown_Activate_Task_);
            this.setToolTipText(Messages.TaskHistoryDropDown_Activate_Task_);
            this.setEnabled(true);
            this.setChecked(false);
            this.setImageDescriptor(null);
        }

        public void run() {
            this.dialogAction.run(null);
        }
    }

    private class ActivateTaskAction
    extends Action {
        private static final int MAX_LABEL_LENGTH = 40;
        private final AbstractTask targetTask;

        public ActivateTaskAction(AbstractTask task) {
            this.targetTask = task;
            String taskDescription = task.getSummary();
            if (taskDescription.length() > 40) {
                taskDescription = taskDescription.subSequence(0, 37) + "...";
            }
            this.setText(taskDescription);
            this.setEnabled(true);
            this.setToolTipText(task.getSummary());
            Image image = TaskHistoryDropDown.this.labelProvider.getImage(task);
            this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
        }

        public void run() {
            if (this.targetTask.isActive()) {
                return;
            }
            new TaskActivateAction().run((ITask)this.targetTask);
        }
    }

    private class DeactivateTaskAction
    extends Action {
        public DeactivateTaskAction() {
            this.setText(Messages.TaskHistoryDropDown_Deactivate_Task);
            this.setToolTipText(Messages.TaskHistoryDropDown_Deactivate_Task);
            this.setEnabled(true);
            this.setChecked(false);
            this.setImageDescriptor(null);
        }

        public void run() {
            ITask active = TasksUi.getTaskActivityManager().getActiveTask();
            if (active != null) {
                TasksUi.getTaskActivityManager().deactivateTask(active);
            }
        }
    }
}

