/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TaskHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyTaskDetailsAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.OpenTaskListElementAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.OpenWithBrowserAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskActivateAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskDeactivateAction;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivationListener;
import org.eclipse.mylyn.tasks.core.TaskActivationAdapter;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class TaskTrimWidget
extends WorkbenchWindowControlContribution {
    public static String ID_CONTAINER = "org.eclipse.mylyn.tasks.ui.trim.container";
    public static String ID_CONTROL = "org.eclipse.mylyn.tasks.ui.trim.control";
    private Composite composite = null;
    private ITask activeTask = null;
    private MenuManager menuManager = null;
    private Menu menu = null;
    private TaskHyperlink activeTaskLabel;
    private final OpenWithBrowserAction openWithBrowserAction = new OpenWithBrowserAction();
    private final CopyTaskDetailsAction copyTaskDetailsAction = new CopyTaskDetailsAction();
    private Point p;
    private final ITaskActivationListener TASK_ACTIVATION_LISTENER = new TaskActivationAdapter(){

        public void taskActivated(ITask task) {
            TaskTrimWidget.this.activeTask = task;
            TaskTrimWidget.this.indicateActiveTask();
        }

        public void taskDeactivated(ITask task) {
            TaskTrimWidget.this.activeTask = null;
            TaskTrimWidget.this.indicateNoActiveTask();
        }
    };
    private final IPropertyChangeListener SHOW_TRIM_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("org.eclipse.mylyn.tasks.ui.show.trim")) {
                TaskTrimWidget.this.setTrimVisible((Boolean)event.getNewValue());
            }
        }
    };

    public TaskTrimWidget() {
        TasksUi.getTaskActivityManager().addActivationListener(this.TASK_ACTIVATION_LISTENER);
        TasksUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.SHOW_TRIM_LISTENER);
        this.hookContextMenu();
    }

    private void setTrimVisible(boolean visible) {
        IWindowTrim trim;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window instanceof WorkbenchWindow && (trim = ((WorkbenchWindow)window).getTrimManager().getTrim(ID_CONTAINER)) != null) {
            ((WorkbenchWindow)window).getTrimManager().setTrimVisible(trim, visible);
        }
    }

    public void dispose() {
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.dispose();
        }
        this.composite = null;
        if (this.menuManager != null) {
            this.menuManager.removeAll();
            this.menuManager.dispose();
        }
        this.menuManager = null;
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        TasksUi.getTaskActivityManager().removeActivationListener(this.TASK_ACTIVATION_LISTENER);
        TasksUiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.SHOW_TRIM_LISTENER);
    }

    protected Control createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, true));
        this.createStatusComposite(this.composite);
        parent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                IPreferenceStore uiPreferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
                TaskTrimWidget.this.setTrimVisible(uiPreferenceStore.getBoolean("org.eclipse.mylyn.tasks.ui.show.trim"));
            }
        });
        return this.composite;
    }

    private Composite createStatusComposite(final Composite container) {
        GC gc = new GC((Drawable)container);
        this.p = gc.textExtent("WWWWWWWWWWWWWWW");
        gc.dispose();
        this.activeTaskLabel = new TaskHyperlink(container, 131072);
        GridData gridData = new GridData(16384, 0x1000000, false, true);
        gridData.widthHint = this.p.x;
        gridData.minimumWidth = this.p.x;
        gridData.horizontalIndent = 0;
        this.activeTaskLabel.setLayoutData(gridData);
        this.activeTaskLabel.setText(Messages.TaskTrimWidget__no_task_active_);
        this.activeTask = TasksUi.getTaskActivityManager().getActiveTask();
        if (this.activeTask != null) {
            this.indicateActiveTask();
        }
        this.activeTaskLabel.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                if (TaskTrimWidget.this.menu != null) {
                    TaskTrimWidget.this.menu.dispose();
                }
                TaskTrimWidget.this.menu = TaskTrimWidget.this.menuManager.createContextMenu((Control)container);
                TaskTrimWidget.this.menu.setVisible(true);
            }
        });
        this.activeTaskLabel.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskListView taskListView = TaskListView.getFromActivePerspective();
                if (taskListView != null && taskListView.getDrilledIntoCategory() != null) {
                    taskListView.goUpToRoot();
                }
                TasksUiInternal.refreshAndOpenTaskListElement((IRepositoryElement)TasksUi.getTaskActivityManager().getActiveTask());
            }
        });
        this.activeTaskLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (TaskTrimWidget.this.activeTask == null) {
                    return;
                }
                TaskListView taskListView = TaskListView.getFromActivePerspective();
                if (taskListView != null && taskListView.getDrilledIntoCategory() != null) {
                    taskListView.goUpToRoot();
                }
                TasksUiInternal.refreshAndOpenTaskListElement((IRepositoryElement)TaskTrimWidget.this.activeTask);
            }
        });
        return this.activeTaskLabel;
    }

    private void hookContextMenu() {
        this.menuManager = new MenuManager("#PopupMenu");
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TaskTrimWidget.this.fillContextMenu(manager);
            }
        });
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this.activeTask != null) {
            StructuredSelection selection = new StructuredSelection((Object)this.activeTask);
            this.openWithBrowserAction.selectionChanged((IStructuredSelection)selection);
            this.copyTaskDetailsAction.selectionChanged((IStructuredSelection)selection);
            manager.add((IAction)new OpenTaskListElementAction(null){

                public void run() {
                    TasksUiInternal.refreshAndOpenTaskListElement((IRepositoryElement)TaskTrimWidget.this.activeTask);
                }
            });
            manager.add((IAction)this.openWithBrowserAction);
            if (TasksUiInternal.isValidUrl(this.activeTask.getUrl())) {
                this.openWithBrowserAction.setEnabled(true);
            } else {
                this.openWithBrowserAction.setEnabled(false);
            }
            if (this.activeTask.isActive()) {
                manager.add((IAction)new TaskDeactivateAction(){

                    public void run() {
                        super.run(TaskTrimWidget.this.activeTask);
                    }
                });
            } else {
                manager.add((IAction)new TaskActivateAction(){

                    public void run() {
                        super.run(TaskTrimWidget.this.activeTask);
                    }
                });
            }
            manager.add((IContributionItem)new Separator());
            for (String menuPath : TasksUiPlugin.getDefault().getDynamicMenuMap().keySet()) {
                for (IDynamicSubMenuContributor contributor : TasksUiPlugin.getDefault().getDynamicMenuMap().get(menuPath)) {
                    ArrayList<IRepositoryElement> selectedElements = new ArrayList<IRepositoryElement>();
                    selectedElements.add((IRepositoryElement)this.activeTask);
                    MenuManager subMenuManager = contributor.getSubMenuManager(selectedElements);
                    if (subMenuManager == null) continue;
                    manager.add((IContributionItem)subMenuManager);
                }
            }
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.copyTaskDetailsAction);
            manager.add((IContributionItem)new Separator());
            ObjectActionContributorManager.getManager().contributeObjectActions(null, manager, new ISelectionProvider(){

                public void addSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public ISelection getSelection() {
                    return new StructuredSelection((Object)TaskTrimWidget.this.activeTask);
                }

                public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public void setSelection(ISelection selection) {
                }
            });
        }
    }

    public void indicateActiveTask() {
        if (this.activeTaskLabel != null && this.activeTaskLabel.isDisposed()) {
            return;
        }
        this.activeTaskLabel.setText(this.activeTask.getSummary());
        this.activeTaskLabel.setUnderlined(true);
        this.activeTaskLabel.setToolTipText(this.activeTask.getSummary());
    }

    public void indicateNoActiveTask() {
        if (this.activeTaskLabel != null && this.activeTaskLabel.isDisposed()) {
            return;
        }
        this.activeTaskLabel.setText(Messages.TaskTrimWidget__no_active_task_);
        this.activeTaskLabel.setUnderlined(false);
        this.activeTaskLabel.setToolTipText("");
    }
}

