/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.ClipboardCopier;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class CopyTaskDetailsAction
extends BaseSelectionListenerAction {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.copy";
    private final ClipboardCopier copier;

    public CopyTaskDetailsAction() {
        super(Messages.CopyTaskDetailsAction_Copy_Details);
        this.setToolTipText(Messages.CopyTaskDetailsAction_Copy_Details);
        this.setId(ID);
        this.setImageDescriptor(CommonImages.COPY);
        this.copier = new ClipboardCopier(){

            protected String getTextForElement(Object element) {
                return CopyTaskDetailsAction.getTextForTask(element);
            }
        };
    }

    public void run() {
        this.copier.copy(this.getStructuredSelection());
    }

    public void dispose() {
        this.copier.dispose();
    }

    public static String getTextForTask(Object object) {
        StringBuffer sb = new StringBuffer();
        if (object instanceof ITask) {
            AbstractTask task = (AbstractTask)object;
            if (task.getTaskKey() != null) {
                sb.append(task.getTaskKey());
                sb.append(": ");
            }
            sb.append(task.getSummary());
            if (TasksUiInternal.isValidUrl(task.getUrl())) {
                sb.append(ClipboardCopier.LINE_SEPARATOR);
                sb.append(task.getUrl());
            }
        } else if (object instanceof IRepositoryQuery) {
            RepositoryQuery query = (RepositoryQuery)object;
            sb.append(query.getSummary());
            if (TasksUiInternal.isValidUrl(query.getUrl())) {
                sb.append(ClipboardCopier.LINE_SEPARATOR);
                sb.append(query.getUrl());
            }
        } else if (object instanceof IRepositoryElement) {
            IRepositoryElement element = (IRepositoryElement)object;
            sb.append(element.getSummary());
        }
        return sb.toString();
    }
}

