/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonsUiUtil;
import org.eclipse.mylyn.internal.provisional.commons.ui.ICoreRunnable;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITaskListRunnable;
import org.eclipse.mylyn.internal.tasks.core.UnsubmittedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.TaskRepositoryUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.AbstractTaskRepositoryAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.DeleteAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.internal.WorkbenchImages;

public class DeleteTaskRepositoryAction
extends AbstractTaskRepositoryAction {
    private static final String ID = "org.eclipse.mylyn.tasklist.repositories.delete";

    public DeleteTaskRepositoryAction() {
        super(Messages.DeleteTaskRepositoryAction_Delete_Repository);
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_DELETE"));
        this.setId(ID);
        this.setEnabled(false);
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.setSingleSelect(true);
    }

    public void init(IViewPart view) {
    }

    public void run() {
        boolean deleteConfirmed;
        Collection children;
        final TaskRepository repositoryToDelete = this.getTaskRepository(this.getStructuredSelection());
        if (repositoryToDelete == null) {
            return;
        }
        final ArrayList<IRepositoryQuery> queriesToDelete = new ArrayList<IRepositoryQuery>();
        final ArrayList<AbstractTask> tasksToDelete = new ArrayList<AbstractTask>();
        Set queries = TasksUiInternal.getTaskList().getQueries();
        for (IRepositoryQuery query : queries) {
            if (!repositoryToDelete.getRepositoryUrl().equals(query.getRepositoryUrl()) || !repositoryToDelete.getConnectorKind().equals(query.getConnectorKind())) continue;
            queriesToDelete.add(query);
        }
        Set tasks = TasksUiPlugin.getTaskList().getTasks(repositoryToDelete.getRepositoryUrl());
        for (ITask task : tasks) {
            if (!repositoryToDelete.getRepositoryUrl().equals(task.getRepositoryUrl()) || !repositoryToDelete.getConnectorKind().equals(task.getConnectorKind())) continue;
            tasksToDelete.add((AbstractTask)task);
        }
        UnsubmittedTaskContainer unsubmitted = TasksUiPlugin.getTaskList().getUnsubmittedContainer(repositoryToDelete.getRepositoryUrl());
        if (unsubmitted != null && (children = unsubmitted.getChildren()) != null) {
            for (ITask task : children) {
                tasksToDelete.add((AbstractTask)task);
            }
        }
        if (deleteConfirmed = queriesToDelete.size() > 0 || tasksToDelete.size() > 0 ? MessageDialog.openQuestion((Shell)TasksUiInternal.getShell(), (String)Messages.DeleteTaskRepositoryAction_Confirm_Delete, (String)NLS.bind((String)Messages.DeleteTaskRepositoryAction_Delete_the_selected_task_repositories, (Object[])new Integer[]{tasksToDelete.size(), queriesToDelete.size()})) : MessageDialog.openQuestion((Shell)TasksUiInternal.getShell(), (String)Messages.DeleteTaskRepositoryAction_Confirm_Delete, (String)NLS.bind((String)Messages.DeleteTaskRepositoryAction_Delete_Specific_Task_Repository, (Object[])new String[]{repositoryToDelete.getRepositoryLabel()}))) {
            ICoreRunnable op = new ICoreRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        monitor.beginTask(Messages.DeleteTaskRepositoryAction_Delete_Repository_In_Progress, -1);
                        DeleteAction.prepareDeletion(tasksToDelete);
                        DeleteAction.prepareDeletion(queriesToDelete);
                        TasksUiPlugin.getTaskList().run(new ITaskListRunnable(){

                            public void execute(IProgressMonitor monitor) throws CoreException {
                                DeleteAction.performDeletion(tasksToDelete);
                                DeleteAction.performDeletion(queriesToDelete);
                                TasksUiPlugin.getRepositoryManager().removeRepository(repositoryToDelete, TasksUiPlugin.getDefault().getRepositoriesFilePath());
                                TaskRepositoryUtil.disableAddAutomatically(repositoryToDelete.getRepositoryUrl());
                            }
                        }, monitor);
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                CommonsUiUtil.runInUi((ICoreRunnable)op, null);
            }
            catch (CoreException e) {
                Status status = new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"Problems encountered deleting task repository: {0}", (Object)e.getMessage()), (Throwable)e);
                TasksUiInternal.logAndDisplayStatus(Messages.DeleteTaskRepositoryAction_Delete_Task_Repository_Failed, (IStatus)status);
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
    }
}

