/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.ui.LocalRepositoryConnectorUi;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewQueryWizard;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class NewQueryAction
extends Action
implements IViewActionDelegate,
IExecutableExtension {
    private final String ID = "org.eclipse.mylyn.tasks.ui.new.query";
    private final String LABEL_NEW_QUERY = Messages.NewQueryAction_new_query_;
    private boolean skipRepositoryPage;

    public NewQueryAction() {
        this.setText(this.LABEL_NEW_QUERY);
        this.setToolTipText(this.LABEL_NEW_QUERY);
        this.setId("org.eclipse.mylyn.tasks.ui.new.query");
        this.setImageDescriptor(TasksUiImages.QUERY_NEW);
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        NewQueryWizard wizard = null;
        List repositories = TasksUi.getRepositoryManager().getAllRepositories();
        if (repositories.size() == 2) {
            for (TaskRepository taskRepository : repositories) {
                AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(taskRepository.getConnectorKind());
                if (connectorUi instanceof LocalRepositoryConnectorUi || (wizard = connectorUi.getQueryWizard(taskRepository, null)) == null) continue;
                ((Wizard)wizard).setForcePreviousAndNextButtons(true);
            }
        } else if (this.skipRepositoryPage) {
            TaskRepository taskRepository;
            taskRepository = TasksUiUtil.getSelectedRepository();
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(taskRepository.getConnectorKind());
            wizard = connectorUi.getQueryWizard(taskRepository, null);
            ((Wizard)wizard).setForcePreviousAndNextButtons(true);
            if (connectorUi instanceof LocalRepositoryConnectorUi) {
                wizard.performFinish();
                return;
            }
        } else {
            wizard = new NewQueryWizard();
        }
        try {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (shell != null && !shell.isDisposed()) {
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.create();
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 1) {
                    dialog.close();
                    return;
                }
            }
        }
        catch (Exception e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", e.getMessage(), (Throwable)e));
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if ("skipFirstPage".equals(data)) {
            this.skipRepositoryPage = true;
        }
    }

    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

