/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonColors;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskActivationHistory;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewTaskAction;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskDetailLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListFilteredTree;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.internal.tasks.ui.workingsets.TaskWorkingSetUpdater;
import org.eclipse.mylyn.internal.tasks.ui.workingsets.WorkingSetLabelComparator;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.ui.TaskElementLabelProvider;
import org.eclipse.search.internal.ui.SearchDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class TaskSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final int SEARCH_ID = 1025;
    private static final int CREATE_ID = 1026;
    private static final String IS_USING_WINDOW_WORKING_SET_SETTING = "IsUsingWindowWorkingSet";
    private static final String OPEN_IN_BROWSER_SETTING = "OpenInBrowser";
    private static final String SHOW_COMPLETED_TASKS_SETTING = "ShowCompletedTasks";
    private static final String TASK_SELECTION_DIALOG_SECTION = "TaskSelectionDialogSection";
    private static final String WORKING_SET_NAME_SETTING = "WorkingSetName";
    private Set<AbstractTask> allTasks;
    private Button createTaskButton;
    private final LinkedHashSet<AbstractTask> history;
    private final TaskHistoryItemsComparator itemsComparator;
    private final TaskElementLabelProvider labelProvider;
    private boolean needsCreateTask = true;
    private boolean openInBrowser;
    private Button openInBrowserCheck;
    private IWorkingSet selectedWorkingSet;
    private boolean showCompletedTasks;
    private final ShowCompletedTasksAction showCompletedTasksAction;
    private boolean showExtendedOpeningOptions;
    private final IWorkingSet windowWorkingSet;
    private final IPropertyChangeListener workingSetListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("workingSetContentChange") && event.getNewValue().equals(TaskSelectionDialog.this.selectedWorkingSet)) {
                TaskSelectionDialog.this.applyFilter();
            }
        }
    };
    private final TaskActivationHistory taskActivationHistory = TasksUiPlugin.getTaskActivityManager().getTaskActivationHistory();

    public TaskSelectionDialog(Shell parent) {
        super(parent);
        this.history = new LinkedHashSet(this.taskActivationHistory.getPreviousTasks());
        this.itemsComparator = new TaskHistoryItemsComparator(new ArrayList<AbstractTask>(this.history));
        this.labelProvider = new TaskElementLabelProvider(false);
        this.showCompletedTasksAction = new ShowCompletedTasksAction();
        this.setSelectionHistory(new TaskSelectionHistory());
        this.setListLabelProvider((ILabelProvider)this.labelProvider);
        this.setDetailsLabelProvider(new TaskDetailLabelProvider());
        this.setSeparatorLabel(String.valueOf(TaskListView.LABEL_VIEW) + Messages.TaskSelectionDialog__matches);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection selection = window.getSelectionService().getSelection();
        if (selection instanceof ITextSelection) {
            String text = ((ITextSelection)selection).getText();
            int n = text.indexOf(10);
            if (n > -1) {
                text.substring(0, n);
            }
            this.setInitialPattern(text);
        }
        this.selectedWorkingSet = this.windowWorkingSet = window.getActivePage().getAggregateWorkingSet();
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.workingSetListener);
    }

    public boolean close() {
        PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.workingSetListener);
        if (this.openInBrowserCheck != null) {
            this.openInBrowser = this.openInBrowserCheck.getSelection();
        }
        return super.close();
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        if (this.isHelpAvailable()) {
            this.createHelpControl(composite);
        }
        if (this.needsCreateTask) {
            this.createTaskButton = this.createButton(composite, 1026, Messages.TaskSelectionDialog_New_Task_, true);
            this.createTaskButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    TaskSelectionDialog.this.close();
                    new NewTaskAction().run();
                }
            });
        }
        Label filler = new Label(composite, 0);
        filler.setLayoutData((Object)new GridData(768));
        ++layout.numColumns;
        super.createButtonsForButtonBar(composite);
        return composite;
    }

    protected Control createExtendedContentArea(Composite parent) {
        if (!this.showExtendedOpeningOptions) {
            return null;
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 5).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.openInBrowserCheck = new Button(composite, 32);
        this.openInBrowserCheck.setText(Messages.TaskSelectionDialog_Open_with_Browser);
        this.openInBrowserCheck.setSelection(this.openInBrowser);
        ImageHyperlink openHyperlink = new ImageHyperlink(composite, 0);
        openHyperlink.setText(TaskListFilteredTree.LABEL_SEARCH);
        openHyperlink.setForeground(CommonColors.HYPERLINK_WIDGET);
        openHyperlink.setUnderlined(true);
        openHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskSelectionDialog.this.getShell().close();
                new SearchDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "org.eclipse.mylyn.tasks.ui.search.page").open();
            }
        });
        return composite;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new TasksFilter(this.showCompletedTasks, this.selectedWorkingSet);
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        progressMonitor.beginTask(Messages.TaskSelectionDialog_Search_for_tasks, 100);
        if (this.allTasks == null) {
            this.allTasks = new HashSet<AbstractTask>();
            TaskList taskList = TasksUiPlugin.getTaskList();
            this.allTasks.addAll(taskList.getAllTasks());
        }
        progressMonitor.worked(10);
        SubProgressMonitor subMonitor = new SubProgressMonitor(progressMonitor, 90);
        subMonitor.beginTask(Messages.TaskSelectionDialog_Scanning_tasks, this.allTasks.size());
        for (ITask iTask : this.allTasks) {
            contentProvider.add((Object)iTask, itemsFilter);
            subMonitor.worked(1);
        }
        subMonitor.done();
        progressMonitor.done();
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        super.fillViewMenu(menuManager);
        menuManager.add((IAction)this.showCompletedTasksAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)new SelectWorkingSetAction());
        final DeselectWorkingSetAction deselectAction = new DeselectWorkingSetAction();
        menuManager.add((IAction)deselectAction);
        final EditWorkingSetAction editAction = new EditWorkingSetAction();
        menuManager.add((IAction)editAction);
        menuManager.add((IContributionItem)new Separator("lruActions"));
        final FilterWorkingSetAction windowWorkingSetAction = new FilterWorkingSetAction(this.windowWorkingSet, 1);
        menuManager.add((IAction)windowWorkingSetAction);
        menuManager.addMenuListener(new IMenuListener(){
            private final List<ActionContributionItem> lruActions = new ArrayList<ActionContributionItem>();

            public void menuAboutToShow(IMenuManager manager) {
                deselectAction.setEnabled(TaskSelectionDialog.this.selectedWorkingSet != null);
                editAction.setEnabled(TaskSelectionDialog.this.selectedWorkingSet != null && TaskSelectionDialog.this.selectedWorkingSet.isEditable());
                for (ActionContributionItem action : this.lruActions) {
                    manager.remove((IContributionItem)action);
                }
                this.lruActions.clear();
                IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getRecentWorkingSets();
                Arrays.sort(workingSets, new WorkingSetLabelComparator());
                int count = 2;
                IWorkingSet[] iWorkingSetArray = workingSets;
                int n = workingSets.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkingSet workingSet = iWorkingSetArray[n2];
                    if (workingSet.getId().equalsIgnoreCase(TaskWorkingSetUpdater.ID_TASK_WORKING_SET)) {
                        FilterWorkingSetAction action = new FilterWorkingSetAction(workingSet, count++);
                        if (workingSet.equals(TaskSelectionDialog.this.selectedWorkingSet)) {
                            action.setChecked(true);
                        }
                        ActionContributionItem ci = new ActionContributionItem((IAction)action);
                        this.lruActions.add(ci);
                        manager.appendToGroup("lruActions", (IContributionItem)ci);
                    }
                    ++n2;
                }
                windowWorkingSetAction.setChecked(TaskSelectionDialog.this.windowWorkingSet.equals(TaskSelectionDialog.this.selectedWorkingSet));
            }
        });
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = TasksUiPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(TASK_SELECTION_DIALOG_SECTION);
        if (section == null) {
            section = settings.addNewSection(TASK_SELECTION_DIALOG_SECTION);
            section.put(OPEN_IN_BROWSER_SETTING, false);
            section.put(SHOW_COMPLETED_TASKS_SETTING, true);
            section.put(IS_USING_WINDOW_WORKING_SET_SETTING, true);
            section.put(WORKING_SET_NAME_SETTING, "");
        }
        return section;
    }

    public String getElementName(Object item) {
        return this.labelProvider.getText(item);
    }

    protected Comparator getItemsComparator() {
        return this.itemsComparator;
    }

    public boolean getOpenInBrowser() {
        return this.openInBrowser;
    }

    public boolean getShowExtendedOpeningOptions() {
        return this.showExtendedOpeningOptions;
    }

    public boolean needsCreateTask() {
        return this.needsCreateTask;
    }

    protected void restoreDialog(IDialogSettings settings) {
        this.openInBrowser = settings.getBoolean(OPEN_IN_BROWSER_SETTING);
        this.showCompletedTasks = settings.getBoolean(SHOW_COMPLETED_TASKS_SETTING);
        this.showCompletedTasksAction.setChecked(this.showCompletedTasks);
        boolean isUsingWindowWorkingSet = settings.getBoolean(IS_USING_WINDOW_WORKING_SET_SETTING);
        if (isUsingWindowWorkingSet) {
            this.selectedWorkingSet = this.windowWorkingSet;
        } else {
            String workingSetName = settings.get(WORKING_SET_NAME_SETTING);
            if (workingSetName != null) {
                this.selectedWorkingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(workingSetName);
            }
        }
        super.restoreDialog(settings);
    }

    public void setNeedsCreateTask(boolean value) {
        this.needsCreateTask = value;
    }

    public void setOpenInBrowser(boolean openInBrowser) {
        this.openInBrowser = openInBrowser;
    }

    private void setSelectedWorkingSet(IWorkingSet workingSet) {
        this.selectedWorkingSet = workingSet;
        if (workingSet != null) {
            PlatformUI.getWorkbench().getWorkingSetManager().addRecentWorkingSet(workingSet);
        }
        this.applyFilter();
    }

    public void setShowExtendedOpeningOptions(boolean showExtendedOpeningOptions) {
        this.showExtendedOpeningOptions = showExtendedOpeningOptions;
    }

    protected void storeDialog(IDialogSettings settings) {
        settings.put(OPEN_IN_BROWSER_SETTING, this.openInBrowser);
        settings.put(SHOW_COMPLETED_TASKS_SETTING, this.showCompletedTasks);
        settings.put(IS_USING_WINDOW_WORKING_SET_SETTING, this.selectedWorkingSet == this.windowWorkingSet);
        if (this.selectedWorkingSet == null) {
            settings.put(WORKING_SET_NAME_SETTING, "");
        } else {
            settings.put(WORKING_SET_NAME_SETTING, this.selectedWorkingSet.getName());
        }
        super.storeDialog(settings);
    }

    protected IStatus validateItem(Object item) {
        if (item instanceof ITask) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.mylyn.tasks.ui", Messages.TaskSelectionDialog_Selected_item_is_not_a_task);
    }

    private class DeselectWorkingSetAction
    extends Action {
        public DeselectWorkingSetAction() {
            super(Messages.TaskSelectionDialog_Deselect_Working_Set, 1);
        }

        public void run() {
            TaskSelectionDialog.this.setSelectedWorkingSet(null);
        }
    }

    private class EditWorkingSetAction
    extends Action {
        public EditWorkingSetAction() {
            super(Messages.TaskSelectionDialog_Edit_Active_Working_Set_, 1);
        }

        public void run() {
            IWorkingSetEditWizard wizard = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetEditWizard(TaskSelectionDialog.this.selectedWorkingSet);
            if (wizard != null) {
                WizardDialog dlg = new WizardDialog(TaskSelectionDialog.this.getShell(), (IWizard)wizard);
                dlg.open();
            }
        }
    }

    private class FilterWorkingSetAction
    extends Action {
        private final IWorkingSet workingSet;

        public FilterWorkingSetAction(IWorkingSet workingSet, int shortcutKeyNumber) {
            super("", 8);
            this.workingSet = workingSet;
            if (shortcutKeyNumber >= 1 && shortcutKeyNumber <= 9) {
                this.setText("&" + String.valueOf(shortcutKeyNumber) + " " + workingSet.getLabel());
            } else {
                this.setText(workingSet.getLabel());
            }
            this.setImageDescriptor(workingSet.getImageDescriptor());
        }

        public void run() {
            TaskSelectionDialog.this.setSelectedWorkingSet(this.workingSet);
        }
    }

    private class SelectWorkingSetAction
    extends Action {
        public SelectWorkingSetAction() {
            super(Messages.TaskSelectionDialog_Select_Working_Set_, 1);
        }

        public void run() {
            IWorkingSetSelectionDialog dlg = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(TaskSelectionDialog.this.getShell(), false, new String[]{TaskWorkingSetUpdater.ID_TASK_WORKING_SET});
            if (TaskSelectionDialog.this.selectedWorkingSet != null) {
                dlg.setSelection(new IWorkingSet[]{TaskSelectionDialog.this.selectedWorkingSet});
            }
            if (dlg.open() == 0) {
                IWorkingSet[] selection = dlg.getSelection();
                if (selection.length == 0) {
                    TaskSelectionDialog.this.setSelectedWorkingSet(null);
                } else {
                    TaskSelectionDialog.this.setSelectedWorkingSet(selection[0]);
                }
            }
        }
    }

    private class ShowCompletedTasksAction
    extends Action {
        public ShowCompletedTasksAction() {
            super(Messages.TaskSelectionDialog_Show_Completed_Tasks, 2);
        }

        public void run() {
            TaskSelectionDialog.this.showCompletedTasks = this.isChecked();
            TaskSelectionDialog.this.applyFilter();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskHistoryItemsComparator
    implements Comparator<Object> {
        Map<AbstractTask, Integer> positionByTask = new HashMap<AbstractTask, Integer>();

        public TaskHistoryItemsComparator(List<AbstractTask> history) {
            int i = 0;
            while (i < history.size()) {
                this.positionByTask.put(history.get(i), i);
                ++i;
            }
        }

        @Override
        public int compare(Object o1, Object o2) {
            Integer p1 = this.positionByTask.get(o1);
            Integer p2 = this.positionByTask.get(o2);
            if (p1 != null && p2 != null) {
                return p2.compareTo(p1);
            }
            return TaskSelectionDialog.this.labelProvider.getText(o1).compareTo(TaskSelectionDialog.this.labelProvider.getText(o2));
        }
    }

    private class TaskSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private TaskSelectionHistory() {
        }

        public synchronized void accessed(Object object) {
        }

        public synchronized boolean contains(Object object) {
            return TaskSelectionDialog.this.history.contains(object);
        }

        public synchronized Object[] getHistoryItems() {
            return TaskSelectionDialog.this.history.toArray();
        }

        public synchronized boolean isEmpty() {
            return TaskSelectionDialog.this.history.isEmpty();
        }

        public void load(IMemento memento) {
        }

        public synchronized boolean remove(Object object) {
            TaskSelectionDialog.this.taskActivationHistory.removeTask((ITask)object);
            return TaskSelectionDialog.this.history.remove(object);
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            return null;
        }

        public void save(IMemento memento) {
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
        }
    }

    private class TasksFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private Set<ITask> allTasksFromWorkingSets;
        private final Set<AbstractTaskContainer> elements;
        private final boolean showCompletedTasks;

        public TasksFilter(boolean showCompletedTasks, IWorkingSet selectedWorkingSet) {
            super((FilteredItemsSelectionDialog)TaskSelectionDialog.this, new SearchPattern());
            this.patternMatcher.setPattern("*" + this.patternMatcher.getPattern());
            this.showCompletedTasks = showCompletedTasks;
            this.elements = new HashSet<AbstractTaskContainer>();
            if (selectedWorkingSet != null) {
                IAdaptable[] iAdaptableArray = selectedWorkingSet.getElements();
                int n = iAdaptableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAdaptable adaptable = iAdaptableArray[n2];
                    AbstractTaskContainer container = (AbstractTaskContainer)adaptable.getAdapter(AbstractTaskContainer.class);
                    if (container != null) {
                        this.elements.add(container);
                    }
                    ++n2;
                }
            }
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.equalsFilter(filter)) {
                return false;
            }
            if (filter instanceof TasksFilter) {
                TasksFilter tasksFilter = (TasksFilter)filter;
                if (this.showCompletedTasks != tasksFilter.showCompletedTasks) {
                    return false;
                }
                return this.elements.equals(tasksFilter.elements);
            }
            return true;
        }

        public boolean isConsistentItem(Object item) {
            return item instanceof ITask;
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.isSubFilter(filter)) {
                return false;
            }
            if (filter instanceof TasksFilter) {
                TasksFilter tasksFilter = (TasksFilter)filter;
                if (!this.showCompletedTasks && tasksFilter.showCompletedTasks) {
                    return false;
                }
                if (this.elements.isEmpty()) {
                    return true;
                }
                if (tasksFilter.elements.isEmpty()) {
                    return false;
                }
                return this.elements.containsAll(tasksFilter.elements);
            }
            return true;
        }

        public boolean matchItem(Object item) {
            if (!(item instanceof ITask)) {
                return false;
            }
            if (!this.showCompletedTasks && ((ITask)item).isCompleted()) {
                return false;
            }
            if (!this.elements.isEmpty()) {
                if (this.allTasksFromWorkingSets == null) {
                    this.populateTasksFromWorkingSets();
                }
                if (!this.allTasksFromWorkingSets.contains(item)) {
                    return false;
                }
            }
            return this.matches(TaskSelectionDialog.this.labelProvider.getText(item));
        }

        private void populateTasksFromWorkingSets() {
            this.allTasksFromWorkingSets = new HashSet<ITask>(1000);
            for (ITaskContainer iTaskContainer : this.elements) {
                this.allTasksFromWorkingSets.addAll(iTaskContainer.getChildren());
            }
        }
    }
}

