/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.DatePicker;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class DateAttributeEditor
extends AbstractAttributeEditor {
    private DatePicker datePicker;
    private boolean showTime;

    public DateAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.SINGLE));
    }

    public void createControl(Composite composite, FormToolkit toolkit) {
        if (this.isReadOnly()) {
            Text text = new Text(composite, 0x800008);
            text.setFont(EditorUtil.TEXT_FONT);
            toolkit.adapt((Control)text, false, false);
            text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            text.setText(this.getTextValue());
            this.setControl((Control)text);
        } else {
            Composite dateWithClearComposite = toolkit.createComposite(composite);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 2;
            layout.marginWidth = 1;
            layout.verticalSpacing = 2;
            layout.horizontalSpacing = 2;
            dateWithClearComposite.setLayout((Layout)layout);
            this.datePicker = new DatePicker(dateWithClearComposite, 0x800000, this.getTextValue(), this.showTime, 0);
            this.datePicker.setFont(EditorUtil.TEXT_FONT);
            if (!this.showTime) {
                this.datePicker.setDateFormat(EditorUtil.getDateFormat());
            } else {
                this.datePicker.setDateFormat(EditorUtil.getDateTimeFormat());
            }
            if (this.getValue() != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.getValue());
                this.datePicker.setDate(cal);
            }
            this.datePicker.addPickerSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Calendar cal = DateAttributeEditor.this.datePicker.getDate();
                    if (cal != null) {
                        Date value;
                        if (!DateAttributeEditor.this.showTime) {
                            TaskActivityUtil.snapStartOfDay((Calendar)cal);
                        }
                        if (!(value = cal.getTime()).equals(DateAttributeEditor.this.getValue())) {
                            DateAttributeEditor.this.setValue(value);
                        }
                    } else {
                        if (DateAttributeEditor.this.getValue() != null) {
                            DateAttributeEditor.this.setValue(null);
                        }
                        DateAttributeEditor.this.datePicker.setDate(null);
                    }
                }
            });
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.datePicker);
            this.datePicker.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            toolkit.adapt((Control)this.datePicker, false, false);
            ImageHyperlink clearDeadlineDate = toolkit.createImageHyperlink(dateWithClearComposite, 0);
            clearDeadlineDate.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.REMOVE));
            clearDeadlineDate.setToolTipText(Messages.DateAttributeEditor_Clear);
            clearDeadlineDate.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    if (DateAttributeEditor.this.getValue() != null) {
                        DateAttributeEditor.this.setValue(null);
                    }
                    DateAttributeEditor.this.datePicker.setDate(null);
                }
            });
            toolkit.paintBordersFor(dateWithClearComposite);
            this.setControl((Control)dateWithClearComposite);
        }
    }

    protected void decorateIncoming(Color color) {
        if (this.datePicker != null) {
            this.datePicker.setBackground(color);
        }
    }

    public boolean getShowTime() {
        return this.showTime;
    }

    private String getTextValue() {
        Date date = this.getValue();
        if (date != null) {
            if (this.getShowTime()) {
                return EditorUtil.formatDateTime(date);
            }
            return EditorUtil.formatDate(date);
        }
        return "";
    }

    public Date getValue() {
        return this.getAttributeMapper().getDateValue(this.getTaskAttribute());
    }

    public void setShowTime(boolean showTime) {
        this.showTime = showTime;
    }

    public void setValue(Date date) {
        this.getAttributeMapper().setDateValue(this.getTaskAttribute(), date);
        this.attributeChanged();
    }
}

