/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonTextSupport;
import org.eclipse.mylyn.internal.tasks.ui.commands.ViewSourceHandler;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractHyperlinkTextPresentationManager;
import org.eclipse.mylyn.internal.tasks.ui.editors.BrowserPreviewViewer;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.FillWidthLayout;
import org.eclipse.mylyn.internal.tasks.ui.editors.HighlightingHyperlinkTextPresentationManager;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewerConfiguration;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskHyperlinkTextPresentationManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRenderingEngine;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorExtension;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.themes.IThemeManager;

public class RichTextAttributeEditor
extends AbstractAttributeEditor {
    private IContextActivation contextActivation;
    private final IContextService contextService;
    private SourceViewer defaultViewer;
    private Composite editorComposite;
    private StackLayout editorLayout;
    private final AbstractTaskEditorExtension extension;
    private SourceViewer editorViewer;
    private SourceViewer previewViewer;
    private final TaskRepository taskRepository;
    private FormToolkit toolkit;
    private final IAction viewSourceAction = new ViewSourceAction();
    private boolean spellCheckingEnabled;
    private final int style;
    private RepositoryTextViewerConfiguration.Mode mode;
    private AbstractRenderingEngine renderingEngine;
    private BrowserPreviewViewer browserViewer;

    public RichTextAttributeEditor(TaskDataModel manager, TaskRepository taskRepository, TaskAttribute taskAttribute) {
        this(manager, taskRepository, taskAttribute, 2);
    }

    public RichTextAttributeEditor(TaskDataModel manager, TaskRepository taskRepository, TaskAttribute taskAttribute, int style) {
        this(manager, taskRepository, taskAttribute, style, null, null);
    }

    public RichTextAttributeEditor(TaskDataModel manager, TaskRepository taskRepository, TaskAttribute taskAttribute, int style, IContextService contextService, AbstractTaskEditorExtension extension) {
        super(manager, taskAttribute);
        this.taskRepository = taskRepository;
        this.style = style;
        this.contextService = contextService;
        this.extension = extension;
        if ((style & 2) != 0) {
            this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.MULTIPLE, LayoutHint.ColumnSpan.MULTIPLE));
        } else {
            this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.MULTIPLE));
        }
        this.setMode(RepositoryTextViewerConfiguration.Mode.DEFAULT);
    }

    public RepositoryTextViewerConfiguration.Mode getMode() {
        return this.mode;
    }

    public void setMode(RepositoryTextViewerConfiguration.Mode mode) {
        Assert.isNotNull((Object)((Object)mode));
        this.mode = mode;
    }

    private void installListeners(final SourceViewer viewer) {
        viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                String value = viewer.getTextWidget().getText();
                if (!RichTextAttributeEditor.this.getValue().equals(value)) {
                    RichTextAttributeEditor.this.setValue(value);
                    EditorUtil.ensureVisible((Control)viewer.getTextWidget());
                }
            }
        });
        if ((this.style & 2) != 0 && this.mode != RepositoryTextViewerConfiguration.Mode.DEFAULT) {
            viewer.getTextWidget().addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    switch (event.detail) {
                        case 8: 
                        case 16: {
                            event.doit = true;
                        }
                    }
                }
            });
        }
    }

    public String getValue() {
        return this.getAttributeMapper().getValue(this.getTaskAttribute());
    }

    public boolean isSpellCheckingEnabled() {
        return this.spellCheckingEnabled;
    }

    public void setSpellCheckingEnabled(boolean spellCheckingEnabled) {
        this.spellCheckingEnabled = spellCheckingEnabled;
    }

    public void setValue(String value) {
        this.getAttributeMapper().setValue(this.getTaskAttribute(), value);
        this.attributeChanged();
    }

    private void configureAsEditor(SourceViewer viewer, Document document) {
        AnnotationModel annotationModel = new AnnotationModel();
        viewer.showAnnotations(false);
        viewer.showAnnotationsOverview(false);
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        final SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)viewer, null, (IAnnotationAccess)annotationAccess, EditorsUI.getSharedTextColors());
        Iterator e = new MarkerAnnotationPreferences().getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)e.next());
        }
        support.install(EditorsUI.getPreferenceStore());
        viewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                support.uninstall();
            }
        });
        viewer.setDocument((IDocument)document, (IAnnotationModel)annotationModel);
    }

    private RepositoryTextViewerConfiguration installHyperlinkPresenter(SourceViewer viewer) {
        RepositoryTextViewerConfiguration configuration = new RepositoryTextViewerConfiguration(this.taskRepository, false);
        configuration.setMode(this.getMode());
        if (this.getMode() == RepositoryTextViewerConfiguration.Mode.DEFAULT) {
            AbstractHyperlinkTextPresentationManager manager = new HighlightingHyperlinkTextPresentationManager();
            manager.setHyperlinkDetectors(configuration.getDefaultHyperlinkDetectors((ISourceViewer)viewer, null));
            manager.install((ISourceViewer)viewer);
            manager = new TaskHyperlinkTextPresentationManager();
            manager.setHyperlinkDetectors(configuration.getDefaultHyperlinkDetectors((ISourceViewer)viewer, RepositoryTextViewerConfiguration.Mode.TASK));
            manager.install((ISourceViewer)viewer);
        } else if (this.getMode() == RepositoryTextViewerConfiguration.Mode.TASK_RELATION) {
            TaskHyperlinkTextPresentationManager manager = new TaskHyperlinkTextPresentationManager();
            manager.setHyperlinkDetectors(configuration.getDefaultHyperlinkDetectors((ISourceViewer)viewer, RepositoryTextViewerConfiguration.Mode.TASK_RELATION));
            manager.install((ISourceViewer)viewer);
        }
        return configuration;
    }

    private SourceViewer configure(SourceViewer viewer, boolean readOnly) {
        this.installHyperlinkPresenter(viewer);
        Document document = new Document(this.getValue());
        if (readOnly) {
            viewer.setDocument((IDocument)document);
            if (this.extension != null) {
                viewer.getControl().setData("viewSourceAction", (Object)this.viewSourceAction);
                viewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusGained(FocusEvent e) {
                        ViewSourceHandler.setChecked(RichTextAttributeEditor.this.getViewer() == RichTextAttributeEditor.this.defaultViewer);
                    }
                });
            }
        } else {
            this.configureAsEditor(viewer, document);
            this.installListeners(viewer);
            viewer.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        }
        CommonTextSupport.setTextViewer((Widget)viewer.getTextWidget(), (TextViewer)viewer);
        viewer.setEditable(!readOnly);
        viewer.getTextWidget().setFont(this.getFont());
        this.toolkit.adapt(viewer.getControl(), false, false);
        return viewer;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.toolkit = toolkit;
        int style = this.style;
        if (!this.isReadOnly() && (style & 0x10) == 0) {
            style |= 0x200;
        }
        if (this.extension != null || this.renderingEngine != null) {
            this.editorComposite = new Composite(parent, 0);
            this.editorLayout = new StackLayout(){

                protected Point computeSize(Composite composite, int hint, int hint2, boolean flushCache) {
                    return this.topControl.computeSize(hint, hint2, flushCache);
                }
            };
            this.editorComposite.setLayout((Layout)this.editorLayout);
            this.setControl((Control)this.editorComposite);
            if (this.extension != null) {
                if (this.isReadOnly()) {
                    this.editorViewer = this.extension.createViewer(this.taskRepository, this.editorComposite, style);
                } else {
                    this.editorViewer = this.extension.createEditor(this.taskRepository, this.editorComposite, style);
                    this.editorViewer.getTextWidget().addFocusListener(new FocusListener(){

                        public void focusGained(FocusEvent e) {
                            RichTextAttributeEditor.this.setContext();
                        }

                        public void focusLost(FocusEvent e) {
                            RichTextAttributeEditor.this.unsetContext();
                        }
                    });
                    this.editorViewer.getTextWidget().addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            RichTextAttributeEditor.this.unsetContext();
                        }
                    });
                }
                this.configure(this.editorViewer, this.isReadOnly());
                this.show(this.editorViewer);
            } else {
                this.defaultViewer = this.createDefaultEditor(this.editorComposite, style);
                this.configure(this.defaultViewer, this.isReadOnly());
                this.show(this.defaultViewer);
            }
            this.viewSourceAction.setEnabled(true);
        } else {
            this.defaultViewer = this.createDefaultEditor(parent, style);
            this.configure(this.defaultViewer, this.isReadOnly());
            this.setControl(this.defaultViewer.getControl());
            this.viewSourceAction.setEnabled(false);
        }
    }

    private SourceViewer createDefaultEditor(Composite parent, int styles) {
        SourceViewer defaultEditor = new SourceViewer(parent, null, styles | 0x40);
        RepositoryTextViewerConfiguration viewerConfig = new RepositoryTextViewerConfiguration(this.taskRepository, this.isSpellCheckingEnabled() && !this.isReadOnly());
        viewerConfig.setMode(this.getMode());
        defaultEditor.configure((SourceViewerConfiguration)viewerConfig);
        return defaultEditor;
    }

    public SourceViewer getDefaultViewer() {
        if (this.defaultViewer == null) {
            this.defaultViewer = this.createDefaultEditor(this.editorComposite, this.style);
            this.configure(this.defaultViewer, this.isReadOnly());
            this.defaultViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
            this.defaultViewer.getControl().setData("maximizeAction", this.editorViewer.getControl().getData("maximizeAction"));
            this.installMenu(this.defaultViewer.getControl(), this.editorViewer.getControl().getMenu());
        }
        return this.defaultViewer;
    }

    private void installMenu(final Control control, Menu menu) {
        if (menu != null) {
            control.setMenu(menu);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    control.setMenu(null);
                }
            });
        }
    }

    private Font getFont() {
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        Font font = themeManager.getCurrentTheme().getFontRegistry().get("org.eclipse.mylyn.tasks.ui.fonts.task.editor.comment");
        return font;
    }

    private SourceViewer getPreviewViewer() {
        if (this.extension == null) {
            return null;
        }
        if (this.previewViewer == null) {
            int previewViewerStyle = this.style;
            if (this.getEditorViewer() != null) {
                previewViewerStyle |= 0x200;
            }
            this.previewViewer = this.extension.createViewer(this.taskRepository, this.editorComposite, previewViewerStyle);
            this.configure(this.previewViewer, true);
            this.previewViewer.getControl().setData("maximizeAction", this.editorViewer.getControl().getData("maximizeAction"));
        }
        Document document = new Document(this.editorViewer.getDocument().get());
        this.previewViewer.setDocument((IDocument)document);
        return this.previewViewer;
    }

    public SourceViewer getEditorViewer() {
        return this.editorViewer;
    }

    public SourceViewer getViewer() {
        if (this.editorLayout == null) {
            return this.defaultViewer;
        }
        if (this.defaultViewer != null && this.editorLayout.topControl == this.defaultViewer.getControl()) {
            return this.defaultViewer;
        }
        if (this.previewViewer != null && this.editorLayout.topControl == this.previewViewer.getControl()) {
            return this.previewViewer;
        }
        return this.editorViewer;
    }

    private void setContext() {
        if (this.contextService == null) {
            return;
        }
        if (this.contextActivation != null) {
            this.contextService.deactivateContext(this.contextActivation);
            this.contextActivation = null;
        }
        if (this.contextService != null && this.extension.getEditorContextId() != null) {
            this.contextActivation = this.contextService.activateContext(this.extension.getEditorContextId());
        }
    }

    private void show(SourceViewer viewer) {
        this.show(viewer.getControl());
    }

    private void show(Control control) {
        if (this.editorComposite == null) {
            return;
        }
        this.editorLayout.topControl = control;
        if (this.editorComposite.getParent().getLayout() instanceof FillWidthLayout) {
            ((FillWidthLayout)this.editorComposite.getParent().getLayout()).flush();
        }
        this.editorComposite.layout();
        control.setFocus();
    }

    public void showDefault() {
        this.show(this.getDefaultViewer());
    }

    public void showPreview() {
        if (!this.isReadOnly()) {
            this.show(this.getPreviewViewer());
        }
    }

    public void showEditor() {
        if (this.getEditorViewer() != null) {
            this.show(this.getEditorViewer());
        } else {
            this.show(this.getDefaultViewer());
        }
    }

    private void unsetContext() {
        if (this.contextService == null) {
            return;
        }
        if (this.contextActivation != null) {
            this.contextService.deactivateContext(this.contextActivation);
            this.contextActivation = null;
        }
    }

    public boolean hasPreview() {
        return this.extension != null && !this.isReadOnly();
    }

    public boolean hasBrowser() {
        return this.renderingEngine != null;
    }

    private BrowserPreviewViewer getBrowserViewer() {
        if (this.editorComposite == null || this.renderingEngine == null) {
            return null;
        }
        if (this.browserViewer == null) {
            this.browserViewer = new BrowserPreviewViewer(this.getModel().getTaskRepository(), this.renderingEngine);
            this.browserViewer.createControl(this.editorComposite, this.toolkit);
        }
        return this.browserViewer;
    }

    public AbstractRenderingEngine getRenderingEngine() {
        return this.renderingEngine;
    }

    public void setRenderingEngine(AbstractRenderingEngine renderingEngine) {
        this.renderingEngine = renderingEngine;
    }

    public void showBrowser() {
        BrowserPreviewViewer viewer = this.getBrowserViewer();
        viewer.update(this.getValue());
        if (viewer != null) {
            this.show((Control)viewer.getControl());
        }
    }

    public IAction getViewSourceAction() {
        return this.viewSourceAction;
    }

    public class ViewSourceAction
    extends Action {
        public ViewSourceAction() {
            super(Messages.RichTextAttributeEditor_Viewer_Source, 2);
            this.setChecked(false);
            this.setEnabled(false);
        }

        public void run() {
            if (this.isChecked()) {
                RichTextAttributeEditor.this.showDefault();
            } else {
                RichTextAttributeEditor.this.showEditor();
            }
            if (RichTextAttributeEditor.this.editorLayout != null) {
                EditorUtil.reflow(((RichTextAttributeEditor)RichTextAttributeEditor.this).editorLayout.topControl);
            }
            ViewSourceHandler.setChecked(this.isChecked());
        }
    }
}

