/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.provisional.commons.ui.WorkbenchActionSupport;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.AddExistingTaskJob;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyTaskDetailsAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewTaskFromSelectionAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.OpenWithBrowserAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.ShowInTaskListAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.SynchronizeEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskActivateAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskDeactivateAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskPlanningEditor;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.progress.IProgressService;

public class TaskEditorActionContributor
extends MultiPageEditorActionBarContributor
implements ISelectionChangedListener {
    private TaskEditor editor;
    private final OpenWithBrowserAction openWithBrowserAction = new OpenWithBrowserAction();
    private final CopyTaskDetailsAction copyTaskDetailsAction = new CopyTaskDetailsAction();
    private final SynchronizeEditorAction synchronizeEditorAction = new SynchronizeEditorAction();
    private final ShowInTaskListAction showInTaskListAction = new ShowInTaskListAction();
    private final NewTaskFromSelectionAction newTaskFromSelectionAction = new NewTaskFromSelectionAction();
    private final WorkbenchActionSupport actionSupport = new WorkbenchActionSupport();

    public TaskEditorActionContributor() {
        this.actionSupport.setCallback((WorkbenchActionSupport.WorkbenchActionCallback)new EditorPageCallback());
    }

    public void addClipboardActions(IMenuManager manager) {
        manager.add((IAction)this.actionSupport.getUndoAction());
        manager.add((IAction)this.actionSupport.getRedoAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSupport.getCutAction());
        manager.add((IAction)this.actionSupport.getCopyAction());
        manager.add((IAction)this.copyTaskDetailsAction);
        manager.add((IAction)this.actionSupport.getPasteAction());
        manager.add((IAction)this.actionSupport.getSelectAllAction());
        manager.add((IAction)this.newTaskFromSelectionAction);
        manager.add((IContributionItem)new Separator());
    }

    public void contextMenuAboutToShow(IMenuManager mng) {
        IFormPage page = this.getActivePage();
        boolean addClipboard = page instanceof TaskPlanningEditor || page instanceof AbstractTaskEditorPage;
        this.contextMenuAboutToShow(mng, addClipboard);
    }

    public void contextMenuAboutToShow(IMenuManager manager, boolean addClipboard) {
        if (this.editor != null) {
            this.updateSelectableActions(this.getSelection());
        }
        if (addClipboard) {
            this.addClipboardActions(manager);
        }
        if (this.editor.getTaskEditorInput() == null) {
            MenuManager subMenuManager = new MenuManager(MessageFormat.format(Messages.TaskEditorActionContributor_Add_to_X, TaskListView.LABEL_VIEW));
            ArrayList categories = new ArrayList(TasksUiInternal.getTaskList().getCategories());
            Collections.sort(categories);
            for (final AbstractTaskCategory category : categories) {
                if (category instanceof UnmatchedTaskContainer) continue;
                Action action = new Action(){

                    public void run() {
                        TaskEditorActionContributor.this.moveToCategory(category);
                    }
                };
                String text = category.getSummary();
                action.setText(text);
                action.setImageDescriptor(TasksUiImages.CATEGORY);
                subMenuManager.add((IAction)action);
            }
            this.copyTaskDetailsAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getSelection()));
            manager.add((IContributionItem)subMenuManager);
        } else {
            final ITask task = this.editor.getTaskEditorInput().getTask();
            if (task != null) {
                String taskUrl;
                StructuredSelection selection = new StructuredSelection((Object)task);
                this.openWithBrowserAction.selectionChanged((IStructuredSelection)selection);
                this.copyTaskDetailsAction.selectionChanged((IStructuredSelection)selection);
                this.synchronizeEditorAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getEditor()));
                this.showInTaskListAction.selectionChanged((IStructuredSelection)selection);
                manager.add((IContributionItem)new Separator());
                if (!(task instanceof LocalTask)) {
                    manager.add((IAction)this.synchronizeEditorAction);
                }
                this.openWithBrowserAction.setEnabled((taskUrl = task.getUrl()) != null && taskUrl.length() > 0);
                manager.add((IAction)this.openWithBrowserAction);
                if (task.isActive()) {
                    manager.add((IAction)new TaskDeactivateAction(){

                        public void run() {
                            super.run(task);
                        }
                    });
                } else {
                    manager.add((IAction)new TaskActivateAction(){

                        public void run() {
                            super.run(task);
                        }
                    });
                }
                manager.add((IAction)this.showInTaskListAction);
                manager.add((IContributionItem)new Separator());
                for (String menuPath : TasksUiPlugin.getDefault().getDynamicMenuMap().keySet()) {
                    for (IDynamicSubMenuContributor contributor : TasksUiPlugin.getDefault().getDynamicMenuMap().get(menuPath)) {
                        if (!"tasks".equals(menuPath)) continue;
                        ArrayList<IRepositoryElement> selectedElements = new ArrayList<IRepositoryElement>();
                        selectedElements.add((IRepositoryElement)task);
                        MenuManager subMenuManager = contributor.getSubMenuManager(selectedElements);
                        if (subMenuManager == null) continue;
                        subMenuManager.setVisible(selectedElements.size() > 0 && selectedElements.get(0) instanceof ITask);
                        manager.add((IContributionItem)subMenuManager);
                    }
                }
                manager.add((IContributionItem)new GroupMarker("navigate"));
                manager.add((IContributionItem)new Separator());
                manager.add((IContributionItem)new GroupMarker("operations"));
                manager.add((IContributionItem)new GroupMarker("context"));
                manager.add((IContributionItem)new Separator());
            }
        }
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void contributeToCoolBar(ICoolBarManager cbm) {
    }

    public void contributeToMenu(IMenuManager mm) {
    }

    public void contributeToStatusLine(IStatusLineManager slm) {
    }

    public void contributeToToolBar(IToolBarManager tbm) {
    }

    public void forceActionsEnabled() {
        this.actionSupport.forceEditActionsEnabled();
    }

    private IFormPage getActivePage() {
        return this.editor != null ? this.editor.getActivePageInstance() : null;
    }

    public TaskEditor getEditor() {
        return this.editor;
    }

    public ISelection getSelection() {
        if (this.editor != null && this.editor.getSite().getSelectionProvider() != null) {
            return this.editor.getSite().getSelectionProvider().getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        this.actionSupport.install(bars);
    }

    private void moveToCategory(AbstractTaskCategory category) {
        IEditorInput input = this.getEditor().getEditorInput();
        if (input instanceof TaskEditorInput) {
            TaskEditorInput repositoryTaskEditorInput = (TaskEditorInput)input;
            final IProgressService svc = PlatformUI.getWorkbench().getProgressService();
            final AddExistingTaskJob job = new AddExistingTaskJob(repositoryTaskEditorInput.getTaskRepository(), repositoryTaskEditorInput.getTask().getTaskId(), category);
            job.schedule();
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    svc.showInDialog(TaskEditorActionContributor.this.getEditor().getSite().getShell(), (Job)job);
                }
            });
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.actionSupport.selectionChanged(event);
        this.newTaskFromSelectionAction.selectionChanged(event.getSelection());
    }

    public void setActiveEditor(IEditorPart activeEditor) {
        if (activeEditor instanceof TaskEditor) {
            this.editor = (TaskEditor)activeEditor;
            this.updateSelectableActions(this.getSelection());
        } else {
            this.editor = null;
        }
    }

    public void setActivePage(IEditorPart activePage) {
        this.updateSelectableActions(this.getSelection());
    }

    public void updateSelectableActions(ISelection selection) {
        if (this.editor != null) {
            this.actionSupport.updateActions(selection);
            this.newTaskFromSelectionAction.selectionChanged(selection);
        }
    }

    private class EditorPageCallback
    extends WorkbenchActionSupport.WorkbenchActionCallback {
        private EditorPageCallback() {
        }

        public boolean canPerformAction(String actionId, Control control) {
            WorkbenchActionSupport.WorkbenchActionCallback textSupport;
            IFormPage activePage = TaskEditorActionContributor.this.getActivePage();
            if (activePage instanceof AbstractTaskEditorPage) {
                AbstractTaskEditorPage page = (AbstractTaskEditorPage)activePage;
                return page.canPerformAction(actionId);
            }
            if (activePage != null && (textSupport = (WorkbenchActionSupport.WorkbenchActionCallback)activePage.getAdapter(WorkbenchActionSupport.WorkbenchActionCallback.class)) != null) {
                return textSupport.canPerformAction(actionId, control);
            }
            return super.canPerformAction(actionId, control);
        }

        public void doAction(String actionId, Control control) {
            WorkbenchActionSupport.WorkbenchActionCallback textSupport;
            IFormPage activePage = TaskEditorActionContributor.this.getActivePage();
            if (activePage instanceof AbstractTaskEditorPage) {
                AbstractTaskEditorPage page = (AbstractTaskEditorPage)activePage;
                page.doAction(actionId);
                return;
            }
            if (activePage != null && (textSupport = (WorkbenchActionSupport.WorkbenchActionCallback)activePage.getAdapter(WorkbenchActionSupport.WorkbenchActionCallback.class)) != null) {
                textSupport.doAction(actionId, control);
                return;
            }
            super.doAction(actionId, control);
        }

        public Control getFocusControl() {
            IFormPage page = TaskEditorActionContributor.this.getActivePage();
            return page != null ? EditorUtil.getFocusControl(page) : null;
        }

        public ISelection getSelection() {
            return TaskEditorActionContributor.this.getSelection();
        }
    }
}

