/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorExtensionReader;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskEditorExtensions {
    public static final String REPOSITORY_PROPERTY_EDITOR_EXTENSION = "editorExtension";
    private static Map<String, RegisteredTaskEditorExtension> extensionsById = new HashMap<String, RegisteredTaskEditorExtension>();
    private static Map<String, String> associationByConnectorKind = new HashMap<String, String>();
    private static boolean initialized;

    public static SortedSet<RegisteredTaskEditorExtension> getTaskEditorExtensions() {
        TaskEditorExtensions.init();
        return new TreeSet<RegisteredTaskEditorExtension>(extensionsById.values());
    }

    public static void addTaskEditorExtension(String id, String name, AbstractTaskEditorExtension extension) {
        Assert.isNotNull((Object)id);
        RegisteredTaskEditorExtension previous = extensionsById.put(id, new RegisteredTaskEditorExtension(extension, id, name));
        if (previous != null) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Duplicate taskEditorExtension id=" + id, null));
        }
    }

    public static void addRepositoryAssociation(String connectorKind, String extensionId) {
        if (connectorKind == null || extensionId == null) {
            throw new IllegalArgumentException();
        }
        String previous = associationByConnectorKind.put(connectorKind, extensionId);
        if (previous != null) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", String.format("Duplicate association for repository %s: %s replaces %s", connectorKind, extensionId, previous), null));
        }
    }

    public static AbstractTaskEditorExtension getTaskEditorExtension(TaskRepository taskRepository) {
        TaskEditorExtensions.init();
        String extensionId = TaskEditorExtensions.getTaskEditorExtensionId(taskRepository);
        if (extensionId != null) {
            RegisteredTaskEditorExtension taskEditorExtension = extensionsById.get(extensionId);
            return taskEditorExtension == null ? null : taskEditorExtension.getExtension();
        }
        return null;
    }

    public static String getTaskEditorExtensionId(TaskRepository taskRepository) {
        TaskEditorExtensions.init();
        String id = taskRepository.getProperty(REPOSITORY_PROPERTY_EDITOR_EXTENSION);
        if (id == null) {
            id = TaskEditorExtensions.getDefaultTaskEditorExtensionId(taskRepository);
        }
        return id;
    }

    public static void setTaskEditorExtensionId(TaskRepository repository, String editorExtensionId) {
        repository.setProperty(REPOSITORY_PROPERTY_EDITOR_EXTENSION, editorExtensionId);
    }

    public static String getDefaultTaskEditorExtensionId(TaskRepository taskRepository) {
        return TaskEditorExtensions.getDefaultTaskEditorExtensionId(taskRepository.getConnectorKind());
    }

    public static String getDefaultTaskEditorExtensionId(String connectorKind) {
        TaskEditorExtensions.init();
        return associationByConnectorKind.get(connectorKind);
    }

    public static AbstractTaskEditorExtension getDefaultTaskEditorExtension(TaskRepository taskRepository) {
        TaskEditorExtensions.init();
        String extensionId = TaskEditorExtensions.getDefaultTaskEditorExtensionId(taskRepository);
        if (extensionId != null) {
            RegisteredTaskEditorExtension taskEditorExtension = extensionsById.get(extensionId);
            return taskEditorExtension == null ? null : taskEditorExtension.getExtension();
        }
        return null;
    }

    private static void init() {
        if (!initialized) {
            initialized = true;
            TaskEditorExtensionReader.initExtensions();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RegisteredTaskEditorExtension
    implements Comparable<RegisteredTaskEditorExtension> {
        private final String id;
        private final String name;
        private final AbstractTaskEditorExtension extension;

        private RegisteredTaskEditorExtension(AbstractTaskEditorExtension extension, String id, String name) {
            this.extension = extension;
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public AbstractTaskEditorExtension getExtension() {
            return this.extension;
        }

        @Override
        public int compareTo(RegisteredTaskEditorExtension o) {
            if (o == this) {
                return 0;
            }
            int i = this.name.compareTo(o.name);
            if (i == 0) {
                i = this.id.compareTo(o.id);
            }
            return i;
        }
    }
}

