/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonTextSupport;
import org.eclipse.mylyn.internal.provisional.commons.ui.DatePicker;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DayDateRange;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.LocalRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.ui.ScheduleDatePicker;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.DeleteTaskEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewSubTaskAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTextViewerConfiguration;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorActionContributor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskListChangeAdapter;
import org.eclipse.mylyn.internal.tasks.ui.util.AbstractRetrieveTitleFromUrlJob;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.TaskActivityAdapter;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskFormPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.themes.IThemeManager;

public class TaskPlanningEditor
extends TaskFormPage {
    private static final int WIDTH_SUMMARY = 500;
    private static final int NOTES_MINSIZE = 100;
    private DatePicker dueDatePicker;
    private ScheduleDatePicker scheduleDatePicker;
    private AbstractTask task;
    private Composite editorComposite;
    private Text endDate;
    private ScrolledForm form;
    private TextViewer summaryEditor;
    private Text issueReportURL;
    private CCombo priorityCombo;
    private CCombo statusCombo;
    private TextViewer noteEditor;
    private Spinner estimated;
    private ImageHyperlink getDescLink;
    private ImageHyperlink openUrlLink;
    private final TaskEditor parentEditor;
    private final ITaskListChangeListener TASK_LIST_LISTENER = new TaskListChangeAdapter(){

        @Override
        public void containersChanged(Set<TaskContainerDelta> containers) {
            for (TaskContainerDelta taskContainerDelta : containers) {
                AbstractTask updateTask;
                if (!(taskContainerDelta.getElement() instanceof ITask) || (updateTask = (AbstractTask)taskContainerDelta.getElement()) == null || TaskPlanningEditor.this.task == null || !updateTask.getHandleIdentifier().equals(TaskPlanningEditor.this.task.getHandleIdentifier())) continue;
                if (PlatformUI.getWorkbench() == null || PlatformUI.getWorkbench().isClosing()) break;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (TaskPlanningEditor.this.summaryEditor != null && TaskPlanningEditor.this.summaryEditor.getTextWidget() != null) {
                            TaskPlanningEditor.this.updateTaskData(updateTask);
                        }
                    }
                });
                break;
            }
        }
    };
    private FormToolkit toolkit;
    private ITaskActivityListener timingListener;
    private boolean isDirty;
    private CommonTextSupport textSupport;
    private boolean summaryChanged;

    public TaskPlanningEditor(TaskEditor editor) {
        super((FormEditor)editor, "org.eclipse.mylyn.tasks.ui.pageFactory.Planning", Messages.TaskPlanningEditor_Planning);
        this.parentEditor = editor;
        TasksUiInternal.getTaskList().addChangeListener(this.TASK_LIST_LISTENER);
    }

    public TaskEditor getEditor() {
        return (TaskEditor)super.getEditor();
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.textSupport = new CommonTextSupport((IHandlerService)this.getSite().getService(IHandlerService.class));
        this.textSupport.setSelectionChangedListener((ISelectionChangedListener)((TaskEditorActionContributor)this.getEditorSite().getActionBarContributor()));
    }

    public void fillToolBar(IToolBarManager toolBarManager) {
        TaskEditorInput taskEditorInput = (TaskEditorInput)this.getEditorInput();
        if (taskEditorInput.getTask() instanceof LocalTask) {
            DeleteTaskEditorAction deleteAction = new DeleteTaskEditorAction(taskEditorInput.getTask());
            toolBarManager.add((IAction)deleteAction);
            NewSubTaskAction newSubTaskAction = new NewSubTaskAction();
            newSubTaskAction.selectionChanged((IAction)newSubTaskAction, (ISelection)new StructuredSelection((Object)taskEditorInput.getTask()));
            if (newSubTaskAction.isEnabled()) {
                toolBarManager.add((IAction)newSubTaskAction);
            }
        }
    }

    public void updateTaskData(AbstractTask updateTask) {
        ITask.PriorityLevel level;
        if (this.scheduleDatePicker != null && !this.scheduleDatePicker.isDisposed()) {
            if (updateTask.getScheduledForDate() != null) {
                this.scheduleDatePicker.setScheduledDate(updateTask.getScheduledForDate());
            } else {
                this.scheduleDatePicker.setScheduledDate(null);
            }
        }
        if (this.summaryEditor == null) {
            return;
        }
        if (!this.summaryEditor.getTextWidget().isDisposed()) {
            if (!this.summaryChanged) {
                this.summaryEditor.getTextWidget().setText(updateTask.getSummary());
            }
            if (this.parentEditor != null) {
                this.parentEditor.updateHeaderToolBar();
            }
        }
        if (!this.priorityCombo.isDisposed() && updateTask != null && (level = ITask.PriorityLevel.fromString((String)updateTask.getPriority())) != null) {
            int prioritySelectionIndex = this.priorityCombo.indexOf(level.getDescription());
            this.priorityCombo.select(prioritySelectionIndex);
        }
        if (!this.statusCombo.isDisposed()) {
            if (this.task.isCompleted()) {
                this.statusCombo.select(0);
            } else {
                this.statusCombo.select(1);
            }
        }
        if (updateTask instanceof LocalTask && !this.endDate.isDisposed()) {
            this.endDate.setText(this.getTaskDateString((ITask)updateTask));
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.task instanceof LocalTask) {
            String label = this.summaryEditor.getTextWidget().getText();
            this.task.setSummary(label);
            this.task.setUrl(this.issueReportURL.getText());
            String priorityDescription = this.priorityCombo.getItem(this.priorityCombo.getSelectionIndex());
            ITask.PriorityLevel level = ITask.PriorityLevel.fromDescription((String)priorityDescription);
            if (level != null) {
                this.task.setPriority(level.toString());
            }
            if (!this.task.isCompleted() && this.statusCombo.getSelectionIndex() == 0) {
                this.task.setCompletionDate(new Date());
            } else {
                this.task.setCompletionDate(null);
            }
            TasksUiInternal.getTaskList().notifyElementChanged((IRepositoryElement)this.task);
        }
        String note = this.noteEditor.getTextWidget().getText();
        this.task.setNotes(note);
        this.task.setEstimatedTimeHours(this.estimated.getSelection());
        if (this.scheduleDatePicker != null && this.scheduleDatePicker.getScheduledDate() != null) {
            if (this.task.getScheduledForDate() == null || this.task.getScheduledForDate() != null && !this.scheduleDatePicker.getScheduledDate().equals((Object)this.task.getScheduledForDate()) || this.task.getScheduledForDate() instanceof DayDateRange) {
                TasksUiPlugin.getTaskActivityManager().setScheduledFor(this.task, this.scheduleDatePicker.getScheduledDate());
                this.task.setReminded(false);
            }
        } else {
            TasksUiPlugin.getTaskActivityManager().setScheduledFor(this.task, null);
            this.task.setReminded(false);
        }
        if (this.dueDatePicker != null && this.dueDatePicker.getDate() != null) {
            TasksUiPlugin.getTaskActivityManager().setDueDate((ITask)this.task, this.dueDatePicker.getDate().getTime());
        } else {
            TasksUiPlugin.getTaskActivityManager().setDueDate((ITask)this.task, null);
        }
        this.markDirty(false);
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.form = managedForm.getForm();
        TaskEditorInput taskEditorInput = (TaskEditorInput)this.getEditorInput();
        this.task = (AbstractTask)taskEditorInput.getTask();
        this.toolkit = managedForm.getToolkit();
        this.editorComposite = managedForm.getForm().getBody();
        GridLayout editorLayout = new GridLayout();
        editorLayout.verticalSpacing = 3;
        this.editorComposite.setLayout((Layout)editorLayout);
        if (this.task instanceof LocalTask) {
            this.createSummarySection(this.editorComposite);
        }
        this.createPlanningSection(this.editorComposite);
        this.createNotesSection(this.editorComposite);
        if (this.summaryEditor != null && this.summaryEditor.getTextWidget() != null && LocalRepositoryConnector.DEFAULT_SUMMARY.equals(this.summaryEditor.getTextWidget().getText())) {
            this.summaryEditor.setSelectedRange(0, this.summaryEditor.getTextWidget().getText().length());
            this.summaryEditor.getTextWidget().setFocus();
        } else if (this.summaryEditor != null && this.summaryEditor.getTextWidget() != null) {
            this.summaryEditor.getTextWidget().setFocus();
        }
    }

    public void setFocus() {
        if (this.summaryEditor != null && this.summaryEditor.getTextWidget() != null && !this.summaryEditor.getTextWidget().isDisposed()) {
            this.summaryEditor.getTextWidget().setFocus();
        }
    }

    private Text addNameValueComp(Composite parent, String label, String value, int style) {
        Text text;
        Composite nameValueComp = this.toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 3;
        nameValueComp.setLayout((Layout)layout);
        this.toolkit.createLabel(nameValueComp, label, 0).setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        if ((8 & style) == 8) {
            text = new Text(nameValueComp, style);
            this.toolkit.adapt((Control)text, false, false);
            text.setText(value);
        } else {
            text = this.toolkit.createText(nameValueComp, value, style);
        }
        return text;
    }

    private void createSummarySection(Composite parent) {
        Composite summaryComposite = this.toolkit.createComposite(parent);
        GridLayout summaryLayout = new GridLayout();
        summaryLayout.verticalSpacing = 2;
        summaryLayout.marginHeight = 2;
        summaryLayout.marginLeft = 5;
        summaryComposite.setLayout((Layout)summaryLayout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)summaryComposite);
        TaskRepository repository = null;
        if (this.task != null && !(this.task instanceof LocalTask)) {
            AbstractTask repositoryTask = this.task;
            repository = TasksUi.getRepositoryManager().getRepository(repositoryTask.getConnectorKind(), repositoryTask.getRepositoryUrl());
        }
        this.summaryEditor = this.addTextEditor(repository, summaryComposite, this.task.getSummary(), true, 0x800004);
        GridDataFactory.fillDefaults().hint(500, -1).minSize(100, -1).grab(true, false).applyTo((Control)this.summaryEditor.getTextWidget());
        this.summaryEditor.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        if (!(this.task instanceof LocalTask)) {
            this.summaryEditor.setEditable(false);
        } else {
            this.summaryEditor.setEditable(true);
            this.summaryEditor.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    if (!TaskPlanningEditor.this.task.getSummary().equals(TaskPlanningEditor.this.summaryEditor.getTextWidget().getText())) {
                        TaskPlanningEditor.this.summaryChanged = true;
                        TaskPlanningEditor.this.markDirty(true);
                    }
                }
            });
        }
        this.toolkit.paintBordersFor(summaryComposite);
        Composite statusComposite = this.toolkit.createComposite(parent);
        GridLayout compLayout = new GridLayout(8, false);
        compLayout.verticalSpacing = 0;
        compLayout.horizontalSpacing = 5;
        compLayout.marginHeight = 3;
        statusComposite.setLayout((Layout)compLayout);
        statusComposite.setLayoutData((Object)new GridData(768));
        Composite nameValueComp = this.toolkit.createComposite(statusComposite);
        GridLayout nameValueLayout = new GridLayout(2, false);
        nameValueLayout.marginHeight = 3;
        nameValueComp.setLayout((Layout)nameValueLayout);
        this.toolkit.createLabel(nameValueComp, Messages.TaskPlanningEditor_Priority).setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.priorityCombo = new CCombo(nameValueComp, 0x800008);
        this.toolkit.adapt((Control)this.priorityCombo, false, false);
        this.priorityCombo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.toolkit.paintBordersFor(nameValueComp);
        String[] stringArray = TaskListView.PRIORITY_LEVEL_DESCRIPTIONS;
        int n = TaskListView.PRIORITY_LEVEL_DESCRIPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String priorityLevel = stringArray[n2];
            this.priorityCombo.add(priorityLevel);
            ++n2;
        }
        ITask.PriorityLevel level = ITask.PriorityLevel.fromString((String)this.task.getPriority());
        if (level != null) {
            int prioritySelectionIndex = this.priorityCombo.indexOf(level.getDescription());
            this.priorityCombo.select(prioritySelectionIndex);
        }
        if (!(this.task instanceof LocalTask)) {
            this.priorityCombo.setEnabled(false);
        } else {
            this.priorityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TaskPlanningEditor.this.markDirty(true);
                }
            });
        }
        nameValueComp = this.toolkit.createComposite(statusComposite);
        nameValueComp.setLayout((Layout)new GridLayout(2, false));
        this.toolkit.createLabel(nameValueComp, Messages.TaskPlanningEditor_Status).setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.statusCombo = new CCombo(nameValueComp, 0x800008);
        this.toolkit.adapt((Control)this.statusCombo, true, true);
        this.statusCombo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.toolkit.paintBordersFor(nameValueComp);
        this.statusCombo.add(Messages.TaskPlanningEditor_Complete);
        this.statusCombo.add(Messages.TaskPlanningEditor_Incomplete);
        if (this.task.isCompleted()) {
            this.statusCombo.select(0);
        } else {
            this.statusCombo.select(1);
        }
        if (!(this.task instanceof LocalTask)) {
            this.statusCombo.setEnabled(false);
        } else {
            this.statusCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TaskPlanningEditor.this.markDirty(true);
                }
            });
        }
        Date creationDate = this.task.getCreationDate();
        String creationDateString = creationDate != null ? DateFormat.getDateInstance(1).format(creationDate) : "";
        this.addNameValueComp(statusComposite, Messages.TaskPlanningEditor_Created, creationDateString, 0x800008);
        String completionDateString = "";
        if (this.task.isCompleted()) {
            completionDateString = this.getTaskDateString((ITask)this.task);
        }
        this.endDate = this.addNameValueComp(statusComposite, Messages.TaskPlanningEditor_Completed, completionDateString, 0x800008);
        Composite urlComposite = this.toolkit.createComposite(parent);
        GridLayout urlLayout = new GridLayout(4, false);
        urlLayout.verticalSpacing = 0;
        urlLayout.marginHeight = 2;
        urlLayout.marginLeft = 5;
        urlComposite.setLayout((Layout)urlLayout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)urlComposite);
        Label label = this.toolkit.createLabel(urlComposite, Messages.TaskPlanningEditor_URL);
        label.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.issueReportURL = this.toolkit.createText(urlComposite, this.task.getUrl(), 0x800000);
        this.issueReportURL.setLayoutData((Object)new GridData(768));
        if (!(this.task instanceof LocalTask)) {
            this.issueReportURL.setEditable(false);
        } else {
            this.issueReportURL.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TaskPlanningEditor.this.markDirty(true);
                }
            });
        }
        this.getDescLink = this.toolkit.createImageHyperlink(urlComposite, 0);
        this.getDescLink.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK_RETRIEVE));
        this.getDescLink.setToolTipText(Messages.TaskPlanningEditor_Retrieve_task_description_from_URL);
        this.getDescLink.setLayoutData((Object)new GridData(128));
        this.setButtonStatus();
        this.issueReportURL.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                TaskPlanningEditor.this.setButtonStatus();
            }

            public void keyReleased(KeyEvent e) {
                TaskPlanningEditor.this.setButtonStatus();
            }
        });
        this.getDescLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                TaskPlanningEditor.this.retrieveTaskDescription(TaskPlanningEditor.this.issueReportURL.getText());
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        this.openUrlLink = this.toolkit.createImageHyperlink(urlComposite, 0);
        this.openUrlLink.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.BROWSER_SMALL));
        this.openUrlLink.setToolTipText(Messages.TaskPlanningEditor_Open_with_Web_Browser);
        this.openUrlLink.setLayoutData((Object)new GridData(128));
        this.openUrlLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                TasksUiUtil.openUrl(TaskPlanningEditor.this.issueReportURL.getText());
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        this.toolkit.paintBordersFor(urlComposite);
        this.toolkit.paintBordersFor(statusComposite);
    }

    private TextViewer addTextEditor(TaskRepository repository, Composite parent, String text, boolean spellCheck, int style) {
        SourceViewer viewer = new SourceViewer(parent, null, style);
        viewer.configure((SourceViewerConfiguration)new RepositoryTextViewerConfiguration(repository, spellCheck));
        this.textSupport.configure((TextViewer)viewer, new Document(text), spellCheck);
        viewer.getControl().setMenu(this.getEditor().getMenu());
        viewer.getTextWidget().setFont(this.getCommentFont());
        return viewer;
    }

    private void markDirty(boolean dirty) {
        if (!dirty) {
            this.summaryChanged = false;
        }
        this.isDirty = dirty;
        this.getManagedForm().dirtyStateChanged();
    }

    protected void retrieveTaskDescription(String url) {
        AbstractRetrieveTitleFromUrlJob job = new AbstractRetrieveTitleFromUrlJob(this.issueReportURL.getText()){

            protected void titleRetrieved(String pageTitle) {
                if (TaskPlanningEditor.this.summaryEditor != null && TaskPlanningEditor.this.summaryEditor.getControl() != null && !TaskPlanningEditor.this.summaryEditor.getControl().isDisposed()) {
                    TaskPlanningEditor.this.summaryEditor.getTextWidget().setText(pageTitle);
                    TaskPlanningEditor.this.markDirty(true);
                }
            }
        };
        job.schedule();
    }

    protected void setButtonStatus() {
        String url = this.issueReportURL.getText();
        if (url.length() > 10 && (url.startsWith("http://") || url.startsWith("https://"))) {
            this.getDescLink.setEnabled(true);
        } else {
            this.getDescLink.setEnabled(false);
        }
    }

    private void createPlanningSection(Composite parent) {
        Section section = this.toolkit.createSection(parent, 258);
        section.setText(Messages.TaskPlanningEditor_Personal_Planning);
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(768));
        section.setExpanded(true);
        section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
                TaskPlanningEditor.this.form.reflow(true);
            }

            public void expansionStateChanged(ExpansionEvent e) {
                TaskPlanningEditor.this.form.reflow(true);
            }
        });
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)sectionClient);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 15;
        layout.makeColumnsEqualWidth = false;
        sectionClient.setLayout((Layout)layout);
        GridData clientDataLayout = new GridData(32);
        sectionClient.setLayoutData((Object)clientDataLayout);
        Composite nameValueComp = this.makeComposite(sectionClient, 3);
        Label label = this.toolkit.createLabel(nameValueComp, Messages.TaskPlanningEditor_Scheduled_for);
        label.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.scheduleDatePicker = new ScheduleDatePicker(nameValueComp, this.task, 0x800000);
        GridData gd = new GridData();
        gd.widthHint = 135;
        this.scheduleDatePicker.setLayoutData(gd);
        this.scheduleDatePicker.setData("FormWidgetFactory.drawBorder", "textBorder");
        this.toolkit.adapt((Control)this.scheduleDatePicker, false, false);
        this.toolkit.paintBordersFor(nameValueComp);
        this.scheduleDatePicker.setBackground(Display.getDefault().getSystemColor(1));
        this.scheduleDatePicker.addPickerSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TaskPlanningEditor.this.markDirty(true);
            }
        });
        ImageHyperlink clearScheduledDate = this.toolkit.createImageHyperlink(nameValueComp, 0);
        clearScheduledDate.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.REMOVE));
        clearScheduledDate.setToolTipText(Messages.TaskPlanningEditor_Clear);
        clearScheduledDate.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskPlanningEditor.this.scheduleDatePicker.setScheduledDate(null);
                TaskPlanningEditor.this.task.setReminded(false);
                TaskPlanningEditor.this.markDirty(true);
            }
        });
        nameValueComp = this.makeComposite(sectionClient, 3);
        label = this.toolkit.createLabel(nameValueComp, Messages.TaskPlanningEditor_Due);
        label.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.dueDatePicker = new DatePicker(nameValueComp, 0x800000, DatePicker.LABEL_CHOOSE, true, TasksUiPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.end.hour"));
        Calendar calendar = TaskActivityUtil.getCalendar();
        if (this.task.getDueDate() != null) {
            calendar.setTime(this.task.getDueDate());
            this.dueDatePicker.setDate(calendar);
        }
        this.dueDatePicker.setBackground(Display.getDefault().getSystemColor(1));
        this.dueDatePicker.addPickerSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!TaskPlanningEditor.this.areEqual(TaskPlanningEditor.this.dueDatePicker.getDate(), TaskPlanningEditor.this.task.getDueDate())) {
                    TaskPlanningEditor.this.markDirty(true);
                }
            }
        });
        this.dueDatePicker.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.toolkit.adapt((Control)this.dueDatePicker, false, false);
        this.toolkit.paintBordersFor(nameValueComp);
        ImageHyperlink clearDueDate = this.toolkit.createImageHyperlink(nameValueComp, 0);
        clearDueDate.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.REMOVE));
        clearDueDate.setToolTipText(Messages.TaskPlanningEditor_Clear);
        clearDueDate.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskPlanningEditor.this.dueDatePicker.setDate(null);
                if (!TaskPlanningEditor.this.areEqual(TaskPlanningEditor.this.dueDatePicker.getDate(), TaskPlanningEditor.this.task.getDueDate())) {
                    TaskPlanningEditor.this.markDirty(true);
                }
            }
        });
        if (this.task != null) {
            try {
                TaskData taskData = TasksUi.getTaskDataManager().getTaskData((ITask)this.task);
                if (taskData != null) {
                    AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector(taskData.getConnectorKind());
                    TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(taskData.getConnectorKind(), taskData.getRepositoryUrl());
                    if (connector != null && taskRepository != null && connector.hasRepositoryDueDate(taskRepository, (ITask)this.task, taskData)) {
                        this.dueDatePicker.setEnabled(false);
                        clearDueDate.setEnabled(false);
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        nameValueComp = this.makeComposite(sectionClient, 3);
        label = this.toolkit.createLabel(nameValueComp, Messages.TaskPlanningEditor_Estimated_hours);
        label.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.estimated = new Spinner(nameValueComp, 0x800000);
        this.toolkit.adapt((Control)this.estimated, false, false);
        this.estimated.setSelection(this.task.getEstimatedTimeHours());
        this.estimated.setDigits(0);
        this.estimated.setMaximum(100);
        this.estimated.setMinimum(0);
        this.estimated.setIncrement(1);
        this.estimated.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TaskPlanningEditor.this.markDirty(true);
            }
        });
        this.estimated.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.toolkit.paintBordersFor(nameValueComp);
        GridData estimatedDataLayout = new GridData();
        estimatedDataLayout.widthHint = 30;
        this.estimated.setLayoutData((Object)estimatedDataLayout);
        ImageHyperlink clearEstimated = this.toolkit.createImageHyperlink(nameValueComp, 0);
        clearEstimated.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.REMOVE));
        clearEstimated.setToolTipText(Messages.TaskPlanningEditor_Clear);
        clearEstimated.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskPlanningEditor.this.estimated.setSelection(0);
                TaskPlanningEditor.this.markDirty(true);
            }
        });
        nameValueComp = this.makeComposite(sectionClient, 3);
        GridDataFactory.fillDefaults().applyTo((Control)nameValueComp);
        label = this.toolkit.createLabel(nameValueComp, Messages.TaskPlanningEditor_Active);
        label.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        label.setToolTipText(Messages.TaskPlanningEditor_Time_working_on_this_task);
        String elapsedTimeString = Messages.TaskPlanningEditor_0_seconds;
        try {
            elapsedTimeString = TasksUiInternal.getFormattedDuration(TasksUiPlugin.getTaskActivityManager().getElapsedTime((ITask)this.task), false);
            if (elapsedTimeString.equals("")) {
                elapsedTimeString = Messages.TaskPlanningEditor_0_seconds;
            }
        }
        catch (RuntimeException e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not format elapsed time", (Throwable)e));
        }
        final Text elapsedTimeText = this.toolkit.createText(nameValueComp, elapsedTimeString);
        elapsedTimeText.setText(elapsedTimeString);
        GridData td = new GridData(768);
        td.grabExcessHorizontalSpace = true;
        elapsedTimeText.setLayoutData((Object)td);
        elapsedTimeText.setEditable(false);
        this.timingListener = new TaskActivityAdapter(){

            public void elapsedTimeUpdated(ITask task, long newElapsedTime) {
                if (task.equals(TaskPlanningEditor.this.task)) {
                    String elapsedTimeString = Messages.TaskPlanningEditor_0_seconds;
                    try {
                        elapsedTimeString = TasksUiInternal.getFormattedDuration(newElapsedTime, false);
                        if (elapsedTimeString.equals("")) {
                            elapsedTimeString = Messages.TaskPlanningEditor_0_seconds;
                        }
                    }
                    catch (RuntimeException e) {
                        StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not format elapsed time", (Throwable)e));
                    }
                    final String elapsedString = elapsedTimeString;
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!elapsedTimeText.isDisposed()) {
                                elapsedTimeText.setText(elapsedString);
                            }
                        }
                    });
                }
            }
        };
        TasksUiPlugin.getTaskActivityManager().addActivityListener(this.timingListener);
        ImageHyperlink resetActivityTimeButton = this.toolkit.createImageHyperlink(nameValueComp, 0);
        resetActivityTimeButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.REMOVE));
        resetActivityTimeButton.setToolTipText(Messages.TaskPlanningEditor_Reset);
        resetActivityTimeButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (MessageDialog.openConfirm((Shell)TaskPlanningEditor.this.getSite().getShell(), (String)Messages.TaskPlanningEditor_Confirm_Activity_Time_Deletion, (String)Messages.TaskPlanningEditor_Do_you_wish_to_reset_your_activity_time_on_this_task_)) {
                    MonitorUi.getActivityContextManager().removeActivityTime(TaskPlanningEditor.this.task.getHandleIdentifier(), 0L, System.currentTimeMillis());
                }
            }
        });
        this.toolkit.paintBordersFor(sectionClient);
    }

    private Composite makeComposite(Composite parent, int col) {
        Composite nameValueComp = this.toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 3;
        nameValueComp.setLayout((Layout)layout);
        return nameValueComp;
    }

    private void createNotesSection(Composite parent) {
        Section section = this.toolkit.createSection(parent, 256);
        section.setText(Messages.TaskPlanningEditor_Notes);
        section.setExpanded(true);
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(1808));
        Composite container = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)container);
        container.setLayout((Layout)new GridLayout());
        GridData notesData = new GridData(1808);
        notesData.grabExcessVerticalSpace = true;
        container.setLayoutData((Object)notesData);
        TaskRepository repository = null;
        if (this.task != null && !(this.task instanceof LocalTask)) {
            AbstractTask repositoryTask = this.task;
            repository = TasksUi.getRepositoryManager().getRepository(repositoryTask.getConnectorKind(), repositoryTask.getRepositoryUrl());
        }
        this.noteEditor = this.addTextEditor(repository, container, this.task.getNotes(), true, 8389186);
        GridDataFactory.fillDefaults().minSize(100, 100).grab(true, true).applyTo(this.noteEditor.getControl());
        this.noteEditor.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.noteEditor.setEditable(true);
        this.noteEditor.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (!TaskPlanningEditor.this.task.getNotes().equals(TaskPlanningEditor.this.noteEditor.getTextWidget().getText())) {
                    TaskPlanningEditor.this.markDirty(true);
                }
            }
        });
        this.toolkit.paintBordersFor(container);
    }

    private Font getCommentFont() {
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        Font font = themeManager.getCurrentTheme().getFontRegistry().get("org.eclipse.mylyn.tasks.ui.fonts.task.editor.comment");
        return font;
    }

    private String getTaskDateString(ITask task) {
        if (task == null) {
            return "";
        }
        if (task.getCompletionDate() == null) {
            return "";
        }
        String completionDateString = "";
        try {
            completionDateString = DateFormat.getDateInstance(1).format(task.getCompletionDate());
        }
        catch (RuntimeException e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not format date", (Throwable)e));
            return completionDateString;
        }
        return completionDateString;
    }

    public void dispose() {
        if (this.textSupport != null) {
            this.textSupport.dispose();
        }
        if (this.timingListener != null) {
            TasksUiPlugin.getTaskActivityManager().removeActivityListener(this.timingListener);
        }
        TasksUiInternal.getTaskList().removeChangeListener(this.TASK_LIST_LISTENER);
    }

    public String toString() {
        return String.valueOf(Messages.TaskPlanningEditor__info_editor_for_task_) + this.task + ")";
    }

    public void setNotes(String notes) {
        this.noteEditor.getTextWidget().setText(notes);
    }

    public void setDescription(String desc) {
        this.summaryEditor.getTextWidget().setText(desc);
    }

    public String getDescription() {
        return this.summaryEditor.getTextWidget().getText();
    }

    private boolean areEqual(Object oldValue, Object newValue) {
        return oldValue != null ? oldValue.equals(newValue) : oldValue == newValue;
    }
}

