/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskUrlHyperlink;

public class TaskUrlHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String line;
        IRegion lineInfo;
        if (region == null || textViewer == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        int offset = region.getOffset();
        if (document == null) {
            return null;
        }
        try {
            lineInfo = document.getLineInformationOfOffset(offset);
            line = document.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        int offsetInLine = offset - lineInfo.getOffset();
        return this.findHyperlinks(line, offsetInLine, lineInfo.getOffset(), region.getLength());
    }

    private IHyperlink[] findHyperlinks(String line, int offsetInLine, int offset, int regionLength) {
        int doubleChar = 32;
        String urlString = null;
        boolean startDoubleQuote = false;
        int urlOffsetInLine = 0;
        int urlLength = 0;
        int urlSeparatorOffset = line.indexOf("://");
        while (urlSeparatorOffset >= 0) {
            char ch;
            urlOffsetInLine = urlSeparatorOffset;
            do {
                ch = ' ';
                if (--urlOffsetInLine <= -1) continue;
                ch = line.charAt(urlOffsetInLine);
            } while (Character.isUnicodeIdentifierStart(ch));
            ++urlOffsetInLine;
            switch (ch) {
                case '\"': {
                    doubleChar = 34;
                    break;
                }
                case '\'': {
                    doubleChar = 39;
                    break;
                }
                case '[': {
                    doubleChar = 93;
                    break;
                }
                case '(': {
                    doubleChar = 41;
                    break;
                }
                case '{': {
                    doubleChar = 125;
                    break;
                }
                default: {
                    doubleChar = 32;
                }
            }
            startDoubleQuote = doubleChar != 32;
            StringTokenizer tokenizer = new StringTokenizer(line.substring(urlSeparatorOffset + 3), " \t\n\r\f<>", false);
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            urlLength = tokenizer.nextToken().length() + 3 + urlSeparatorOffset - urlOffsetInLine;
            if (regionLength == 0 && offsetInLine >= urlOffsetInLine && offsetInLine <= urlOffsetInLine + urlLength || regionLength > 0 && offsetInLine <= urlOffsetInLine && offsetInLine + regionLength > urlOffsetInLine) break;
            urlSeparatorOffset = line.indexOf("://", urlSeparatorOffset + 1);
        }
        if (urlSeparatorOffset < 0) {
            return null;
        }
        if (startDoubleQuote) {
            int endOffset = -1;
            int nextDoubleQuote = line.indexOf(doubleChar, urlOffsetInLine);
            int nextWhitespace = line.indexOf(32, urlOffsetInLine);
            if (nextDoubleQuote != -1 && nextWhitespace != -1) {
                endOffset = Math.min(nextDoubleQuote, nextWhitespace);
            } else if (nextDoubleQuote != -1) {
                endOffset = nextDoubleQuote;
            } else if (nextWhitespace != -1) {
                endOffset = nextWhitespace;
            }
            if (endOffset != -1) {
                urlLength = endOffset - urlOffsetInLine;
            }
        }
        try {
            char lastChar = line.charAt(urlOffsetInLine + urlLength - 1);
            if (lastChar == ',' || lastChar == '.') {
                --urlLength;
            }
            if (urlLength > 0 && (lastChar = line.charAt(urlOffsetInLine + urlLength - 1)) == ')') {
                --urlLength;
            }
            urlString = line.substring(urlOffsetInLine, urlOffsetInLine + urlLength);
            new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            urlString = null;
            return null;
        }
        Region urlRegion = new Region(offset + urlOffsetInLine, urlLength);
        return new IHyperlink[]{new TaskUrlHyperlink((IRegion)urlRegion, urlString)};
    }
}

