/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.ByteArrayTransfer;

public class PlatformUtil {
    private static ByteArrayTransfer urlTransfer;

    static {
        try {
            Class<?> clazz = Class.forName("org.eclipse.swt.dnd.URLTransfer");
            Method method = clazz.getMethod("getInstance", new Class[0]);
            if (method != null) {
                urlTransfer = (ByteArrayTransfer)method.invoke(null, new Object[0]);
            }
        }
        catch (Throwable throwable) {}
        if (urlTransfer == null) {
            urlTransfer = new ByteArrayTransfer(){
                private static final String TYPE = "dummy";
                private final int TYPE_ID = 1.registerType((String)"dummy");

                protected int[] getTypeIds() {
                    return new int[]{this.TYPE_ID};
                }

                protected String[] getTypeNames() {
                    return new String[]{TYPE};
                }
            };
        }
    }

    public static String[] getFilterExtensions(String ... extensions) {
        int i = 0;
        while (i < extensions.length) {
            int j;
            String extension = extensions[i];
            if ("macosx".equals(Platform.getOS()) && (j = extension.lastIndexOf(46)) != -1) {
                extension = extension.substring(j);
            }
            extensions[i] = "*" + extension;
            ++i;
        }
        return extensions;
    }

    public static int getToolTipXShift() {
        if ("gtk".equals(SWT.getPlatform()) || "carbon".equals(SWT.getPlatform()) || "cocoa".equals(SWT.getPlatform())) {
            return -26;
        }
        return -23;
    }

    public static int getTreeImageOffset() {
        return "cocoa".equals(SWT.getPlatform()) ? 15 : 20;
    }

    public static int getTreeItemSquish() {
        if ("gtk".equals(SWT.getPlatform())) {
            return 8;
        }
        if ("carbon".equals(SWT.getPlatform()) || "cocoa".equals(SWT.getPlatform())) {
            return 3;
        }
        return 0;
    }

    public static boolean isPaintItemClippingRequired() {
        return "gtk".equals(SWT.getPlatform());
    }

    public static ByteArrayTransfer getUrlTransfer() {
        return urlTransfer;
    }
}

