/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.ui.dialogs.Messages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskKeyComparator;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskComparator
implements Comparator<ITask> {
    private final TaskKeyComparator taskKeyComparator = new TaskKeyComparator();
    public static final int DEFAULT_SORT_DIRECTION = 1;
    private int sortDirection = 1;
    private SortByIndex sortByIndex = SortByIndex.PRIORITY;
    private int sortDirection2 = 1;
    private SortByIndex sortByIndex2 = SortByIndex.DATE_CREATED;

    public static String[] getSortableFromElement(IRepositoryElement element) {
        ITask task1;
        String[] stringArray = new String[3];
        stringArray[0] = "";
        stringArray[2] = element.getSummary();
        String[] a = stringArray;
        if (element instanceof ITask && (task1 = (ITask)element).getTaskKey() != null) {
            a[1] = task1.getTaskKey();
        }
        return a;
    }

    @Override
    public int compare(ITask element1, ITask element2) {
        if (SortByIndex.PRIORITY.equals((Object)this.sortByIndex)) {
            int result = this.sortByPriority(element1, element2, this.sortDirection);
            if (result != 0) {
                return result;
            }
            if (SortByIndex.DATE_CREATED.equals((Object)this.sortByIndex2)) {
                return this.sortByDate(element1, element2, this.sortDirection2);
            }
            if (SortByIndex.SUMMARY.equals((Object)this.sortByIndex2)) {
                return this.sortBySummary(element1, element2, this.sortDirection2);
            }
            if (SortByIndex.TASK_ID.equals((Object)this.sortByIndex2)) {
                return this.sortByID(element1, element2, this.sortDirection2);
            }
            return result;
        }
        if (SortByIndex.DATE_CREATED.equals((Object)this.sortByIndex)) {
            int result = this.sortByDate(element1, element2, this.sortDirection);
            if (result != 0) {
                return result;
            }
            if (SortByIndex.PRIORITY.equals((Object)this.sortByIndex2)) {
                return this.sortByPriority(element1, element2, this.sortDirection2);
            }
            if (SortByIndex.SUMMARY.equals((Object)this.sortByIndex2)) {
                return this.sortBySummary(element1, element2, this.sortDirection2);
            }
            if (SortByIndex.TASK_ID.equals((Object)this.sortByIndex2)) {
                return this.sortByID(element1, element2, this.sortDirection2);
            }
            return result;
        }
        if (SortByIndex.SUMMARY.equals((Object)this.sortByIndex)) {
            int result = this.sortBySummary(element1, element2, this.sortDirection);
            if (result != 0) {
                return result;
            }
            if (SortByIndex.DATE_CREATED.equals((Object)this.sortByIndex2)) {
                return this.sortByDate(element1, element2, this.sortDirection2);
            }
            if (SortByIndex.PRIORITY.equals((Object)this.sortByIndex2)) {
                return this.sortByPriority(element1, element2, this.sortDirection2);
            }
            if (SortByIndex.TASK_ID.equals((Object)this.sortByIndex2)) {
                return this.sortByID(element1, element2, this.sortDirection2);
            }
            return result;
        }
        int result = this.sortByID(element1, element2, this.sortDirection);
        if (result != 0) {
            return result;
        }
        if (SortByIndex.DATE_CREATED.equals((Object)this.sortByIndex2)) {
            return this.sortByDate(element1, element2, this.sortDirection2);
        }
        if (SortByIndex.PRIORITY.equals((Object)this.sortByIndex2)) {
            return this.sortByPriority(element1, element2, this.sortDirection2);
        }
        if (SortByIndex.SUMMARY.equals((Object)this.sortByIndex2)) {
            return this.sortBySummary(element1, element2, this.sortDirection2);
        }
        return result;
    }

    private int sortBySummary(ITask element1, ITask element2, int sortDirection) {
        return sortDirection * element1.getSummary().compareToIgnoreCase(element2.getSummary());
    }

    private int sortByID(ITask element1, ITask element2, int sortDirection) {
        String key1 = element1.getTaskKey();
        String key2 = element2.getTaskKey();
        if (key1 == null) {
            return key2 != null ? sortDirection : 0;
        }
        if (key2 == null) {
            return -sortDirection;
        }
        return sortDirection * this.taskKeyComparator.compare2(key1, key2);
    }

    private int sortByPriority(ITask element1, ITask element2, int sortDirection) {
        return sortDirection * element1.getPriority().compareToIgnoreCase(element2.getPriority());
    }

    private int sortByDate(ITask element1, ITask element2, int sortDirection) {
        if (element1.getCreationDate() == null) {
            return element2.getCreationDate() != null ? sortDirection : 0;
        }
        if (element2.getCreationDate() == null) {
            return -sortDirection;
        }
        return sortDirection * element1.getCreationDate().compareTo(element2.getCreationDate());
    }

    public SortByIndex getSortByIndex() {
        return this.sortByIndex;
    }

    public void setSortByIndex(SortByIndex sortByIndex) {
        Assert.isNotNull((Object)((Object)sortByIndex));
        this.sortByIndex = sortByIndex;
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(int sortDirection) {
        this.sortDirection = sortDirection;
    }

    public SortByIndex getSortByIndex2() {
        return this.sortByIndex2;
    }

    public void setSortByIndex2(SortByIndex sortByIndex) {
        Assert.isNotNull((Object)((Object)sortByIndex));
        this.sortByIndex2 = sortByIndex;
    }

    public int getSortDirection2() {
        return this.sortDirection2;
    }

    public void setSortDirection2(int sortDirection) {
        this.sortDirection2 = sortDirection;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortByIndex {
        PRIORITY,
        SUMMARY,
        DATE_CREATED,
        TASK_ID;


        public String getLabel() {
            switch (this) {
                case PRIORITY: {
                    return Messages.TaskCompareDialog_Priority;
                }
                case SUMMARY: {
                    return Messages.TaskCompareDialog_Summary;
                }
                case DATE_CREATED: {
                    return Messages.TaskCompareDialog_DateCreated;
                }
                case TASK_ID: {
                    return Messages.TaskCompareDialog_TaskID;
                }
            }
            return null;
        }

        public static SortByIndex valueOfLabel(String label) {
            SortByIndex[] sortByIndexArray = SortByIndex.values();
            int n = sortByIndexArray.length;
            int n2 = 0;
            while (n2 < n) {
                SortByIndex value = sortByIndexArray[n2];
                if (value.getLabel().equals(label)) {
                    return value;
                }
                ++n2;
            }
            return null;
        }
    }
}

