/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonFonts;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.PlatformUtil;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

class CustomTaskListDecorationDrawer
implements Listener {
    private final TaskListView taskListView;
    private final int activationImageOffset;
    private final Image taskActive = CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_ACTIVE);
    private final Image taskInactive = CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_INACTIVE_EMPTY);
    private final Image taskInactiveContext = CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_INACTIVE);
    private final int platformSpecificSquish;
    private final Rectangle lastClippingArea;
    private final boolean tweakClipping;
    private boolean useStrikethroughForCompleted;
    private final IPropertyChangeListener PROPERTY_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.mylyn.tasks.ui.strikethrough.for.completed") && event.getNewValue() instanceof Boolean) {
                CustomTaskListDecorationDrawer.this.useStrikethroughForCompleted = (Boolean)event.getNewValue();
                CustomTaskListDecorationDrawer.this.taskListView.refresh();
            }
        }
    };

    CustomTaskListDecorationDrawer(TaskListView taskListView, int activationImageOffset) {
        this.taskListView = taskListView;
        this.activationImageOffset = activationImageOffset;
        this.lastClippingArea = new Rectangle(0, 0, 0, 0);
        this.tweakClipping = PlatformUtil.isPaintItemClippingRequired();
        this.platformSpecificSquish = PlatformUtil.getTreeItemSquish();
        this.taskListView.synchronizationOverlaid = TasksUiPlugin.getDefault().getPluginPreferences().getBoolean("org.eclipse.mylyn.tasks.ui.overlays.incoming.tight");
        this.useStrikethroughForCompleted = TasksUiPlugin.getDefault().getPluginPreferences().getBoolean("org.eclipse.mylyn.tasks.ui.strikethrough.for.completed");
        TasksUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.PROPERTY_LISTENER);
    }

    public void handleEvent(Event event) {
        AbstractTask task;
        Object data = event.item.getData();
        Image activationImage = null;
        if (data instanceof ITask) {
            task = (AbstractTask)data;
            activationImage = task.isActive() ? this.taskActive : (ContextCore.getContextManager().hasContext(task.getHandleIdentifier()) ? this.taskInactiveContext : this.taskInactive);
        }
        if (!CommonFonts.HAS_STRIKETHROUGH && data instanceof AbstractTask & this.useStrikethroughForCompleted && (task = (AbstractTask)data).isCompleted()) {
            Rectangle bounds = ((TreeItem)event.item).getTextBounds(0);
            int lineY = bounds.y + bounds.height / 2;
            String itemText = ((TreeItem)event.item).getText();
            Point extent = event.gc.textExtent(itemText);
            event.gc.drawLine(bounds.x, lineY, bounds.x + extent.x, lineY);
        }
        if (data instanceof ITaskContainer) {
            switch (event.type) {
                case 40: {
                    if (activationImage != null) {
                        this.drawActivationImage(this.activationImageOffset, event, activationImage);
                    }
                    if (!this.taskListView.synchronizationOverlaid && data instanceof ITaskContainer) {
                        this.drawSyncronizationImage((ITaskContainer)data, event);
                    }
                    if (!this.tweakClipping) break;
                    this.lastClippingArea.x = event.x;
                    this.lastClippingArea.y = event.y;
                    this.lastClippingArea.width = event.width;
                    this.lastClippingArea.height = event.height;
                    break;
                }
                case 42: {
                    Rectangle clipping = null;
                    if (this.tweakClipping) {
                        clipping = event.gc.getClipping();
                        event.gc.setClipping(this.lastClippingArea);
                    }
                    if (activationImage != null) {
                        this.drawActivationImage(this.activationImageOffset, event, activationImage);
                    }
                    if (data instanceof ITaskContainer) {
                        this.drawSyncronizationImage((ITaskContainer)data, event);
                    }
                    if (!this.tweakClipping) break;
                    event.gc.setClipping(clipping);
                }
            }
        }
    }

    private void drawSyncronizationImage(ITaskContainer element, Event event) {
        Image image = null;
        int offsetX = 6;
        int offsetY = event.height / 2 - 5;
        if (this.taskListView.synchronizationOverlaid) {
            offsetX = event.x + 18 - this.platformSpecificSquish;
            offsetY += 2;
        }
        if (element != null) {
            if (element instanceof ITask) {
                image = CommonImages.getImage((ImageDescriptor)this.getSynchronizationImageDescriptor(element, this.taskListView.synchronizationOverlaid));
            } else {
                RepositoryQuery query;
                int imageOffset = 0;
                if (!this.hideDecorationOnContainer(element, (TreeItem)event.item) && AbstractTaskListFilter.hasDescendantIncoming(element)) {
                    image = this.taskListView.synchronizationOverlaid ? CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_SYNC_OLD_INCOMMING) : CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_SYNC_INCOMMING);
                } else if (element instanceof IRepositoryQuery && (query = (RepositoryQuery)element).getStatus() != null) {
                    image = CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_SYNC_WARNING);
                    imageOffset = this.taskListView.synchronizationOverlaid ? 11 : 3;
                }
                int additionalSquish = 0;
                if (this.platformSpecificSquish > 0 && this.taskListView.synchronizationOverlaid) {
                    additionalSquish = this.platformSpecificSquish + 3;
                } else if (this.platformSpecificSquish > 0) {
                    additionalSquish = this.platformSpecificSquish / 2;
                }
                offsetX = this.taskListView.synchronizationOverlaid ? 42 - imageOffset - additionalSquish : 24 - imageOffset - additionalSquish;
            }
        }
        if (image != null) {
            event.gc.drawImage(image, offsetX, event.y + offsetY);
        }
    }

    private boolean hideDecorationOnContainer(ITaskContainer element, TreeItem treeItem) {
        RepositoryQuery query;
        if (element instanceof UnmatchedTaskContainer) {
            if (!this.taskListView.isFocusedMode()) {
                return false;
            }
            if (AbstractTaskListFilter.hasDescendantIncoming(element)) {
                return true;
            }
        } else if (element instanceof IRepositoryQuery && (query = (RepositoryQuery)element).getStatus() != null) {
            return true;
        }
        if (!this.taskListView.isFocusedMode()) {
            return false;
        }
        if (element instanceof IRepositoryQuery || element instanceof TaskCategory) {
            return treeItem.getExpanded();
        }
        return false;
    }

    private void drawActivationImage(int activationImageOffset, Event event, Image image) {
        Rectangle rect = image.getBounds();
        int offset = Math.max(0, (event.height - rect.height) / 2);
        event.gc.drawImage(image, activationImageOffset, event.y + offset);
    }

    private ImageDescriptor getSynchronizationImageDescriptor(Object element, boolean synchViewStyle) {
        RepositoryQuery query;
        if (element instanceof ITask) {
            ITask repositoryTask = (ITask)element;
            if (repositoryTask.getSynchronizationState() == ITask.SynchronizationState.INCOMING_NEW) {
                if (synchViewStyle) {
                    return CommonImages.OVERLAY_SYNC_OLD_INCOMMING_NEW;
                }
                return CommonImages.OVERLAY_SYNC_INCOMMING_NEW;
            }
            if (repositoryTask.getSynchronizationState() == ITask.SynchronizationState.OUTGOING_NEW) {
                if (synchViewStyle) {
                    return CommonImages.OVERLAY_SYNC_OLD_OUTGOING;
                }
                return CommonImages.OVERLAY_SYNC_OUTGOING_NEW;
            }
            ImageDescriptor imageDescriptor = null;
            if (repositoryTask.getSynchronizationState() == ITask.SynchronizationState.OUTGOING || repositoryTask.getSynchronizationState() == ITask.SynchronizationState.OUTGOING_NEW) {
                imageDescriptor = synchViewStyle ? CommonImages.OVERLAY_SYNC_OLD_OUTGOING : CommonImages.OVERLAY_SYNC_OUTGOING;
            } else if (repositoryTask.getSynchronizationState() == ITask.SynchronizationState.INCOMING) {
                imageDescriptor = synchViewStyle ? CommonImages.OVERLAY_SYNC_OLD_INCOMMING : CommonImages.OVERLAY_SYNC_INCOMMING;
            } else if (repositoryTask.getSynchronizationState() == ITask.SynchronizationState.CONFLICT) {
                imageDescriptor = CommonImages.OVERLAY_SYNC_CONFLICT;
            }
            if (imageDescriptor == null && repositoryTask instanceof AbstractTask && ((AbstractTask)repositoryTask).getStatus() != null) {
                return CommonImages.OVERLAY_SYNC_WARNING;
            }
            if (imageDescriptor != null) {
                return imageDescriptor;
            }
        } else if (element instanceof IRepositoryQuery && (query = (RepositoryQuery)element).getStatus() != null) {
            return CommonImages.OVERLAY_SYNC_WARNING;
        }
        return CommonImages.OVERLAY_CLEAR;
    }

    public void dispose() {
        TasksUiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.PROPERTY_LISTENER);
    }
}

