/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.internal.provisional.commons.ui.AbstractFilteredTree;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.TaskHistoryDropDown;
import org.eclipse.mylyn.internal.tasks.ui.TaskHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.ActivateTaskDialogAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyTaskDetailsAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.OpenTaskListElementAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskActivateAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskDeactivateAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskWorkingSetAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskListChangeAdapter;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.Messages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListToolTip;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.internal.tasks.ui.views.WorkweekProgressBar;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.TaskActivityAdapter;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.search.internal.ui.SearchDialog;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.internal.ObjectActionContributorManager;

public class TaskListFilteredTree
extends AbstractFilteredTree {
    public static final String LABEL_SEARCH = Messages.TaskListFilteredTree_Search_repository_for_key_or_summary_;
    private TaskHyperlink workingSetLink;
    private TaskHyperlink activeTaskLink;
    private WorkweekProgressBar taskProgressBar;
    private int totalTasks;
    private int completeTime;
    private int completeTasks;
    private int incompleteTime;
    private IWorkingSet currentWorkingSet;
    private MenuManager activeTaskMenuManager = null;
    private Menu activeTaskMenu = null;
    private final CopyTaskDetailsAction copyTaskDetailsAction = new CopyTaskDetailsAction();
    private TaskListToolTip taskListToolTip;
    private ITaskListChangeListener changeListener;

    public TaskListFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, treeStyle, filter);
        this.hookContextMenu();
    }

    public void dispose() {
        if (this.changeListener != null) {
            TasksUiInternal.getTaskList().removeChangeListener(this.changeListener);
        }
        super.dispose();
        this.taskListToolTip.dispose();
    }

    private void hookContextMenu() {
        this.activeTaskMenuManager = new MenuManager("#PopupMenu");
        this.activeTaskMenuManager.setRemoveAllWhenShown(true);
        this.activeTaskMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TaskListFilteredTree.this.fillContextMenu(manager, TasksUi.getTaskActivityManager().getActiveTask());
            }
        });
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        Composite container = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalIndent = 0;
        gridData.horizontalIndent = 0;
        container.setLayoutData((Object)gridData);
        container.setLayout((Layout)new TreeColumnLayout());
        return super.doCreateTreeViewer(container, style);
    }

    protected Composite createProgressComposite(Composite container) {
        Composite progressComposite = new Composite(container, 0);
        GridLayout progressLayout = new GridLayout(1, false);
        progressLayout.marginWidth = 4;
        progressLayout.marginHeight = 0;
        progressLayout.marginBottom = 0;
        progressLayout.horizontalSpacing = 0;
        progressLayout.verticalSpacing = 0;
        progressComposite.setLayout((Layout)progressLayout);
        progressComposite.setLayoutData((Object)new GridData(4, -1, true, false, 4, 1));
        this.taskProgressBar = new WorkweekProgressBar(progressComposite);
        this.taskProgressBar.setLayoutData(new GridData(4, 4, true, true));
        this.updateTaskProgressBar();
        TasksUiInternal.getTaskList().addChangeListener((ITaskListChangeListener)new TaskListChangeAdapter(){

            @Override
            public void containersChanged(Set<TaskContainerDelta> containers) {
                for (TaskContainerDelta taskContainerDelta : containers) {
                    if (!(taskContainerDelta.getElement() instanceof ITask)) continue;
                    TaskListFilteredTree.this.updateTaskProgressBar();
                    break;
                }
            }
        });
        TasksUiPlugin.getTaskActivityManager().addActivityListener((ITaskActivityListener)new TaskActivityAdapter(){

            public void activityReset() {
                TaskListFilteredTree.this.updateTaskProgressBar();
            }
        });
        return progressComposite;
    }

    protected Composite createSearchComposite(Composite container) {
        Composite searchComposite = new Composite(container, 0);
        GridLayout searchLayout = new GridLayout(1, false);
        searchLayout.marginWidth = 8;
        searchLayout.marginHeight = 0;
        searchLayout.marginBottom = 0;
        searchLayout.horizontalSpacing = 0;
        searchLayout.verticalSpacing = 0;
        searchComposite.setLayout((Layout)searchLayout);
        searchComposite.setLayoutData((Object)new GridData(4, -1, true, false, 4, 1));
        final TaskHyperlink searchLink = new TaskHyperlink(searchComposite, 16384);
        searchLink.setText(LABEL_SEARCH);
        searchLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                new SearchDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "org.eclipse.mylyn.tasks.ui.search.page").open();
            }

            public void linkEntered(HyperlinkEvent e) {
                searchLink.setUnderlined(true);
            }

            public void linkExited(HyperlinkEvent e) {
                searchLink.setUnderlined(false);
            }
        });
        return searchComposite;
    }

    private void updateTaskProgressBar() {
        if (this.taskProgressBar.isDisposed()) {
            return;
        }
        Set tasksThisWeek = TasksUiPlugin.getTaskActivityManager().getScheduledForADayThisWeek();
        this.totalTasks = tasksThisWeek.size();
        this.completeTime = 0;
        this.completeTasks = 0;
        this.incompleteTime = 0;
        for (ITask task : tasksThisWeek) {
            if (!(task instanceof AbstractTask)) continue;
            AbstractTask abstractTask = (AbstractTask)task;
            if (task.isCompleted()) {
                ++this.completeTasks;
                if (abstractTask.getEstimatedTimeHours() > 0) {
                    this.completeTime += abstractTask.getEstimatedTimeHours();
                    continue;
                }
                ++this.completeTime;
                continue;
            }
            if (abstractTask.getEstimatedTimeHours() > 0) {
                this.incompleteTime += abstractTask.getEstimatedTimeHours();
                continue;
            }
            ++this.incompleteTime;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (PlatformUI.isWorkbenchRunning() && !TaskListFilteredTree.this.taskProgressBar.isDisposed()) {
                    TaskListFilteredTree.this.taskProgressBar.reset(TaskListFilteredTree.this.completeTime, TaskListFilteredTree.this.completeTime + TaskListFilteredTree.this.incompleteTime);
                    TaskListFilteredTree.this.taskProgressBar.setToolTipText(String.valueOf(Messages.TaskListFilteredTree_Workweek_Progress) + "\n" + MessageFormat.format(Messages.TaskListFilteredTree_Estimated_hours, TaskListFilteredTree.this.completeTime, TaskListFilteredTree.this.completeTime + TaskListFilteredTree.this.incompleteTime) + "\n" + MessageFormat.format(Messages.TaskListFilteredTree_Scheduled_tasks, TaskListFilteredTree.this.completeTasks, TaskListFilteredTree.this.totalTasks));
                }
            }
        });
    }

    protected Composite createActiveWorkingSetComposite(Composite container) {
        final ImageHyperlink workingSetButton = new ImageHyperlink(container, 0x800000);
        workingSetButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.TOOLBAR_ARROW_RIGHT));
        workingSetButton.setToolTipText(Messages.TaskListFilteredTree_Select_Working_Set);
        this.workingSetLink = new TaskHyperlink(container, 16384);
        this.workingSetLink.setText(TaskWorkingSetAction.LABEL_SETS_NONE);
        this.workingSetLink.setUnderlined(false);
        final TaskWorkingSetAction workingSetAction = new TaskWorkingSetAction();
        workingSetButton.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                workingSetAction.getMenu((Control)workingSetButton).setVisible(true);
            }

            public void linkEntered(HyperlinkEvent e) {
                workingSetButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.TOOLBAR_ARROW_DOWN));
            }

            public void linkExited(HyperlinkEvent e) {
                workingSetButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.TOOLBAR_ARROW_RIGHT));
            }
        });
        this.indicateActiveTaskWorkingSet();
        this.workingSetLink.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (TaskListFilteredTree.this.currentWorkingSet != null) {
                    workingSetAction.run(TaskListFilteredTree.this.currentWorkingSet);
                } else {
                    workingSetAction.run();
                }
            }
        });
        return this.workingSetLink;
    }

    protected Composite createActiveTaskComposite(final Composite container) {
        final ImageHyperlink activeTaskButton = new ImageHyperlink(container, 16384);
        activeTaskButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.TOOLBAR_ARROW_RIGHT));
        activeTaskButton.setToolTipText(Messages.TaskListFilteredTree_Select_Active_Task);
        this.activeTaskLink = new TaskHyperlink(container, 16384);
        this.changeListener = new TaskListChangeAdapter(){

            @Override
            public void containersChanged(Set<TaskContainerDelta> containers) {
                for (TaskContainerDelta taskContainerDelta : containers) {
                    AbstractTask changedTask;
                    if (!(taskContainerDelta.getElement() instanceof ITask) || !(changedTask = (AbstractTask)taskContainerDelta.getElement()).isActive() || !Platform.isRunning() || PlatformUI.getWorkbench() == null) continue;
                    if (Display.getCurrent() == null) {
                        if (PlatformUI.getWorkbench().getDisplay() == null || PlatformUI.getWorkbench().getDisplay().isDisposed()) continue;
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                TaskListFilteredTree.this.indicateActiveTask((ITask)changedTask);
                            }
                        });
                        continue;
                    }
                    TaskListFilteredTree.this.indicateActiveTask((ITask)changedTask);
                }
            }
        };
        TasksUiInternal.getTaskList().addChangeListener(this.changeListener);
        this.activeTaskLink.setText(Messages.TaskListFilteredTree_Activate);
        this.activeTaskLink.setToolTipText("");
        this.taskListToolTip = new TaskListToolTip((Control)this.activeTaskLink);
        ITask activeTask = TasksUi.getTaskActivityManager().getActiveTask();
        if (activeTask != null) {
            this.indicateActiveTask(activeTask);
        }
        activeTaskButton.addHyperlinkListener(new IHyperlinkListener(){
            private Menu dropDownMenu;

            public void linkActivated(HyperlinkEvent event) {
                if (this.dropDownMenu != null) {
                    this.dropDownMenu.dispose();
                }
                TaskHistoryDropDown taskHistory = new TaskHistoryDropDown();
                taskHistory.setScopedToWorkingSet(true);
                this.dropDownMenu = new Menu((Control)activeTaskButton);
                taskHistory.fill(this.dropDownMenu, 0);
                this.dropDownMenu.setVisible(true);
            }

            public void linkEntered(HyperlinkEvent event) {
                activeTaskButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.TOOLBAR_ARROW_DOWN));
            }

            public void linkExited(HyperlinkEvent event) {
                activeTaskButton.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.TOOLBAR_ARROW_RIGHT));
            }
        });
        this.activeTaskLink.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                if (TaskListFilteredTree.this.activeTaskMenu != null) {
                    TaskListFilteredTree.this.activeTaskMenu.dispose();
                }
                TaskListFilteredTree.this.activeTaskMenu = TaskListFilteredTree.this.activeTaskMenuManager.createContextMenu((Control)container);
                TaskListFilteredTree.this.activeTaskMenu.setVisible(true);
            }
        });
        this.activeTaskLink.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    ITask activeTask = TasksUi.getTaskActivityManager().getActiveTask();
                    if (activeTask == null) {
                        ActivateTaskDialogAction activateAction = new ActivateTaskDialogAction();
                        activateAction.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                        activateAction.run(null);
                    } else {
                        TasksUiInternal.refreshAndOpenTaskListElement((IRepositoryElement)activeTask);
                    }
                }
            }
        });
        return this.activeTaskLink;
    }

    protected void textChanged() {
        super.textChanged();
        if (this.getFilterString() != null && !this.getFilterString().trim().equals("")) {
            this.setShowSearch(true);
        } else {
            this.setShowSearch(false);
        }
    }

    public void indicateActiveTaskWorkingSet() {
        Set<IWorkingSet> activeSets = TaskListView.getActiveWorkingSets();
        if (this.filterComposite.isDisposed() || activeSets == null) {
            return;
        }
        if (activeSets.size() == 0) {
            this.workingSetLink.setText(TaskWorkingSetAction.LABEL_SETS_NONE);
            this.workingSetLink.setToolTipText(Messages.TaskListFilteredTree_Edit_Task_Working_Sets_);
            this.currentWorkingSet = null;
        } else if (activeSets.size() > 1) {
            this.workingSetLink.setText(Messages.TaskListFilteredTree__multiple_);
            this.workingSetLink.setToolTipText(Messages.TaskListFilteredTree_Edit_Task_Working_Sets_);
            this.currentWorkingSet = null;
        } else {
            Object[] array = activeSets.toArray();
            IWorkingSet workingSet = (IWorkingSet)array[0];
            this.workingSetLink.setText(workingSet.getLabel());
            this.workingSetLink.setToolTipText(Messages.TaskListFilteredTree_Edit_Task_Working_Sets_);
            this.currentWorkingSet = workingSet;
        }
        this.filterComposite.layout();
    }

    public void indicateActiveTask(ITask task) {
        if (Display.getCurrent() != null) {
            if (this.filterComposite.isDisposed()) {
                return;
            }
            this.activeTaskLink.setTask(task);
            this.filterComposite.layout();
        }
    }

    public String getActiveTaskLabelText() {
        return this.activeTaskLink.getText();
    }

    public void indicateNoActiveTask() {
        if (this.filterComposite.isDisposed()) {
            return;
        }
        this.activeTaskLink.setTask(null);
        this.activeTaskLink.setText(Messages.TaskListFilteredTree_Activate);
        this.activeTaskLink.setToolTipText("");
        this.filterComposite.layout();
    }

    public void setFilterText(String string) {
        if (this.filterText != null) {
            this.filterText.setText(string);
            this.selectAll();
        }
    }

    private void fillContextMenu(IMenuManager manager, final ITask activeTask) {
        if (activeTask != null) {
            StructuredSelection selection = new StructuredSelection((Object)activeTask);
            this.copyTaskDetailsAction.selectionChanged((IStructuredSelection)selection);
            manager.add((IAction)new OpenTaskListElementAction(null){

                public void run() {
                    TasksUiInternal.refreshAndOpenTaskListElement((IRepositoryElement)activeTask);
                }
            });
            if (activeTask.isActive()) {
                manager.add((IAction)new TaskDeactivateAction(){

                    public void run() {
                        super.run(activeTask);
                    }
                });
            } else {
                manager.add((IAction)new TaskActivateAction(){

                    public void run() {
                        super.run(activeTask);
                    }
                });
            }
            manager.add((IContributionItem)new Separator());
            for (String menuPath : TasksUiPlugin.getDefault().getDynamicMenuMap().keySet()) {
                for (IDynamicSubMenuContributor contributor : TasksUiPlugin.getDefault().getDynamicMenuMap().get(menuPath)) {
                    if (!"tasks".equals(menuPath)) continue;
                    ArrayList<IRepositoryElement> selectedElements = new ArrayList<IRepositoryElement>();
                    selectedElements.add((IRepositoryElement)activeTask);
                    MenuManager subMenuManager = contributor.getSubMenuManager(selectedElements);
                    if (subMenuManager == null) continue;
                    manager.add((IContributionItem)subMenuManager);
                }
            }
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.copyTaskDetailsAction);
            manager.add((IContributionItem)new Separator());
            ObjectActionContributorManager.getManager().contributeObjectActions(null, manager, new ISelectionProvider(){

                public void addSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public ISelection getSelection() {
                    return new StructuredSelection((Object)activeTask);
                }

                public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public void setSelection(ISelection selection) {
                }
            });
        }
    }

    protected String getFilterString() {
        String text = super.getFilterString();
        return text != null ? text.trim() : null;
    }
}

