/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskGroup;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnsubmittedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskComparator;
import org.eclipse.mylyn.tasks.core.ITask;

public class TaskListSorter
extends ViewerSorter {
    public static final int DEFAULT_SORT_DIRECTION = 1;
    private int sortDirectionRootElement = 1;
    private final TaskComparator taskComparator = new TaskComparator();

    public int compare(Viewer compareViewer, Object o1, Object o2) {
        int o2Type;
        if (o1 instanceof AbstractTask && o2 instanceof AbstractTask) {
            ITask element1 = (ITask)o1;
            ITask element2 = (ITask)o2;
            return this.compareElements(element1, element2);
        }
        if (o1 instanceof ScheduledTaskContainer && o2 instanceof ScheduledTaskContainer) {
            ScheduledTaskContainer dateRangeTaskContainer1 = (ScheduledTaskContainer)o1;
            ScheduledTaskContainer dateRangeTaskContainer2 = (ScheduledTaskContainer)o2;
            return dateRangeTaskContainer1.getDateRange().compareTo(dateRangeTaskContainer2.getDateRange());
        }
        int o1Type = o1 instanceof AbstractTask ? 0 : (o1 instanceof UncategorizedTaskContainer ? 1 : (o1 instanceof UnsubmittedTaskContainer ? 2 : (o1 instanceof TaskCategory ? 3 : (o1 instanceof RepositoryQuery ? 4 : (o1 instanceof TaskGroup ? 5 : (o1 instanceof UnmatchedTaskContainer ? 6 : 99))))));
        if (o1Type != (o2Type = o2 instanceof AbstractTask ? 0 : (o2 instanceof UncategorizedTaskContainer ? 1 : (o2 instanceof UnsubmittedTaskContainer ? 2 : (o2 instanceof TaskCategory ? 3 : (o2 instanceof RepositoryQuery ? 4 : (o2 instanceof TaskGroup ? 5 : (o2 instanceof UnmatchedTaskContainer ? 6 : 99)))))))) {
            return o1Type - o2Type < 0 ? -1 : 1;
        }
        if (o1Type < 7) {
            AbstractTaskContainer taskContainer1 = (AbstractTaskContainer)o1;
            AbstractTaskContainer taskContainer2 = (AbstractTaskContainer)o2;
            return this.sortDirectionRootElement * taskContainer1.getSummary().compareToIgnoreCase(taskContainer2.getSummary());
        }
        return 0;
    }

    private int compareElements(ITask element1, ITask element2) {
        return this.taskComparator.compare(element1, element2);
    }

    public TaskComparator getComparator() {
        return this.taskComparator;
    }

    public int getSortDirectionRootElement() {
        return this.sortDirectionRootElement;
    }

    public void setSortDirectionRootElement(int sortDirection) {
        this.sortDirectionRootElement = sortDirection;
    }
}

