/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoriesSorter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoryLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SelectRepositoryConnectorPage
extends WizardPage {
    private TableViewer viewer;
    private AbstractRepositoryConnector connector;

    public SelectRepositoryConnectorPage() {
        super(Messages.SelectRepositoryConnectorPage_Select_a_task_repository_type);
        this.setTitle(Messages.SelectRepositoryConnectorPage_Select_a_task_repository_type);
        this.setDescription(Messages.SelectRepositoryConnectorPage_You_can_connect_to_an_existing_account_using_one_of_the_installed_connectors);
    }

    public boolean canFlipToNextPage() {
        return this.connector != null;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        container.setLayout((Layout)layout);
        this.viewer = new TableViewer(container, 2820);
        this.viewer.setContentProvider((IContentProvider)new RepositoryContentProvider());
        this.viewer.setSorter((ViewerSorter)new TaskRepositoriesSorter());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TaskRepositoryLabelProvider());
        this.viewer.setInput((Object)TasksUi.getRepositoryManager().getRepositoryConnectors());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof AbstractRepositoryConnector) {
                    SelectRepositoryConnectorPage.this.connector = (AbstractRepositoryConnector)selection.getFirstElement();
                    SelectRepositoryConnectorPage.this.setPageComplete(true);
                }
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                SelectRepositoryConnectorPage.this.getContainer().showPage(SelectRepositoryConnectorPage.this.getNextPage());
            }
        });
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    public AbstractRepositoryConnector getConnector() {
        return this.connector;
    }

    static class RepositoryContentProvider
    implements IStructuredContentProvider {
        RepositoryContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            ArrayList<AbstractRepositoryConnector> userManagedRepositories = new ArrayList<AbstractRepositoryConnector>();
            for (AbstractRepositoryConnector connector : TasksUi.getRepositoryManager().getRepositoryConnectors()) {
                if (!connector.isUserManaged()) continue;
                userManagedRepositories.add(connector);
            }
            return userManagedRepositories.toArray();
        }
    }
}

