/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.io.File;
import java.text.DateFormat;
import java.util.SortedMap;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TaskDataImportWizardPage
extends WizardPage {
    private Button browseButtonZip = null;
    private Text sourceZipText = null;
    private Button importViaBackupButton;
    private Button importViaZipButton;
    private Table backupFilesTable;
    private static final String SETTINGS_SAVED = Messages.TaskDataImportWizardPage_Import_Settings_saved;
    private static final String SOURCE_ZIP_SETTING = Messages.TaskDataImportWizardPage_Import_Source_zip_file_setting;
    private static final String IMPORT_ZIPMETHOD_SETTING = Messages.TaskDataImportWizardPage_Import_method_zip;
    private static final String IMPORT_BACKUPMETHOD_SETTING = Messages.TaskDataImportWizardPage_Import_method_backup;

    public TaskDataImportWizardPage() {
        super("org.eclipse.mylyn.tasklist.importPage");
        this.setPageComplete(false);
        this.setMessage(Messages.TaskDataImportWizardPage_Importing_overwrites_current_tasks_and_repositories, 2);
        this.setImageDescriptor(CommonImages.BANNER_IMPORT);
        this.setTitle(Messages.TaskDataImportWizardPage_Restore_tasks_from_history);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.verticalSpacing = 15;
        container.setLayout((Layout)layout);
        this.createImportFromZipControl(container);
        this.createImportFromBackupControl(container);
        this.addRadioListeners();
        this.initSettings();
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
        this.setPageComplete(this.validate());
    }

    private void addRadioListeners() {
        SelectionListener radioListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TaskDataImportWizardPage.this.browseButtonZip.setEnabled(TaskDataImportWizardPage.this.importViaZipButton.getSelection());
                TaskDataImportWizardPage.this.backupFilesTable.setEnabled(TaskDataImportWizardPage.this.importViaBackupButton.getSelection());
                TaskDataImportWizardPage.this.sourceZipText.setEnabled(TaskDataImportWizardPage.this.importViaZipButton.getSelection());
                TaskDataImportWizardPage.this.controlChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.importViaZipButton.addSelectionListener(radioListener);
        this.importViaBackupButton.addSelectionListener(radioListener);
    }

    private void createImportFromZipControl(Composite parent) {
        this.importViaZipButton = new Button(parent, 16);
        this.importViaZipButton.setText(Messages.TaskDataImportWizardPage_From_zip_file);
        this.sourceZipText = new Text(parent, 2048);
        this.sourceZipText.setEditable(true);
        GridDataFactory.fillDefaults().grab(true, false).hint(250, -1).applyTo((Control)this.sourceZipText);
        this.sourceZipText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TaskDataImportWizardPage.this.controlChanged();
            }
        });
        this.browseButtonZip = new Button(parent, 8);
        this.browseButtonZip.setText(Messages.TaskDataImportWizardPage_Browse_);
        this.browseButtonZip.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(TaskDataImportWizardPage.this.getShell());
                dialog.setText(Messages.TaskDataImportWizardPage_Zip_File_Selection);
                String dir = TaskDataImportWizardPage.this.sourceZipText.getText();
                dialog.setFilterPath(dir);
                dir = dialog.open();
                if (dir == null || dir.equals("")) {
                    return;
                }
                TaskDataImportWizardPage.this.sourceZipText.setText(dir);
            }
        });
    }

    private void createImportFromBackupControl(Composite container) {
        this.importViaBackupButton = new Button(container, 16);
        this.importViaBackupButton.setText(Messages.TaskDataImportWizardPage_From_snapshot);
        this.addBackupFileView(container);
    }

    private void addBackupFileView(Composite composite) {
        this.backupFilesTable = new Table(composite, 2048);
        GridDataFactory.fillDefaults().span(2, -1).grab(true, true).applyTo((Control)this.backupFilesTable);
        TableColumn filenameColumn = new TableColumn(this.backupFilesTable, 16384);
        filenameColumn.setWidth(200);
        SortedMap<Long, File> backupFilesMap = TasksUiPlugin.getBackupManager().getBackupFiles();
        for (Long time : backupFilesMap.keySet()) {
            File file = (File)backupFilesMap.get(time);
            TableItem item = new TableItem(this.backupFilesTable, 0);
            item.setData((Object)file.getAbsolutePath());
            item.setText(DateFormat.getDateTimeInstance().format(time));
        }
        this.backupFilesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskDataImportWizardPage.this.controlChanged();
            }
        });
    }

    protected void initSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings.get(SETTINGS_SAVED) == null) {
            this.importViaZipButton.setSelection(true);
            this.sourceZipText.setEnabled(true);
            this.backupFilesTable.setEnabled(false);
        } else {
            this.importViaZipButton.setSelection(settings.getBoolean(IMPORT_ZIPMETHOD_SETTING));
            this.importViaBackupButton.setSelection(settings.getBoolean(IMPORT_BACKUPMETHOD_SETTING));
            this.browseButtonZip.setEnabled(this.importViaZipButton.getSelection());
            this.sourceZipText.setEnabled(this.importViaZipButton.getSelection());
            this.backupFilesTable.setEnabled(this.importViaBackupButton.getSelection());
            String zipFile = settings.get(SOURCE_ZIP_SETTING);
            if (zipFile != null) {
                this.sourceZipText.setText(settings.get(SOURCE_ZIP_SETTING));
            }
        }
    }

    public void saveSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(IMPORT_ZIPMETHOD_SETTING, this.importViaZipButton.getSelection());
        settings.put(IMPORT_BACKUPMETHOD_SETTING, this.importViaBackupButton.getSelection());
        settings.put(SETTINGS_SAVED, SETTINGS_SAVED);
    }

    public void controlChanged() {
        this.setPageComplete(this.validate());
    }

    protected boolean validate() {
        if (this.importViaZipButton.getSelection() && this.sourceZipText.getText().equals("")) {
            return false;
        }
        return !this.importViaBackupButton.getSelection() || this.backupFilesTable.getSelection().length != 0;
    }

    public String getSourceZipFile() {
        if (this.importViaZipButton.getSelection()) {
            return this.sourceZipText.getText();
        }
        if (this.backupFilesTable.getSelectionIndex() != -1) {
            return (String)this.backupFilesTable.getSelection()[0].getData();
        }
        return Messages.TaskDataImportWizardPage__unspecified_;
    }

    public void setSource(boolean zip, String sourceZip) {
        this.sourceZipText.setText(sourceZip);
        this.importViaZipButton.setSelection(zip);
    }
}

