/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskEditorScheduleAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.ToggleTaskActivationAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorBusyIndicator;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.IBusyEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorActionContributor;
import org.eclipse.mylyn.internal.tasks.ui.util.SelectionProviderAdapter;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskDragSourceListener;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPageFactory;
import org.eclipse.mylyn.tasks.ui.editors.BrowserFormPage;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskFormPage;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class TaskEditor
extends SharedHeaderFormEditor {
    public static final String ID_EDITOR = "org.eclipse.mylyn.tasks.ui.editors.task";
    private ToggleTaskActivationAction activateAction;
    @Deprecated
    private final IEditorPart contentOutlineProvider = null;
    private EditorBusyIndicator editorBusyIndicator;
    private MenuManager menuManager;
    private IHyperlinkListener messageHyperLinkListener;
    private ITask task;
    private TaskEditorInput taskEditorInput;
    private TaskDragSourceListener titleDragSourceListener;
    private Composite editorParent;

    protected Composite createPageContainer(Composite parent) {
        this.editorParent = parent;
        return super.createPageContainer(parent);
    }

    Composite getEditorParent() {
        return this.editorParent;
    }

    protected void addPages() {
        this.initialize();
        HashSet conflictingIds = new HashSet();
        ArrayList<AbstractTaskEditorPageFactory> pageFactories = new ArrayList<AbstractTaskEditorPageFactory>();
        AbstractTaskEditorPageFactory[] abstractTaskEditorPageFactoryArray = TasksUiPlugin.getDefault().getTaskEditorPageFactories();
        int n = abstractTaskEditorPageFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTaskEditorPageFactory pageFactory = abstractTaskEditorPageFactoryArray[n2];
            if (pageFactory.canCreatePageFor(this.getTaskEditorInput())) {
                pageFactories.add(pageFactory);
                String[] ids = pageFactory.getConflictingIds(this.getTaskEditorInput());
                if (ids != null) {
                    conflictingIds.addAll(Arrays.asList(ids));
                }
            }
            ++n2;
        }
        Iterator it = pageFactories.iterator();
        while (it.hasNext()) {
            if (!conflictingIds.contains(((AbstractTaskEditorPageFactory)it.next()).getId())) continue;
            it.remove();
        }
        Collections.sort(pageFactories, new Comparator<AbstractTaskEditorPageFactory>(){

            @Override
            public int compare(AbstractTaskEditorPageFactory o1, AbstractTaskEditorPageFactory o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        for (AbstractTaskEditorPageFactory factory : pageFactories) {
            try {
                IFormPage page = factory.createPage(this);
                int index = this.addPage(page);
                this.setPageImage(index, factory.getPageImage());
                this.setPageText(index, factory.getPageText());
                if (factory.getPriority() == 30) {
                    this.setActivePage(index);
                }
                if (!(page instanceof ISelectionProvider)) continue;
                ((ISelectionProvider)page).addSelectionChangedListener((ISelectionChangedListener)this.getActionBarContributor());
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not create editor via factory: " + factory, (Throwable)e));
            }
        }
        this.updateTitleImage();
        this.updateHeaderToolBar();
    }

    private void initialize() {
        this.editorBusyIndicator = new EditorBusyIndicator(new IBusyEditor(){

            public Image getTitleImage() {
                return TaskEditor.this.getTitleImage();
            }

            public void setTitleImage(Image image) {
                TaskEditor.this.setTitleImage(image);
            }
        });
        this.menuManager = new MenuManager();
        this.configureContextMenuManager(this.menuManager);
        Menu menu = this.menuManager.createContextMenu((Control)this.getContainer());
        this.getContainer().setMenu(menu);
        this.getEditorSite().registerContextMenu(this.menuManager, this.getEditorSite().getSelectionProvider(), false);
        this.getHeaderForm().getForm().setMenu(menu);
        Composite head = this.getHeaderForm().getForm().getForm().getHead();
        if (head != null) {
            EditorUtil.setMenu(head, menu);
        }
    }

    @Deprecated
    public void configureContextMenuManager(MenuManager manager) {
        if (manager == null) {
            return;
        }
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TaskEditor.this.contextMenuAboutToShow(manager);
            }
        };
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(listener);
    }

    @Deprecated
    protected void contextMenuAboutToShow(IMenuManager manager) {
        TaskEditorActionContributor contributor = this.getActionBarContributor();
        if (contributor != null) {
            contributor.contextMenuAboutToShow(manager);
        }
    }

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(TasksUiPlugin.getDefault().getFormColors(display));
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        this.getToolkit().decorateFormHeading(headerForm.getForm().getForm());
        this.updateHeader();
        this.installTitleDrag(this.getHeaderForm().getForm().getForm());
    }

    public void dispose() {
        if (this.editorBusyIndicator != null) {
            this.editorBusyIndicator.stop();
        }
        if (this.activateAction != null) {
            this.activateAction.dispose();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        IFormPage[] iFormPageArray = this.getPages();
        int n = iFormPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage page = iFormPageArray[n2];
            if (page.isDirty()) {
                page.doSave(monitor);
            }
            ++n2;
        }
        this.editorDirtyStateChanged();
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    private TaskEditorActionContributor getActionBarContributor() {
        return (TaskEditorActionContributor)this.getEditorSite().getActionBarContributor();
    }

    public Object getAdapter(Class adapter) {
        if (this.contentOutlineProvider != null) {
            return this.contentOutlineProvider.getAdapter(adapter);
        }
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            IFormPage[] pages;
            IFormPage[] iFormPageArray = pages = this.getPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IFormPage page = iFormPageArray[n2];
                Object outlinePage = page.getAdapter(adapter);
                if (outlinePage != null) {
                    return outlinePage;
                }
                ++n2;
            }
        }
        return super.getAdapter(adapter);
    }

    public Menu getMenu() {
        return this.getContainer().getMenu();
    }

    IFormPage[] getPages() {
        ArrayList formPages = new ArrayList();
        if (this.pages != null) {
            int i = 0;
            while (i < this.pages.size()) {
                Object page = this.pages.get(i);
                if (page instanceof IFormPage) {
                    formPages.add(page);
                }
                ++i;
            }
        }
        return formPages.toArray(new IFormPage[formPages.size()]);
    }

    @Deprecated
    protected IWorkbenchSiteProgressService getProgressService() {
        Object siteService = this.getEditorSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (siteService != null) {
            return (IWorkbenchSiteProgressService)siteService;
        }
        return null;
    }

    @Deprecated
    public ISelection getSelection() {
        if (this.getSite() != null && this.getSite().getSelectionProvider() != null) {
            return this.getSite().getSelectionProvider().getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public TaskEditorInput getTaskEditorInput() {
        return this.taskEditorInput;
    }

    @Deprecated
    public Form getTopForm() {
        return this.getHeaderForm().getForm().getForm();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof TaskEditorInput)) {
            throw new PartInitException("Invalid editor input \"" + input.getClass() + "\"");
        }
        super.init(site, input);
        this.taskEditorInput = (TaskEditorInput)input;
        this.task = this.taskEditorInput.getTask();
        this.setPartName(input.getName());
        IContextService contextSupport = (IContextService)site.getService(IContextService.class);
        if (contextSupport != null) {
            contextSupport.activateContext(ID_EDITOR);
        }
    }

    private void installTitleDrag(Form form) {
        if (this.titleDragSourceListener == null) {
            Transfer[] transferTypes = this.task == null ? new Transfer[]{TextTransfer.getInstance()} : new Transfer[]{LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance(), FileTransfer.getInstance()};
            this.titleDragSourceListener = new TaskDragSourceListener(new SelectionProviderAdapter(){

                public ISelection getSelection() {
                    return new StructuredSelection((Object)TaskEditor.this.task);
                }
            });
            form.addTitleDragSupport(6, transferTypes, (DragSourceListener)this.titleDragSourceListener);
        }
    }

    public boolean isDirty() {
        IFormPage[] iFormPageArray = this.getPages();
        int n = iFormPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage page = iFormPageArray[n2];
            if (page.isDirty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    @Deprecated
    public void markDirty() {
        this.firePropertyChange(257);
    }

    public void refreshPages() {
        IFormPage[] iFormPageArray = this.getPages();
        int n = iFormPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage page = iFormPageArray[n2];
            if (page instanceof AbstractTaskEditorPage) {
                ((AbstractTaskEditorPage)page).refreshFormContent();
            } else if (page instanceof BrowserFormPage) {
                ((BrowserFormPage)page).init(this.getEditorSite(), this.getEditorInput());
            }
            ++n2;
        }
    }

    public void setFocus() {
        IFormPage page = this.getActivePageInstance();
        if (page != null) {
            page.setFocus();
        } else {
            super.setFocus();
        }
    }

    @Deprecated
    public void setFocusOfActivePage() {
        IFormPage page;
        if (this.getActivePage() > -1 && (page = this.getPages()[this.getActivePage()]) != null) {
            page.setFocus();
        }
    }

    public void setMessage(String message, int type) {
        this.setMessage(message, type, null);
    }

    public void setMessage(String message, int type, IHyperlinkListener listener) {
        if (this.getHeaderForm() != null && this.getHeaderForm().getForm() != null && !this.getHeaderForm().getForm().isDisposed()) {
            Form form = this.getHeaderForm().getForm().getForm();
            form.setMessage(message, type);
            if (this.messageHyperLinkListener != null) {
                form.removeMessageHyperlinkListener(this.messageHyperLinkListener);
            }
            if (listener != null) {
                form.addMessageHyperlinkListener(listener);
            }
            this.messageHyperLinkListener = listener;
        }
    }

    public String getMessage() {
        if (this.getHeaderForm() != null && this.getHeaderForm().getForm() != null && !this.getHeaderForm().getForm().isDisposed()) {
            Form form = this.getHeaderForm().getForm().getForm();
            return form.getMessage();
        }
        return null;
    }

    public void setStatus(String message, final String title, final IStatus status) {
        this.setMessage(message, 3, (IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                TasksUiInternal.displayStatus(title, status);
            }
        });
    }

    public void showBusy(boolean busy) {
        Form form;
        if (this.editorBusyIndicator != null) {
            if (busy) {
                if (TasksUiInternal.isAnimationsEnabled()) {
                    this.editorBusyIndicator.start();
                }
            } else {
                this.editorBusyIndicator.stop();
            }
        }
        if (this.getHeaderForm() != null && this.getHeaderForm().getForm() != null && !this.getHeaderForm().getForm().isDisposed() && (form = this.getHeaderForm().getForm().getForm()) != null && !form.isDisposed()) {
            ToolBar control;
            IToolBarManager toolBarManager = form.getToolBarManager();
            if (toolBarManager instanceof ToolBarManager && (control = ((ToolBarManager)toolBarManager).getControl()) != null) {
                control.setEnabled(!busy);
            }
            EditorUtil.setEnabledState(form.getBody(), !busy);
            IFormPage[] iFormPageArray = this.getPages();
            int n = iFormPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormPage page = iFormPageArray[n2];
                if (page instanceof WorkbenchPart) {
                    WorkbenchPart part = (WorkbenchPart)page;
                    part.showBusy(busy);
                }
                ++n2;
            }
        }
    }

    private void updateHeader() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof TaskEditorInput) {
            this.updateHeaderImage(this.task.getConnectorKind());
            this.updateHeaderLabel(this.task);
        }
        this.setTitleToolTip(input.getToolTipText());
        this.setPartName(input.getName());
        this.installTitleDrag(this.getHeaderForm().getForm().getForm());
    }

    public void updateHeaderToolBar() {
        Form form = this.getHeaderForm().getForm().getForm();
        IToolBarManager toolBarManager = form.getToolBarManager();
        toolBarManager.removeAll();
        toolBarManager.update(true);
        TaskRepository outgoingNewRepository = TasksUiUtil.getOutgoingNewTaskRepository(this.task);
        if (!"local".equals(this.taskEditorInput.getTaskRepository().getConnectorKind()) || outgoingNewRepository != null) {
            final TaskRepository taskRepository = outgoingNewRepository != null ? outgoingNewRepository : this.taskEditorInput.getTaskRepository();
            ControlContribution repositoryLabelControl = new ControlContribution(Messages.AbstractTaskEditorPage_Title){

                protected Control createControl(Composite parent) {
                    FormToolkit toolkit = TaskEditor.this.getHeaderForm().getToolkit();
                    Composite composite = toolkit.createComposite(parent);
                    composite.setLayout((Layout)new RowLayout());
                    composite.setBackground(null);
                    String label = taskRepository.getRepositoryLabel();
                    if (label.indexOf("//") != -1) {
                        label = label.substring(taskRepository.getRepositoryUrl().indexOf("//") + 2);
                    }
                    Hyperlink link = new Hyperlink(composite, 0);
                    link.setText(label);
                    link.setFont(JFaceResources.getBannerFont());
                    link.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                    link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            TasksUiUtil.openEditRepositoryWizard(taskRepository);
                        }
                    });
                    return composite;
                }
            };
            toolBarManager.add((IContributionItem)repositoryLabelControl);
        }
        IFormPage[] iFormPageArray = this.getPages();
        int n = iFormPageArray.length;
        int repositoryLabelControl = 0;
        while (repositoryLabelControl < n) {
            IFormPage page = iFormPageArray[repositoryLabelControl];
            if (page instanceof TaskFormPage) {
                TaskFormPage taskEditorPage = (TaskFormPage)page;
                taskEditorPage.fillToolBar(toolBarManager);
            }
            ++repositoryLabelControl;
        }
        final String taskUrl = this.task.getUrl();
        if (taskUrl != null && taskUrl.length() > 0) {
            Action openWithBrowserAction = new Action(){

                public void run() {
                    TasksUiUtil.openUrl(taskUrl);
                }
            };
            openWithBrowserAction.setImageDescriptor(CommonImages.BROWSER_OPEN_TASK);
            openWithBrowserAction.setToolTipText(Messages.AbstractTaskEditorPage_Open_with_Web_Browser);
            toolBarManager.add((IAction)openWithBrowserAction);
        }
        if (this.activateAction == null) {
            this.activateAction = new ToggleTaskActivationAction(this.task){

                public void run() {
                    TaskList taskList = TasksUiPlugin.getTaskList();
                    if (taskList.getTask(TaskEditor.this.task.getRepositoryUrl(), TaskEditor.this.task.getTaskId()) == null) {
                        TaskEditor.this.setMessage(Messages.TaskEditor_Task_added_to_the_Uncategorized_container, 1);
                    }
                    super.run();
                }
            };
        }
        toolBarManager.add((IContributionItem)new Separator("planning"));
        toolBarManager.add((IAction)new TaskEditorScheduleAction(this.task));
        toolBarManager.add((IContributionItem)new Separator("activation"));
        toolBarManager.add((IAction)this.activateAction);
        toolBarManager.update(true);
        this.updateHeader();
    }

    private void updateHeaderImage(String connectorKind) {
        if ("local".equals(connectorKind)) {
            this.getHeaderForm().getForm().setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        } else {
            ImageDescriptor overlay = TasksUiPlugin.getDefault().getOverlayIcon(connectorKind);
            Image image = CommonImages.getImageWithOverlay((ImageDescriptor)TasksUiImages.REPOSITORY, (ImageDescriptor)overlay, (boolean)false, (boolean)false);
            this.getHeaderForm().getForm().setImage(image);
        }
    }

    private void updateHeaderLabel(ITask task) {
        if (task instanceof LocalTask) {
            this.getHeaderForm().getForm().setText(String.valueOf(Messages.TaskEditor_Task_) + task.getSummary());
        } else {
            String idLabel;
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(task.getConnectorKind());
            String kindLabel = "";
            if (connectorUi != null) {
                kindLabel = connectorUi.getTaskKindLabel(task);
            }
            if ((idLabel = task.getTaskKey()) != null) {
                this.getHeaderForm().getForm().setText(String.valueOf(kindLabel) + " " + idLabel);
            } else {
                this.getHeaderForm().getForm().setText(kindLabel);
            }
        }
    }

    @Deprecated
    public void updateTitle(String name) {
        this.updateHeader();
    }

    private void updateTitleImage() {
        if (this.task != null) {
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(this.task.getConnectorKind());
            if (connectorUi != null) {
                ImageDescriptor overlayDescriptor = connectorUi.getTaskKindOverlay(this.task);
                this.setTitleImage(CommonImages.getCompositeTaskImage((ImageDescriptor)TasksUiImages.TASK, (ImageDescriptor)overlayDescriptor, (boolean)false));
            } else {
                this.setTitleImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK));
            }
        } else {
            this.setTitleImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        }
    }
}

