/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.mylyn.internal.wikitext.ui.editor.validation.DocumentRegionValidator;
import org.eclipse.mylyn.internal.wikitext.ui.editor.validation.Messages;
import org.eclipse.mylyn.internal.wikitext.ui.editor.validation.ValidationProblemAnnotation;
import org.eclipse.mylyn.wikitext.core.validation.ValidationProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMarkupValidator
extends DocumentRegionValidator {
    @Override
    protected void clearProblems(IProgressMonitor monitor, IDocument document, IRegion region) throws CoreException {
        monitor.beginTask(Messages.getString("AnnotationMarkupValidator.0"), 100);
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createProblems(IProgressMonitor monitor, IDocument document, IRegion region, List<ValidationProblem> problems) throws CoreException {
        Object lockObject = this.annotationModel instanceof ISynchronizable ? ((ISynchronizable)this.annotationModel).getLockObject() : this.annotationModel;
        IAnnotationModel iAnnotationModel = lockObject;
        synchronized (iAnnotationModel) {
            ArrayList<Annotation> toRemove = null;
            Iterator annotationIterator = this.annotationModel.getAnnotationIterator();
            while (annotationIterator.hasNext()) {
                Position position;
                int offset;
                Annotation annotation = (Annotation)annotationIterator.next();
                if (!ValidationProblemAnnotation.isValidationAnnotation(annotation) || !this.overlaps(region, offset = (position = this.annotationModel.getPosition(annotation)).getOffset(), position.getLength()) && offset < document.getLength()) continue;
                if (toRemove == null) {
                    toRemove = new ArrayList<Annotation>();
                }
                toRemove.add(annotation);
            }
            HashMap<ValidationProblemAnnotation, Position> annotationsToAdd = new HashMap<ValidationProblemAnnotation, Position>();
            for (ValidationProblem validationProblem : problems) {
                annotationsToAdd.put(new ValidationProblemAnnotation(validationProblem), new Position(validationProblem.getOffset(), validationProblem.getLength()));
            }
            if (toRemove != null && this.annotationModel instanceof IAnnotationModelExtension) {
                Annotation[] annotationArray = toRemove.toArray(new Annotation[toRemove.size()]);
                ((IAnnotationModelExtension)this.annotationModel).replaceAnnotations(annotationArray, annotationsToAdd);
            } else {
                if (toRemove != null) {
                    for (Annotation annotation : toRemove) {
                        this.annotationModel.removeAnnotation(annotation);
                    }
                }
                for (Map.Entry entry : annotationsToAdd.entrySet()) {
                    this.annotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
                }
            }
        }
    }

    @Override
    public void validate(IProgressMonitor monitor, IDocument document, IRegion region) throws CoreException {
        if (this.annotationModel == null) {
            return;
        }
        super.validate(monitor, document, region);
    }
}

