/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.viewer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.AnnotationHyperlinkDetector;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.TextHover;
import org.eclipse.mylyn.wikitext.ui.viewer.AbstractTextSourceViewerConfiguration;
import org.eclipse.mylyn.wikitext.ui.viewer.HtmlViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.HyperlinkDetectorDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlViewerConfiguration
extends AbstractTextSourceViewerConfiguration {
    private final HtmlViewer viewer;
    private TextPresentation textPresentation;
    private boolean disableHyperlinkModifiers = true;

    public HtmlViewerConfiguration(HtmlViewer viewer) {
        super(HtmlViewerConfiguration.getDefaultPreferenceStore());
        this.viewer = viewer;
        this.addHyperlinkDetectorDescriptorFilter(new AbstractTextSourceViewerConfiguration.HyperlinkDetectorDescriptorFilter(){

            public boolean filter(HyperlinkDetectorDescriptor descriptor) {
                String id = descriptor.getId();
                return "org.eclipse.ui.internal.editors.text.URLHyperlinkDetector".equals(id);
            }
        });
    }

    private static IPreferenceStore getDefaultPreferenceStore() {
        return WikiTextUiPlugin.getDefault() == null ? null : EditorsUI.getPreferenceStore();
    }

    public HtmlViewerConfiguration(HtmlViewer viewer, IPreferenceStore preferenceStore) {
        super(preferenceStore);
        this.viewer = viewer;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        MarkupViewerDamagerRepairer dr = this.createMarkupViewerDamagerRepairer();
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    private MarkupViewerDamagerRepairer createMarkupViewerDamagerRepairer() {
        return new MarkupViewerDamagerRepairer();
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover(){

            protected boolean isIncluded(Annotation annotation) {
                return annotation.getType().equals("org.eclipse.mylyn.wikitext.ui.annotation.title") || HtmlViewerConfiguration.this.isShowInVerticalRuler(annotation);
            }
        };
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new TextHover(sourceViewer);
    }

    @Override
    protected List<IHyperlinkDetector> createCustomHyperlinkDetectors(ISourceViewer sourceViewer) {
        ArrayList<IHyperlinkDetector> detectors = new ArrayList<IHyperlinkDetector>(1);
        AnnotationHyperlinkDetector annotationHyperlinkDetector = this.createAnnotationHyperlinkDetector();
        sourceViewer.getTextWidget().setData(AnnotationHyperlinkDetector.class.getName(), (Object)annotationHyperlinkDetector);
        detectors.add(annotationHyperlinkDetector);
        return detectors;
    }

    protected AnnotationHyperlinkDetector createAnnotationHyperlinkDetector() {
        return new AnnotationHyperlinkDetector();
    }

    public void setTextPresentation(TextPresentation textPresentation) {
        if (textPresentation != null) {
            TextPresentation textPresentationCopy = new TextPresentation();
            textPresentationCopy.setDefaultStyleRange((StyleRange)(textPresentation.getDefaultStyleRange() == null ? null : textPresentation.getDefaultStyleRange().clone()));
            Iterator iterator = textPresentation.getAllStyleRangeIterator();
            while (iterator.hasNext()) {
                StyleRange styleRange = (StyleRange)iterator.next();
                textPresentationCopy.addStyleRange((StyleRange)styleRange.clone());
            }
            textPresentation = textPresentationCopy;
        }
        this.textPresentation = textPresentation;
    }

    public int getHyperlinkStateMask(ISourceViewer sourceViewer) {
        if (this.disableHyperlinkModifiers) {
            return 0;
        }
        return super.getHyperlinkStateMask(sourceViewer);
    }

    public boolean isDisableHyperlinkModifiers() {
        return this.disableHyperlinkModifiers;
    }

    public void setDisableHyperlinkModifiers(boolean disableHyperlinkModifiers) {
        this.disableHyperlinkModifiers = disableHyperlinkModifiers;
    }

    protected class MarkupViewerDamagerRepairer
    implements IPresentationDamager,
    IPresentationRepairer {
        private IDocument document;

        protected MarkupViewerDamagerRepairer() {
        }

        public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent event, boolean documentPartitioningChanged) {
            return new Region(0, this.document.getLength());
        }

        public void setDocument(IDocument document) {
            this.document = document;
        }

        public void createPresentation(TextPresentation presentation, ITypedRegion damage) {
            TextPresentation viewerPresentation = HtmlViewerConfiguration.this.textPresentation == null ? HtmlViewerConfiguration.this.viewer.getTextPresentation() : HtmlViewerConfiguration.this.textPresentation;
            presentation.clear();
            if (viewerPresentation == null) {
                return;
            }
            StyleRange defaultStyleRange = viewerPresentation.getDefaultStyleRange();
            presentation.setDefaultStyleRange((StyleRange)(defaultStyleRange == null ? null : defaultStyleRange.clone()));
            ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
            Iterator allStyleRangeIterator = viewerPresentation.getAllStyleRangeIterator();
            while (allStyleRangeIterator.hasNext()) {
                StyleRange range = (StyleRange)allStyleRangeIterator.next();
                ranges.add((StyleRange)range.clone());
            }
            int start = damage.getOffset();
            int x = 0;
            while (x < ranges.size()) {
                StyleRange range = (StyleRange)ranges.get(x);
                if (range.start > start) {
                    StyleRange newRange = defaultStyleRange == null ? new StyleRange() : (StyleRange)defaultStyleRange.clone();
                    newRange.start = start;
                    newRange.length = range.start - start;
                    ranges.add(++x, newRange);
                }
                start = range.start + range.length + 1;
                ++x;
            }
            if (start < damage.getOffset() + damage.getLength()) {
                StyleRange newRange = defaultStyleRange == null ? new StyleRange() : (StyleRange)defaultStyleRange.clone();
                newRange.start = start;
                newRange.length = damage.getOffset() + damage.getLength() - start;
                ranges.add(newRange);
            }
            presentation.replaceStyleRanges(ranges.toArray(new StyleRange[ranges.size()]));
        }
    }
}

