/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.viewer;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.ui.viewer.HtmlViewer;
import org.eclipse.mylyn.wikitext.ui.viewer.Messages;
import org.eclipse.swt.widgets.Composite;

public class MarkupViewer
extends HtmlViewer {
    private MarkupParser parser = new MarkupParser();

    public MarkupViewer(Composite parent, IVerticalRuler ruler, int styles) {
        super(parent, ruler, styles);
        this.setEditable(false);
    }

    public MarkupViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        this.setEditable(false);
    }

    public void setMarkup(String source) {
        try {
            String htmlText = this.parser.parseToHtml(source);
            this.setHtml(htmlText);
        }
        catch (Throwable t) {
            if (this.getTextPresentation() != null) {
                this.getTextPresentation().clear();
            }
            this.setDocumentNoMarkup((IDocument)new Document(source), (IAnnotationModel)new AnnotationModel());
            if (WikiTextUiPlugin.getDefault() != null) {
                WikiTextUiPlugin.getDefault().log(4, Messages.getString("MarkupViewer.0"), t);
            }
            t.printStackTrace();
        }
    }

    public MarkupParser getParser() {
        return this.parser;
    }

    public void setParser(MarkupParser parser) {
        this.parser = parser;
    }

    public MarkupLanguage getMarkupLanguage() {
        return this.parser.getMarkupLanguage();
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        this.parser.setMarkupLanguage(markupLanguage);
    }

    public void setDocument(IDocument document, IAnnotationModel annotationModel, int modelRangeOffset, int modelRangeLength) {
        block3: {
            String markupContent = null;
            if (document != null && (markupContent = document.get()).length() > 0) {
                String htmlText = this.parser.parseToHtml(markupContent);
                document.set(htmlText);
            }
            try {
                super.setDocument(document, annotationModel, modelRangeOffset, modelRangeLength);
            }
            catch (Exception exception) {
                if (document == null) break block3;
                document.set(markupContent);
                this.setDocumentNoMarkup(document, annotationModel);
            }
        }
    }
}

