/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.ui;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.commons.ui.ColorSelectionWindow;
import org.eclipse.mylyn.internal.commons.ui.Messages;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonColors;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.IImageCreator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.progress.UIJob;

public class ScreenshotCreationPage
extends WizardPage
implements IImageCreator {
    private IAction captureAction;
    private IAction fitAction;
    private IAction cropAction;
    private IAction markAction;
    private IAction colorAction;
    private Image colorIcon;
    private Color markColor;
    private IAction clearAction;
    private boolean imageDirty;
    private Image originalImage;
    private Image workImage;
    private GC workImageGC;
    private Canvas canvas;
    private ScrolledComposite scrolledComposite;
    private Rectangle currentSelection;
    private Rectangle originalSelection;
    private Point startPoint;
    private Set<SelectionSide> resizableSides = EnumSet.noneOf(SelectionSide.class);
    private double scaleFactor = 1.0;
    private final Map<Integer, Cursor> cursors = new HashMap<Integer, Cursor>();
    private EditorAction currentAction = EditorAction.CROPPING;
    private static final int CURSOR_MARK_TOOL = -1;
    private static final long CAPTURE_DELAY = 400L;
    private static final int SQUARE_SIZE = 3;
    private final List<GrabPoint> grabPoints = new ArrayList<GrabPoint>(8);

    public ScreenshotCreationPage() {
        super("ScreenShotAttachment");
        this.setTitle(Messages.ScreenshotCreationPage_CAPTURE_SCRRENSHOT);
        this.setDescription(String.valueOf(Messages.ScreenshotCreationPage_After_capturing) + Messages.ScreenshotCreationPage_NOTE_THAT_YOU_CONTINUTE);
    }

    public void createControl(Composite parent) {
        ViewForm vf = new ViewForm(parent, 0x800800);
        vf.horizontalSpacing = 0;
        vf.verticalSpacing = 0;
        this.setControl((Control)vf);
        vf.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.allocateCursors();
        ToolBarManager tbm = new ToolBarManager(8519936);
        this.captureAction = new Action(Messages.ScreenshotCreationPage_Capture_Desktop_C, 1){
            private boolean isFirstCapture;
            {
                this.isFirstCapture = true;
            }

            public void run() {
                ScreenshotCreationPage.this.captureScreenshotContent();
                ScreenshotCreationPage.this.setErrorMessage(null);
                if (this.isFirstCapture) {
                    this.isFirstCapture = false;
                    ScreenshotCreationPage.this.fitAction.setEnabled(true);
                    ScreenshotCreationPage.this.cropAction.setEnabled(true);
                    ScreenshotCreationPage.this.cropAction.setChecked(true);
                    ScreenshotCreationPage.this.markAction.setEnabled(true);
                    ScreenshotCreationPage.this.clearAction.setEnabled(false);
                }
            }
        };
        this.captureAction.setToolTipText(Messages.ScreenshotCreationPage_Capture_Desktop);
        this.captureAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)CommonImages.getImage(CommonImages.IMAGE_CAPTURE)));
        this.fitAction = new Action("", 2){

            public void run() {
                ScreenshotCreationPage.this.refreshCanvasSize();
            }
        };
        this.fitAction.setToolTipText(Messages.ScreenshotCreationPage_Fit_Image);
        this.fitAction.setText(Messages.ScreenshotCreationPage_Fit_Image_F);
        this.fitAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)CommonImages.getImage(CommonImages.IMAGE_FIT)));
        this.fitAction.setChecked(true);
        this.fitAction.setEnabled(false);
        this.cropAction = new Action(Messages.ScreenshotCreationPage_Crop_R, 8){

            public void run() {
                ScreenshotCreationPage.this.currentAction = EditorAction.CROPPING;
                ScreenshotCreationPage.this.cropAction.setChecked(true);
                ScreenshotCreationPage.this.markAction.setChecked(false);
                ScreenshotCreationPage.this.colorAction.setEnabled(false);
                ScreenshotCreationPage.this.canvas.redraw();
            }
        };
        this.cropAction.setToolTipText(Messages.ScreenshotCreationPage_Crop);
        this.cropAction.setImageDescriptor(CommonImages.CUT);
        this.cropAction.setEnabled(false);
        this.markAction = new Action(Messages.ScreenshotCreationPage_Annotate, 8){

            public void run() {
                ScreenshotCreationPage.this.currentAction = EditorAction.MARKING;
                ScreenshotCreationPage.this.cropAction.setChecked(false);
                ScreenshotCreationPage.this.markAction.setChecked(true);
                ScreenshotCreationPage.this.colorAction.setEnabled(true);
                ScreenshotCreationPage.this.canvas.redraw();
            }
        };
        this.markAction.setToolTipText(Messages.ScreenshotCreationPage_DRAW_ANNOTATION_ON_SCREENSHOT_IMAGE);
        this.markAction.setImageDescriptor(CommonImages.EDIT);
        this.markAction.setEnabled(false);
        this.colorAction = new Action("", 4){

            public void runWithEvent(final Event e) {
                ColorSelectionWindow colorWindow = new ColorSelectionWindow(ScreenshotCreationPage.this.getControl().getShell()){

                    protected Point getInitialLocation(Point initialSize) {
                        ToolItem toolItem = (ToolItem)e.widget;
                        Rectangle itemBounds = toolItem.getBounds();
                        Point location = toolItem.getParent().toDisplay(itemBounds.x + itemBounds.width, itemBounds.y + itemBounds.height);
                        location.x -= initialSize.x;
                        return location;
                    }
                };
                colorWindow.setBlockOnOpen(true);
                colorWindow.open();
                RGB color = colorWindow.getSelectedRGB();
                if (color != null) {
                    ScreenshotCreationPage.this.setMarkColor(color);
                }
            }
        };
        this.colorAction.setToolTipText(Messages.ScreenshotCreationPage_Change_pen_color);
        this.colorIcon = new Image((Device)this.getShell().getDisplay(), 16, 16);
        this.setMarkColor(new RGB(255, 85, 85));
        this.colorAction.setEnabled(false);
        this.clearAction = new Action(Messages.ScreenshotCreationPage_Clear_Annotations, 1){

            public void run() {
                ScreenshotCreationPage.this.clearAction.setEnabled(false);
                ScreenshotCreationPage.this.workImageGC.drawImage(ScreenshotCreationPage.this.originalImage, 0, 0);
                ScreenshotCreationPage.this.canvas.redraw();
                ScreenshotCreationPage.this.setImageDirty(true);
            }
        };
        this.clearAction.setToolTipText(Messages.ScreenshotCreationPage_Clear_all_annotations_made_on_screenshot_image);
        this.clearAction.setImageDescriptor(CommonImages.CLEAR);
        this.clearAction.setEnabled(false);
        tbm.add((IContributionItem)this.createAndConfigureCI(this.captureAction));
        tbm.add((IContributionItem)this.createAndConfigureCI(this.fitAction));
        tbm.add((IContributionItem)new Separator());
        tbm.add((IContributionItem)this.createAndConfigureCI(this.cropAction));
        tbm.add((IContributionItem)this.createAndConfigureCI(this.markAction));
        tbm.add((IContributionItem)this.createAndConfigureCI(this.colorAction));
        tbm.add((IContributionItem)new Separator());
        tbm.add((IContributionItem)this.createAndConfigureCI(this.clearAction));
        this.scrolledComposite = new ScrolledComposite((Composite)vf, 768);
        this.canvas = new Canvas((Composite)this.scrolledComposite, 0x20000000);
        this.scrolledComposite.setContent((Control)this.canvas);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ScreenshotCreationPage.this.workImage != null) {
                    Rectangle imageBounds = ScreenshotCreationPage.this.workImage.getBounds();
                    Rectangle canvasBounds = ScreenshotCreationPage.this.canvas.getClientArea();
                    if (ScreenshotCreationPage.this.fitAction.isChecked()) {
                        e.gc.drawImage(ScreenshotCreationPage.this.workImage, 0, 0, imageBounds.width, imageBounds.height, 0, 0, canvasBounds.width, canvasBounds.height);
                    } else {
                        e.gc.drawImage(ScreenshotCreationPage.this.workImage, 0, 0);
                    }
                    ScreenshotCreationPage.this.drawSelection(e.gc);
                } else {
                    ScreenshotCreationPage.this.fitAction.setEnabled(false);
                }
            }
        });
        this.scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (ScreenshotCreationPage.this.fitAction.isChecked()) {
                    ScreenshotCreationPage.this.refreshCanvasSize();
                }
            }
        });
        this.scrolledComposite.setEnabled(false);
        vf.setTopLeft((Control)tbm.createControl((Composite)vf));
        vf.setContent((Control)this.scrolledComposite);
        this.registerMouseListeners();
        Dialog.applyDialogFont((Control)vf);
    }

    private ActionContributionItem createAndConfigureCI(IAction action) {
        ActionContributionItem ci = new ActionContributionItem(action);
        ci.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        return ci;
    }

    private void setMarkColor(RGB color) {
        if (this.markColor != null) {
            this.markColor.dispose();
        }
        this.markColor = new Color((Device)this.getShell().getDisplay(), color);
        if (this.workImageGC != null) {
            this.workImageGC.setForeground(this.markColor);
        }
        GC colorGC = new GC((Drawable)this.colorIcon);
        colorGC.setBackground(this.markColor);
        colorGC.fillRectangle(0, 0, 16, 16);
        colorGC.drawRectangle(0, 0, 15, 15);
        colorGC.dispose();
        this.colorAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.colorIcon));
    }

    public void dispose() {
        this.disposeImageResources();
        if (this.markColor != null) {
            this.markColor.dispose();
        }
        if (this.colorIcon != null) {
            this.colorIcon.dispose();
        }
        this.canvas.setCursor(null);
        for (Cursor cursor : this.cursors.values()) {
            cursor.dispose();
        }
        super.dispose();
    }

    private void disposeImageResources() {
        if (this.originalImage != null) {
            this.originalImage.dispose();
        }
        if (this.workImageGC != null) {
            this.workImageGC.dispose();
        }
        if (this.workImage != null) {
            this.workImage.dispose();
        }
    }

    private void allocateCursors() {
        Display display = this.getShell().getDisplay();
        this.cursors.put(0, new Cursor((Device)display, 0));
        this.cursors.put(5, new Cursor((Device)display, 5));
        this.cursors.put(8, new Cursor((Device)display, 8));
        this.cursors.put(6, new Cursor((Device)display, 6));
        this.cursors.put(7, new Cursor((Device)display, 7));
        this.cursors.put(9, new Cursor((Device)display, 9));
        this.cursors.put(2, new Cursor((Device)display, 2));
        this.cursors.put(-1, new Cursor((Device)display, 21));
    }

    private Rectangle getScaledSelection() {
        if (this.currentSelection == null) {
            return null;
        }
        int x = (int)Math.round((double)this.currentSelection.x * this.scaleFactor);
        int y = (int)Math.round((double)this.currentSelection.y * this.scaleFactor);
        int right = (int)Math.round((double)(this.currentSelection.x + this.currentSelection.width) * this.scaleFactor);
        int bottom = (int)Math.round((double)(this.currentSelection.y + this.currentSelection.height) * this.scaleFactor);
        int width = Math.min(right, (int)Math.round((double)(this.workImage.getBounds().width - 1) * this.scaleFactor)) - x;
        int height = Math.min(bottom, (int)Math.round((double)(this.workImage.getBounds().height - 1) * this.scaleFactor)) - y;
        return new Rectangle(x, y, width, height);
    }

    public boolean isPageComplete() {
        return this.workImage != null;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void captureScreenshotContent() {
        final Display display = this.getShell().getDisplay();
        final Shell wizardShell = this.getWizard().getContainer().getShell();
        wizardShell.setVisible(false);
        UIJob job = new UIJob("Capturing Screenshot"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ScreenshotCreationPage.this.disposeImageResources();
                Rectangle displayBounds = display.getBounds();
                ScreenshotCreationPage.this.originalImage = new Image((Device)display, displayBounds.width, displayBounds.height);
                ScreenshotCreationPage.this.workImage = new Image((Device)display, displayBounds.width, displayBounds.height);
                GC gc = new GC((Drawable)display);
                gc.copyArea(ScreenshotCreationPage.this.originalImage, displayBounds.x, displayBounds.y);
                gc.copyArea(ScreenshotCreationPage.this.workImage, displayBounds.x, displayBounds.y);
                gc.dispose();
                ScreenshotCreationPage.this.workImageGC = new GC((Drawable)ScreenshotCreationPage.this.workImage);
                ScreenshotCreationPage.this.workImageGC.setForeground(ScreenshotCreationPage.this.markColor);
                ScreenshotCreationPage.this.workImageGC.setLineWidth(4);
                ScreenshotCreationPage.this.workImageGC.setLineCap(2);
                ScreenshotCreationPage.this.scrolledComposite.setEnabled(true);
                ScreenshotCreationPage.this.clearSelection();
                ScreenshotCreationPage.this.refreshCanvasSize();
                wizardShell.setVisible(true);
                ScreenshotCreationPage.this.setPageComplete(true);
                return Status.OK_STATUS;
            }
        };
        job.schedule(400L);
    }

    private void refreshCurrentSelection(int x, int y) {
        int startX = Math.min(this.startPoint.x, x);
        int startY = Math.min(this.startPoint.y, y);
        int width = Math.abs(this.startPoint.x - x);
        int height = Math.abs(this.startPoint.y - y);
        this.currentSelection = new Rectangle(startX, startY, width, height);
        Rectangle imageBounds = this.workImage.getBounds();
        --imageBounds.width;
        --imageBounds.height;
        this.currentSelection.intersect(imageBounds);
    }

    private void setUpGrabPoints() {
        this.grabPoints.clear();
        if (this.currentSelection == null) {
            return;
        }
        Rectangle scaledSelection = this.getScaledSelection();
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x, scaledSelection.y, 8, EnumSet.of(SelectionSide.LEFT, SelectionSide.TOP)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x + scaledSelection.width / 2, scaledSelection.y, 7, EnumSet.of(SelectionSide.TOP)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x + scaledSelection.width, scaledSelection.y, 6, EnumSet.of(SelectionSide.TOP, SelectionSide.RIGHT)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x, scaledSelection.y + scaledSelection.height / 2, 9, EnumSet.of(SelectionSide.LEFT)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x + scaledSelection.width, scaledSelection.y + scaledSelection.height / 2, 9, EnumSet.of(SelectionSide.RIGHT)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x, scaledSelection.y + scaledSelection.height, 6, EnumSet.of(SelectionSide.LEFT, SelectionSide.BOTTOM)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x + scaledSelection.width / 2, scaledSelection.y + scaledSelection.height, 7, EnumSet.of(SelectionSide.BOTTOM)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x + scaledSelection.width, scaledSelection.y + scaledSelection.height, 8, EnumSet.of(SelectionSide.BOTTOM, SelectionSide.RIGHT)));
    }

    private void refreshSelectionResize(int x, int y) {
        this.currentSelection = new Rectangle(this.originalSelection.x, this.originalSelection.y, this.originalSelection.width, this.originalSelection.height);
        int deltaX = x - this.startPoint.x;
        int deltaY = y - this.startPoint.y;
        Rectangle imageBounds = this.workImage.getBounds();
        if (this.resizableSides.contains((Object)SelectionSide.LEFT) && this.originalSelection.x + (deltaX = Math.min(deltaX, this.originalSelection.width)) < 0) {
            deltaX = -this.originalSelection.x;
        }
        if (this.resizableSides.contains((Object)SelectionSide.RIGHT) && this.originalSelection.x + this.originalSelection.width + (deltaX = Math.max(deltaX, -this.originalSelection.width)) - 1 > imageBounds.width) {
            deltaX = imageBounds.width - (this.originalSelection.x + this.originalSelection.width);
        }
        if (this.resizableSides.contains((Object)SelectionSide.TOP) && this.originalSelection.y + (deltaY = Math.min(deltaY, this.originalSelection.height)) < 0) {
            deltaY = -this.originalSelection.y;
        }
        if (this.resizableSides.contains((Object)SelectionSide.BOTTOM) && this.originalSelection.y + this.originalSelection.height + (deltaY = Math.max(deltaY, -this.originalSelection.height)) - 1 > imageBounds.height) {
            deltaY = imageBounds.height - (this.originalSelection.y + this.originalSelection.height);
        }
        if (this.resizableSides.contains((Object)SelectionSide.LEFT)) {
            this.currentSelection.x += deltaX;
            this.currentSelection.width -= deltaX;
        }
        if (this.resizableSides.contains((Object)SelectionSide.RIGHT)) {
            this.currentSelection.width += deltaX;
        }
        if (this.resizableSides.contains((Object)SelectionSide.TOP)) {
            this.currentSelection.y += deltaY;
            this.currentSelection.height -= deltaY;
        }
        if (this.resizableSides.contains((Object)SelectionSide.BOTTOM)) {
            this.currentSelection.height += deltaY;
        }
        this.setUpGrabPoints();
    }

    private void refreshSelectionPosition(int x, int y) {
        int newX = this.originalSelection.x + (x - this.startPoint.x);
        int newY = this.originalSelection.y + (y - this.startPoint.y);
        if (newX < 0) {
            newX = 0;
        }
        if (newY < 0) {
            newY = 0;
        }
        Rectangle imageBounds = this.workImage.getBounds();
        if (newX + this.originalSelection.width - 1 > imageBounds.width) {
            newX = imageBounds.width - this.originalSelection.width;
        }
        if (newY + this.originalSelection.height - 1 > imageBounds.height) {
            newY = imageBounds.height - this.originalSelection.height;
        }
        this.currentSelection = new Rectangle(newX, newY, this.originalSelection.width, this.originalSelection.height);
        this.setUpGrabPoints();
    }

    private void registerMouseListeners() {
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                int scaledX = (int)Math.round((double)e.x / ScreenshotCreationPage.this.scaleFactor);
                int scaledY = (int)Math.round((double)e.y / ScreenshotCreationPage.this.scaleFactor);
                if (ScreenshotCreationPage.this.currentAction == EditorAction.SELECTING) {
                    ScreenshotCreationPage.this.refreshCurrentSelection(scaledX, scaledY);
                    ScreenshotCreationPage.this.canvas.redraw();
                } else if (ScreenshotCreationPage.this.currentAction == EditorAction.RESIZING_SELECTION) {
                    ScreenshotCreationPage.this.refreshSelectionResize(scaledX, scaledY);
                    ScreenshotCreationPage.this.canvas.redraw();
                } else if (ScreenshotCreationPage.this.currentAction == EditorAction.MOVING_SELECTION) {
                    ScreenshotCreationPage.this.refreshSelectionPosition(scaledX, scaledY);
                    ScreenshotCreationPage.this.canvas.redraw();
                } else if (ScreenshotCreationPage.this.currentAction == EditorAction.CROPPING && ScreenshotCreationPage.this.currentSelection != null) {
                    boolean cursorSet = false;
                    for (GrabPoint point : ScreenshotCreationPage.this.grabPoints) {
                        if (!point.grabArea.contains(e.x, e.y)) continue;
                        ScreenshotCreationPage.this.canvas.setCursor((Cursor)ScreenshotCreationPage.this.cursors.get(point.cursorType));
                        cursorSet = true;
                        break;
                    }
                    if (!cursorSet && ScreenshotCreationPage.this.getScaledSelection().contains(e.x, e.y)) {
                        ScreenshotCreationPage.this.canvas.setCursor((Cursor)ScreenshotCreationPage.this.cursors.get(5));
                        cursorSet = true;
                    }
                    Cursor crossCursor = (Cursor)ScreenshotCreationPage.this.cursors.get(2);
                    if (!cursorSet && ScreenshotCreationPage.this.canvas.getCursor() != crossCursor) {
                        ScreenshotCreationPage.this.canvas.setCursor(crossCursor);
                    }
                } else if (ScreenshotCreationPage.this.currentAction == EditorAction.MARKING) {
                    ScreenshotCreationPage.this.drawMarkLine(scaledX, scaledY);
                    Cursor markCursor = (Cursor)ScreenshotCreationPage.this.cursors.get(-1);
                    if (ScreenshotCreationPage.this.canvas.getCursor() != markCursor) {
                        ScreenshotCreationPage.this.canvas.setCursor(markCursor);
                    }
                }
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (ScreenshotCreationPage.this.currentAction == EditorAction.SELECTING || ScreenshotCreationPage.this.currentAction == EditorAction.RESIZING_SELECTION || ScreenshotCreationPage.this.currentAction == EditorAction.MOVING_SELECTION) {
                    int scaledX = (int)Math.round((double)e.x / ScreenshotCreationPage.this.scaleFactor);
                    int scaledY = (int)Math.round((double)e.y / ScreenshotCreationPage.this.scaleFactor);
                    if (ScreenshotCreationPage.this.currentAction == EditorAction.SELECTING) {
                        ScreenshotCreationPage.this.refreshCurrentSelection(scaledX, scaledY);
                    } else if (ScreenshotCreationPage.this.currentAction == EditorAction.RESIZING_SELECTION) {
                        ScreenshotCreationPage.this.refreshSelectionResize(scaledX, scaledY);
                    } else if (ScreenshotCreationPage.this.currentAction == EditorAction.MOVING_SELECTION) {
                        ScreenshotCreationPage.this.refreshSelectionPosition(scaledX, scaledY);
                    }
                    if (((ScreenshotCreationPage)ScreenshotCreationPage.this).currentSelection.width == 0 && ((ScreenshotCreationPage)ScreenshotCreationPage.this).currentSelection.height == 0) {
                        ScreenshotCreationPage.this.currentSelection = null;
                    }
                    ScreenshotCreationPage.this.setUpGrabPoints();
                    ScreenshotCreationPage.this.startPoint = null;
                    ScreenshotCreationPage.this.currentAction = EditorAction.CROPPING;
                    ScreenshotCreationPage.this.canvas.redraw();
                    ScreenshotCreationPage.this.setImageDirty(true);
                } else if (ScreenshotCreationPage.this.currentAction == EditorAction.MARKING) {
                    ScreenshotCreationPage.this.startPoint = null;
                    ScreenshotCreationPage.this.setImageDirty(true);
                }
            }

            public void mouseDown(MouseEvent e) {
                int scaledX = (int)((double)e.x / ScreenshotCreationPage.this.scaleFactor);
                int scaledY = (int)((double)e.y / ScreenshotCreationPage.this.scaleFactor);
                if (ScreenshotCreationPage.this.currentAction == EditorAction.MARKING) {
                    ScreenshotCreationPage.this.startPoint = new Point(scaledX, scaledY);
                    ScreenshotCreationPage.this.drawMarkLine(scaledX, scaledY);
                    ScreenshotCreationPage.this.canvas.setCursor((Cursor)ScreenshotCreationPage.this.cursors.get(-1));
                    return;
                }
                if (ScreenshotCreationPage.this.currentAction != EditorAction.CROPPING) {
                    return;
                }
                if (ScreenshotCreationPage.this.currentSelection != null) {
                    for (GrabPoint point : ScreenshotCreationPage.this.grabPoints) {
                        if (!point.grabArea.contains(e.x, e.y)) continue;
                        ScreenshotCreationPage.this.originalSelection = ScreenshotCreationPage.this.currentSelection;
                        ScreenshotCreationPage.this.currentAction = EditorAction.RESIZING_SELECTION;
                        ScreenshotCreationPage.this.resizableSides = point.resizableSides;
                        ScreenshotCreationPage.this.startPoint = new Point(scaledX, scaledY);
                        ScreenshotCreationPage.this.canvas.redraw();
                        return;
                    }
                }
                if (ScreenshotCreationPage.this.currentSelection != null && ScreenshotCreationPage.this.currentSelection.contains(scaledX, scaledY)) {
                    ScreenshotCreationPage.this.originalSelection = ScreenshotCreationPage.this.currentSelection;
                    ScreenshotCreationPage.this.currentAction = EditorAction.MOVING_SELECTION;
                    ScreenshotCreationPage.this.startPoint = new Point(scaledX, scaledY);
                    ScreenshotCreationPage.this.canvas.redraw();
                    return;
                }
                ScreenshotCreationPage.this.canvas.setCursor((Cursor)ScreenshotCreationPage.this.cursors.get(2));
                ScreenshotCreationPage.this.currentAction = EditorAction.SELECTING;
                ScreenshotCreationPage.this.currentSelection = null;
                ScreenshotCreationPage.this.startPoint = new Point(scaledX, scaledY);
                ScreenshotCreationPage.this.setUpGrabPoints();
                ScreenshotCreationPage.this.canvas.redraw();
            }
        });
    }

    private void clearSelection() {
        this.currentSelection = null;
        this.startPoint = null;
        this.setImageDirty(true);
    }

    private void refreshCanvasSize() {
        if (this.fitAction.isChecked()) {
            this.scrolledComposite.getHorizontalBar().setVisible(false);
            this.scrolledComposite.getVerticalBar().setVisible(false);
            Rectangle bounds = this.scrolledComposite.getClientArea();
            if (this.workImage != null) {
                Rectangle imageBounds = this.workImage.getBounds();
                if (imageBounds.width > bounds.width || imageBounds.height > bounds.height) {
                    double xRatio = (double)bounds.width / (double)imageBounds.width;
                    double yRatio = (double)bounds.height / (double)imageBounds.height;
                    this.scaleFactor = Math.min(xRatio, yRatio);
                    bounds.width = (int)Math.round((double)imageBounds.width * this.scaleFactor);
                    bounds.height = (int)Math.round((double)imageBounds.height * this.scaleFactor);
                }
            }
            this.canvas.setBounds(bounds);
        } else {
            this.scaleFactor = 1.0;
            Rectangle bounds = this.scrolledComposite.getClientArea();
            if (this.workImage != null) {
                Rectangle imageBounds = this.workImage.getBounds();
                bounds.width = imageBounds.width;
                bounds.height = imageBounds.height;
            }
            this.canvas.setBounds(bounds);
        }
        this.setUpGrabPoints();
        this.canvas.redraw();
    }

    private void drawSelection(GC gc) {
        if (this.currentSelection == null) {
            return;
        }
        Rectangle scaledSelection = this.getScaledSelection();
        gc.setBackground(CommonColors.GRAY_MID);
        gc.setAdvanced(true);
        gc.setAlpha(120);
        Region invertedSelection = new Region();
        invertedSelection.add(this.canvas.getClientArea());
        invertedSelection.subtract(scaledSelection);
        gc.setClipping(invertedSelection);
        gc.fillRectangle(this.canvas.getClientArea());
        gc.setClipping(null);
        invertedSelection.dispose();
        gc.setAdvanced(false);
        gc.setLineStyle(1);
        gc.setForeground(this.getShell().getDisplay().getSystemColor(16));
        gc.drawRectangle(scaledSelection);
        gc.setBackground(this.getShell().getDisplay().getSystemColor(1));
        gc.setForeground(this.getShell().getDisplay().getSystemColor(2));
        for (GrabPoint point : this.grabPoints) {
            gc.fillRectangle(point.grabArea);
            gc.drawRectangle(point.grabArea);
        }
    }

    private void drawMarkLine(int x, int y) {
        if (this.startPoint != null) {
            this.clearAction.setEnabled(true);
            this.workImageGC.drawLine(this.startPoint.x, this.startPoint.y, x, y);
            this.startPoint.x = x;
            this.startPoint.y = y;
            this.canvas.redraw();
        }
    }

    public Image createImage() {
        Image screenshot = new Image((Device)this.getShell().getDisplay(), this.currentSelection != null ? this.currentSelection : this.workImage.getBounds());
        GC gc = new GC((Drawable)screenshot);
        if (this.currentSelection != null) {
            gc.drawImage(this.workImage, this.currentSelection.x, this.currentSelection.y, this.currentSelection.width, this.currentSelection.height, 0, 0, this.currentSelection.width, this.currentSelection.height);
        } else {
            gc.drawImage(this.workImage, 0, 0);
        }
        gc.dispose();
        this.imageDirty = false;
        return screenshot;
    }

    public void setImageDirty(boolean pageDirty) {
        this.imageDirty = pageDirty;
    }

    public boolean isImageDirty() {
        return this.imageDirty;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EditorAction {
        CROPPING,
        SELECTING,
        RESIZING_SELECTION,
        MOVING_SELECTION,
        MARKING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GrabPoint {
        public Rectangle grabArea;
        public int cursorType;
        public Set<SelectionSide> resizableSides;

        private GrabPoint() {
        }

        public static GrabPoint createGrabPoint(int x, int y, int cursorType, Set<SelectionSide> resizableSides) {
            GrabPoint point = new GrabPoint();
            point.grabArea = new Rectangle(x - 3, y - 3, 7, 7);
            point.cursorType = cursorType;
            point.resizableSides = resizableSides;
            return point;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SelectionSide {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

