/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.ui.BrowseFilteredListener;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.UiUtil;
import org.eclipse.mylyn.internal.provisional.commons.ui.DelayedRefreshJob;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FocusedViewerManager
extends AbstractContextListener
implements ISelectionListener {
    private final CopyOnWriteArrayList<StructuredViewer> managedViewers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<StructuredViewer> filteredViewers = new CopyOnWriteArrayList();
    private final Map<StructuredViewer, BrowseFilteredListener> listenerMap = new HashMap<StructuredViewer, BrowseFilteredListener>();
    private final Map<IWorkbenchPart, StructuredViewer> partToViewerMap = new HashMap<IWorkbenchPart, StructuredViewer>();
    private final Map<StructuredViewer, FocusedViewerDelayedRefreshJob> fullRefreshJobs = new HashMap<StructuredViewer, FocusedViewerDelayedRefreshJob>();
    private final Map<StructuredViewer, FocusedViewerDelayedRefreshJob> minorRefreshJobs = new HashMap<StructuredViewer, FocusedViewerDelayedRefreshJob>();
    private boolean syncRefreshMode = false;

    public void dispose() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void addManagedViewer(StructuredViewer viewer, IWorkbenchPart viewPart) {
        if (viewer != null && !this.managedViewers.contains(viewer)) {
            this.managedViewers.add(viewer);
            this.partToViewerMap.put(viewPart, viewer);
            BrowseFilteredListener listener = new BrowseFilteredListener(viewer);
            this.listenerMap.put(viewer, listener);
            viewer.getControl().addMouseListener((MouseListener)listener);
            viewer.getControl().addKeyListener((KeyListener)listener);
            try {
                UiUtil.initializeViewerSelection(viewPart);
                Set<IInteractionElement> emptySet = Collections.emptySet();
                this.refreshViewer(emptySet, true, viewer);
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not initialize focused viewer", (Throwable)e));
            }
        }
    }

    public void removeManagedViewer(StructuredViewer viewer, IWorkbenchPart viewPart) {
        this.managedViewers.remove(viewer);
        this.partToViewerMap.remove(viewPart);
        BrowseFilteredListener listener = this.listenerMap.get(viewer);
        if (listener != null && viewer != null && !viewer.getControl().isDisposed()) {
            viewer.getControl().removeMouseListener((MouseListener)listener);
            viewer.getControl().removeKeyListener((KeyListener)listener);
        }
    }

    public void addFilteredViewer(StructuredViewer viewer) {
        if (viewer != null && !this.filteredViewers.contains(viewer)) {
            this.filteredViewers.add(viewer);
        }
    }

    public void removeFilteredViewer(StructuredViewer viewer) {
        this.filteredViewers.remove(viewer);
    }

    public void contextActivated(IInteractionContext context) {
        this.refreshViewers();
    }

    public void contextDeactivated(IInteractionContext context) {
        this.refreshViewers();
        for (StructuredViewer structuredViewer : this.managedViewers) {
            if (!(structuredViewer instanceof TreeViewer)) continue;
            ((TreeViewer)structuredViewer).collapseAll();
        }
    }

    public void contextCleared(IInteractionContext context) {
        if (context != null) {
            this.contextDeactivated(context);
        }
    }

    protected void refreshViewers() {
        List<IInteractionElement> toRefresh = Collections.emptyList();
        this.refreshViewers(toRefresh, true);
    }

    protected void refreshViewers(IInteractionElement node, boolean updateLabels) {
        ArrayList<IInteractionElement> toRefresh = new ArrayList<IInteractionElement>();
        toRefresh.add(node);
        this.refreshViewers(toRefresh, updateLabels);
    }

    public void interestChanged(List<IInteractionElement> nodes) {
        this.refreshViewers(nodes, false);
    }

    protected void refreshViewers(final List<IInteractionElement> nodesToRefresh, final boolean updateLabels) {
        if (nodesToRefresh == null) {
            return;
        }
        if (this.syncRefreshMode) {
            this.internalRefresh(new HashSet<IInteractionElement>(nodesToRefresh), updateLabels);
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    FocusedViewerManager.this.internalRefresh(new HashSet(nodesToRefresh), updateLabels);
                }
            });
        }
    }

    private void internalRefresh(Set<IInteractionElement> nodesToRefresh, boolean updateLabels) {
        try {
            for (StructuredViewer viewer : this.managedViewers) {
                this.refreshViewer(nodesToRefresh, updateLabels, viewer);
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not refresh viewer", t));
        }
    }

    public void refreshViewer(Set<IInteractionElement> nodesToRefresh, boolean updateLabels, StructuredViewer viewer) {
        Map<StructuredViewer, FocusedViewerDelayedRefreshJob> refreshJobs = null;
        refreshJobs = updateLabels ? this.minorRefreshJobs : this.fullRefreshJobs;
        FocusedViewerDelayedRefreshJob job = refreshJobs.get(viewer);
        if (job == null) {
            job = new FocusedViewerDelayedRefreshJob(viewer, "refresh viewer", updateLabels);
            refreshJobs.put(viewer, job);
        }
        job.refreshElements(nodesToRefresh.toArray());
    }

    private void updateExpansionState(StructuredViewer viewer, Object objectToRefresh) {
        if (viewer instanceof TreeViewer && this.filteredViewers.contains(viewer) && ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.ide.ui.expansion.auto.manage")) {
            TreeViewer treeViewer = (TreeViewer)viewer;
            if (objectToRefresh == null) {
                treeViewer.expandAll();
            } else {
                treeViewer.expandToLevel(objectToRefresh, -1);
            }
        }
    }

    public void elementsDeleted(List<IInteractionElement> elements) {
        for (IInteractionElement interactionElement : elements) {
            AbstractContextStructureBridge structureBridge = ContextCore.getStructureBridge((String)interactionElement.getContentType());
            IInteractionElement parent = ContextCore.getContextManager().getElement(structureBridge.getParentHandle(interactionElement.getHandleIdentifier()));
            if (parent == null) continue;
            ArrayList<IInteractionElement> toRefresh = new ArrayList<IInteractionElement>();
            toRefresh.add(parent);
            this.refreshViewers(toRefresh, false);
        }
    }

    public void landmarkAdded(IInteractionElement node) {
        this.refreshViewers(node, true);
    }

    public void landmarkRemoved(IInteractionElement node) {
        this.refreshViewers(node, true);
    }

    public void setSyncRefreshMode(boolean syncRefreshMode) {
        this.syncRefreshMode = syncRefreshMode;
    }

    public void contextPreActivated(IInteractionContext context) {
    }

    public void forceRefresh() {
        this.refreshViewers();
    }

    private class FocusedViewerDelayedRefreshJob
    extends DelayedRefreshJob {
        private boolean minor;

        public FocusedViewerDelayedRefreshJob(StructuredViewer viewer, String name, boolean minor) {
            super(viewer, name);
            this.minor = false;
            this.minor = minor;
        }

        protected void doRefresh(Object[] items) {
            if (this.viewer == null) {
                return;
            }
            if (this.viewer.getControl().isDisposed()) {
                FocusedViewerManager.this.managedViewers.remove(this.viewer);
            } else if (items == null || items.length == 0) {
                if (!this.minor) {
                    this.viewer.refresh(false);
                    FocusedViewerManager.this.updateExpansionState(this.viewer, null);
                } else {
                    try {
                        this.viewer.getControl().setRedraw(false);
                        this.viewer.refresh(true);
                        FocusedViewerManager.this.updateExpansionState(this.viewer, null);
                    }
                    finally {
                        this.viewer.getControl().setRedraw(true);
                    }
                }
            } else {
                if (FocusedViewerManager.this.filteredViewers.contains(this.viewer)) {
                    try {
                        this.viewer.getControl().setRedraw(false);
                        this.viewer.refresh(this.minor);
                        FocusedViewerManager.this.updateExpansionState(this.viewer, null);
                    }
                    finally {
                        this.viewer.getControl().setRedraw(true);
                    }
                }
                try {
                    this.viewer.getControl().setRedraw(false);
                    Object[] objectArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object item;
                        Object objectToRefresh = item = objectArray[n2];
                        if (item instanceof IInteractionElement) {
                            IInteractionElement node = (IInteractionElement)item;
                            AbstractContextStructureBridge structureBridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
                            objectToRefresh = structureBridge.getObjectForHandle(node.getHandleIdentifier());
                        }
                        if (objectToRefresh != null) {
                            this.viewer.update(objectToRefresh, null);
                            FocusedViewerManager.this.updateExpansionState(this.viewer, objectToRefresh);
                        }
                        ++n2;
                    }
                }
                finally {
                    this.viewer.getControl().setRedraw(true);
                }
            }
        }
    }
}

