/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.editors;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.commons.ui.SwtUtil;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.ui.actions.ContextAttachAction;
import org.eclipse.mylyn.internal.context.ui.actions.ContextClearAction;
import org.eclipse.mylyn.internal.context.ui.actions.ContextCopyAction;
import org.eclipse.mylyn.internal.context.ui.actions.ContextRetrieveAction;
import org.eclipse.mylyn.internal.context.ui.editors.Messages;
import org.eclipse.mylyn.internal.context.ui.editors.ScalableInterestFilter;
import org.eclipse.mylyn.internal.context.ui.views.ContextNodeOpenListener;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.DelayedRefreshJob;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskActivateAction;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextEditorFormPage
extends FormPage {
    private static final int SCALE_STEPS = 14;
    public static final String ID_VIEWER = "org.eclipse.mylyn.context.ui.navigator.context";
    private ScrolledForm form;
    private Composite sectionClient;
    private FormToolkit toolkit;
    private CommonViewer commonViewer;
    private Hyperlink activateTaskHyperlink;
    private final ScalableInterestFilter interestFilter = new ScalableInterestFilter();
    private Scale doiScale;
    private ITask task;
    private final AbstractContextListener CONTEXT_LISTENER = new AbstractContextListener(){

        public void contextActivated(IInteractionContext context) {
            Control partControl = ContextEditorFormPage.this.getPartControl();
            if (partControl != null && !partControl.isDisposed()) {
                ContextEditorFormPage.this.updateContentArea();
                ContextEditorFormPage.this.refresh();
            }
        }

        public void contextDeactivated(IInteractionContext context) {
            Control partControl = ContextEditorFormPage.this.getPartControl();
            if (partControl != null && !partControl.isDisposed()) {
                ContextEditorFormPage.this.updateContentArea();
                ContextEditorFormPage.this.refresh();
            }
        }

        public void contextCleared(IInteractionContext context) {
            ContextEditorFormPage.this.refresh();
        }

        public void elementsDeleted(List<IInteractionElement> element) {
            ContextEditorFormPage.this.refresh(element);
        }

        public void interestChanged(List<IInteractionElement> elements) {
            ContextEditorFormPage.this.refresh(elements);
        }

        public void landmarkAdded(IInteractionElement element) {
            ContextEditorFormPage.this.refresh(Arrays.asList(element));
        }

        public void landmarkRemoved(IInteractionElement element) {
            ContextEditorFormPage.this.refresh(Arrays.asList(element));
        }
    };
    private ContextEditorDelayedRefreshJob refreshJob;

    public ContextEditorFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ContextCore.getContextManager().addListener(this.CONTEXT_LISTENER);
        this.task = ((TaskEditorInput)this.getEditorInput()).getTask();
        this.form = managedForm.getForm();
        this.toolkit = managedForm.getToolkit();
        this.form.getBody().setLayout((Layout)new GridLayout(2, false));
        this.createActionsSection(this.form.getBody());
        this.createContentSection(this.form.getBody());
        this.form.reflow(true);
    }

    public void dispose() {
        super.dispose();
        ContextCore.getContextManager().removeListener(this.CONTEXT_LISTENER);
    }

    private void createActionsSection(Composite composite) {
        Section section = this.toolkit.createSection(composite, 320);
        section.setText(Messages.ContextEditorFormPage_Actions);
        section.setLayout((Layout)new GridLayout());
        GridData sectionGridData = new GridData(2);
        sectionGridData.widthHint = 80;
        section.setLayoutData((Object)sectionGridData);
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)sectionClient);
        sectionClient.setLayout((Layout)new GridLayout(2, false));
        sectionClient.setLayoutData((Object)new GridData());
        ImageHyperlink filterImage = this.toolkit.createImageHyperlink(sectionClient, 0);
        filterImage.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.FILTER));
        filterImage.setToolTipText(Messages.ContextEditorFormPage_Show_All_Elements);
        filterImage.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                ContextEditorFormPage.this.doiScale.setSelection(0);
                ContextEditorFormPage.this.interestFilter.setThreshold(-2.147483648E9);
                ContextEditorFormPage.this.refresh();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        this.doiScale = new Scale(sectionClient, 0x800000);
        GridData scaleGridData = new GridData(768);
        scaleGridData.heightHint = 36;
        scaleGridData.widthHint = 80;
        this.doiScale.setLayoutData((Object)scaleGridData);
        this.doiScale.setPageIncrement(1);
        this.doiScale.setMinimum(0);
        this.doiScale.setSelection(7);
        this.doiScale.setMaximum(14);
        this.doiScale.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContextEditorFormPage.this.updateFilterThreshold();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (!this.isActiveTask()) {
            this.doiScale.setEnabled(false);
        }
        Label attachImage = this.toolkit.createLabel(sectionClient, "");
        attachImage.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_ATTACH));
        attachImage.setEnabled(this.task != null);
        Hyperlink attachHyperlink = this.toolkit.createHyperlink(sectionClient, Messages.ContextEditorFormPage_Attach_context_, 0);
        attachHyperlink.setEnabled(this.task != null);
        attachHyperlink.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                new ContextAttachAction().run(ContextEditorFormPage.this.task);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        Label retrieveImage = this.toolkit.createLabel(sectionClient, "");
        retrieveImage.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_RETRIEVE));
        retrieveImage.setEnabled(this.task != null);
        Hyperlink retrieveHyperlink = this.toolkit.createHyperlink(sectionClient, Messages.ContextEditorFormPage_Retrieve_Context_, 0);
        retrieveHyperlink.setEnabled(this.task != null);
        retrieveHyperlink.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                new ContextRetrieveAction().run(ContextEditorFormPage.this.task);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        Label copyImage = this.toolkit.createLabel(sectionClient, "");
        copyImage.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_COPY));
        Hyperlink copyHyperlink = this.toolkit.createHyperlink(sectionClient, Messages.ContextEditorFormPage_Copy_Context_to_, 0);
        copyHyperlink.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                new ContextCopyAction().run(ContextEditorFormPage.this.task);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        Label clearImage = this.toolkit.createLabel(sectionClient, "");
        clearImage.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_CLEAR));
        Hyperlink clearHyperlink = this.toolkit.createHyperlink(sectionClient, Messages.ContextEditorFormPage_RemoveAll, 0);
        clearHyperlink.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                new ContextClearAction().run(ContextEditorFormPage.this.task);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        Label removeInvisble = this.toolkit.createLabel(sectionClient, "");
        removeInvisble.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_CLEAR));
        Hyperlink removeInvisibleLink = this.toolkit.createHyperlink(sectionClient, Messages.ContextEditorFormPage_Remove_Invisible_, 0);
        removeInvisibleLink.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (ContextEditorFormPage.this.commonViewer == null) {
                    MessageDialog.openWarning((Shell)TasksUiInternal.getShell(), (String)Messages.ContextEditorFormPage_Remove_Invisible, (String)Messages.ContextEditorFormPage_Activate_task_to_remove_invisible0);
                    return;
                }
                boolean confirmed = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ContextEditorFormPage_Remove_Invisible, (String)Messages.ContextEditorFormPage_Remove_every_element_not_visible);
                if (confirmed) {
                    HashSet allVisible = new HashSet();
                    SwtUtil.collectItemData((TreeItem[])ContextEditorFormPage.this.commonViewer.getTree().getItems(), allVisible);
                    if (ContextCore.getContextManager().isContextActive()) {
                        IInteractionContext context = ContextCore.getContextManager().getActiveContext();
                        List allToRemove = context.getAllElements();
                        ArrayList<IInteractionElement> allVisibleElements = new ArrayList<IInteractionElement>();
                        for (Object visibleObject : allVisible) {
                            String handle;
                            AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(visibleObject);
                            if (bridge == null || (handle = bridge.getHandleIdentifier(visibleObject)) == null) continue;
                            IInteractionElement element = context.get(handle);
                            allVisibleElements.add(element);
                        }
                        allToRemove.removeAll(allVisibleElements);
                        for (IInteractionElement interactionElement : allToRemove) {
                            ContextCore.getContextManager().deleteElement(interactionElement);
                        }
                    } else {
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ContextEditorFormPage_Remove_Invisible, (String)Messages.ContextEditorFormPage_No_context_active);
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        section.setExpanded(true);
    }

    protected void updateFilterThreshold() {
        if (this.doiScale.getSelection() == 0) {
            this.interestFilter.setThreshold(-2.147483648E9);
        } else if (this.doiScale.getSelection() == 14) {
            this.interestFilter.setThreshold(2.147483647E9);
        } else {
            double setting = this.doiScale.getSelection() - 7;
            double threshold = Math.signum(setting) * Math.pow(Math.exp(Math.abs(setting)), 1.5);
            this.interestFilter.setThreshold(threshold);
        }
        this.refresh();
    }

    private void refresh() {
        this.createRefreshJob();
        if (this.refreshJob != null) {
            this.refreshJob.refresh();
        }
    }

    private synchronized void createRefreshJob() {
        if (this.commonViewer == null) {
            return;
        }
        if (this.refreshJob == null) {
            this.refreshJob = new ContextEditorDelayedRefreshJob((StructuredViewer)this.commonViewer, "refresh viewer");
        }
    }

    private void refresh(List<IInteractionElement> elements) {
        this.createRefreshJob();
        if (this.refreshJob != null) {
            this.refreshJob.doRefresh(elements.toArray());
        }
    }

    private void createContentSection(Composite composite) {
        Section section = this.toolkit.createSection(composite, 320);
        section.setText(Messages.ContextEditorFormPage_Elements);
        section.setLayoutData((Object)new GridData(1808));
        this.sectionClient = this.toolkit.createComposite((Composite)section);
        this.sectionClient.setLayout((Layout)new FillLayout());
        section.setClient((Control)this.sectionClient);
        this.updateContentArea();
    }

    private void createActivateTaskHyperlink(Composite parent) {
        this.activateTaskHyperlink = this.toolkit.createHyperlink(parent, Messages.ContextEditorFormPage_Activate_task_to_edit_context, 0);
        this.activateTaskHyperlink.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                new TaskActivateAction().run(ContextEditorFormPage.this.task);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
    }

    private void updateContentArea() {
        if (this.isActiveTask()) {
            this.doiScale.setEnabled(true);
            this.doiScale.setSelection(7);
            if (this.activateTaskHyperlink != null) {
                this.activateTaskHyperlink.dispose();
                this.activateTaskHyperlink = null;
            }
            if (this.commonViewer == null) {
                this.createViewer(this.sectionClient);
            }
            this.updateFilterThreshold();
        } else {
            this.doiScale.setEnabled(false);
            this.doiScale.setSelection(7);
            if (this.commonViewer != null) {
                this.commonViewer.getControl().dispose();
                this.commonViewer = null;
                this.disposeRefreshJob();
            }
            if (this.activateTaskHyperlink == null) {
                this.createActivateTaskHyperlink(this.sectionClient);
            }
        }
        this.sectionClient.layout();
    }

    private synchronized void disposeRefreshJob() {
        if (this.refreshJob != null) {
            this.refreshJob.cancel();
            this.refreshJob = null;
        }
    }

    private boolean isActiveTask() {
        return this.task.equals(TasksUi.getTaskActivityManager().getActiveTask());
    }

    private void createViewer(Composite parent) {
        this.commonViewer = new CommonViewer(ID_VIEWER, parent, 770);
        this.commonViewer.setUseHashlookup(true);
        this.commonViewer.addFilter((ViewerFilter)this.interestFilter);
        this.commonViewer.addOpenListener((IOpenListener)new ContextNodeOpenListener((Viewer)this.commonViewer));
        try {
            this.commonViewer.getControl().setRedraw(false);
            ContextEditorFormPage.forceFlatLayoutOfJavaContent(this.commonViewer);
            this.commonViewer.setInput((Object)this.getSite().getPage().getInput());
            this.getSite().setSelectionProvider((ISelectionProvider)this.commonViewer);
            this.hookContextMenu();
            this.commonViewer.expandAll();
        }
        finally {
            this.commonViewer.getControl().setRedraw(true);
        }
    }

    public static void forceFlatLayoutOfJavaContent(CommonViewer commonViewer) {
        INavigatorContentExtension javaContent = commonViewer.getNavigatorContentService().getContentExtensionById("org.eclipse.jdt.java.ui.javaContent");
        if (javaContent != null) {
            ITreeContentProvider treeContentProvider = javaContent.getContentProvider();
            try {
                Class<?> clazz = treeContentProvider.getClass().getSuperclass();
                Method method = clazz.getDeclaredMethod("setIsFlatLayout", Boolean.TYPE);
                method.invoke((Object)treeContentProvider, true);
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not set flat layout on Java content provider", (Throwable)e));
            }
        }
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ContextEditorFormPage.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.commonViewer.getControl());
        this.commonViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.commonViewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    public ISelection getSelection() {
        if (this.getSite() != null && this.getSite().getSelectionProvider() != null) {
            return this.getSite().getSelectionProvider().getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    private class ContextEditorDelayedRefreshJob
    extends DelayedRefreshJob {
        public ContextEditorDelayedRefreshJob(StructuredViewer treeViewer, String name) {
            super(treeViewer, name);
        }

        protected void doRefresh(Object[] items) {
            if (ContextEditorFormPage.this.commonViewer != null && !ContextEditorFormPage.this.commonViewer.getTree().isDisposed()) {
                ContextEditorFormPage.this.commonViewer.refresh();
                if (items != null) {
                    Object[] objectArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object item = objectArray[n2];
                        this.updateExpansionState(item);
                        ++n2;
                    }
                } else {
                    this.updateExpansionState(null);
                }
            }
        }

        protected void updateExpansionState(Object item) {
            if (ContextEditorFormPage.this.commonViewer != null && !ContextEditorFormPage.this.commonViewer.getTree().isDisposed()) {
                try {
                    ContextEditorFormPage.this.commonViewer.getTree().setRedraw(false);
                    if (item == null) {
                        ContextEditorFormPage.this.commonViewer.expandAll();
                    } else if (item != null && item instanceof IInteractionElement) {
                        IInteractionElement node = (IInteractionElement)item;
                        AbstractContextStructureBridge structureBridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
                        Object objectToRefresh = structureBridge.getObjectForHandle(node.getHandleIdentifier());
                        if (objectToRefresh != null) {
                            ContextEditorFormPage.this.commonViewer.expandToLevel(objectToRefresh, -1);
                        }
                    }
                }
                finally {
                    ContextEditorFormPage.this.commonViewer.getTree().setRedraw(true);
                }
            }
        }
    }
}

