/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs.wizards;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.bugs.PluginRepositoryMappingManager;
import org.eclipse.mylyn.internal.tasks.bugs.TasksBugsPlugin;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.FeatureStatus;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.Messages;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.SelectFeaturePage;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.SelectProductPage;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;

public class ReportBugOrEnhancementWizard
extends Wizard {
    private SelectProductPage selectProductPage;
    private PluginRepositoryMappingManager manager;

    public ReportBugOrEnhancementWizard() {
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(false);
        this.setWindowTitle(Messages.ReportBugOrEnhancementWizard_Report_Bug_or_Enhancement);
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
    }

    public void addPages() {
        this.manager = new PluginRepositoryMappingManager();
        this.selectProductPage = new SelectProductPage("selectBundleGroupProvider", this.manager);
        this.addPage((IWizardPage)this.selectProductPage);
    }

    public boolean canFinish() {
        return this.getSelectedBundleGroup() != null;
    }

    public IBundleGroup[] getSelectedBundleGroup() {
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page instanceof SelectProductPage) {
            if (page.isPageComplete() && !((SelectProductPage)page).canFlipToNextPage()) {
                return ((SelectProductPage)page).getSelectedBundleGroups();
            }
        } else if (page instanceof SelectFeaturePage && page.isPageComplete()) {
            return ((SelectFeaturePage)page).getSelectedBundleGroups();
        }
        return null;
    }

    public boolean performFinish() {
        final IBundleGroup[] bundles = this.getSelectedBundleGroup();
        Assert.isNotNull((Object)bundles);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                String prefix = bundles[0].getIdentifier();
                int i = 1;
                while (i < bundles.length) {
                    prefix = ReportBugOrEnhancementWizard.getCommonPrefix(prefix, bundles[i].getIdentifier());
                    ++i;
                }
                TasksBugsPlugin.getTaskErrorReporter().handle((IStatus)new FeatureStatus(prefix, bundles));
            }
        });
        return true;
    }

    private static String getCommonPrefix(String s1, String s2) {
        int len = Math.min(s1.length(), s2.length());
        StringBuffer prefix = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            if (s1.charAt(i) == s2.charAt(i)) {
                prefix.append(s1.charAt(i));
            }
            ++i;
        }
        return prefix.toString();
    }
}

