/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SelectFeaturePage
extends WizardPage {
    private static final int TABLE_HEIGHT = 200;
    private IBundleGroup selectedBundleGroup;
    private final IBundleGroup[] bundleGroups;
    private ImageRegistry imageRegistry;

    public SelectFeaturePage(String pageName, IBundleGroup[] bundleGroups) {
        super(pageName);
        this.bundleGroups = bundleGroups;
        this.setTitle(Messages.SelectFeaturePage_SELECT_FEATURE);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        container.setLayout((Layout)layout);
        this.imageRegistry = new ImageRegistry(this.getShell().getDisplay());
        IBundleGroup[] iBundleGroupArray = this.bundleGroups;
        int n = this.bundleGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IBundleGroup bundleGroup = iBundleGroupArray[n2];
            String imageUrl = bundleGroup.getProperty("featureImage");
            if (imageUrl != null) {
                try {
                    ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(imageUrl));
                    this.imageRegistry.put(bundleGroup.getIdentifier(), imageDescriptor);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            ++n2;
        }
        TableViewer viewer = new TableViewer(container, 2820);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(-1, 200).applyTo(viewer.getControl());
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return SelectFeaturePage.this.bundleGroups;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof IBundleGroup) {
                    IBundleGroup bundleGroup = (IBundleGroup)element;
                    return SelectFeaturePage.this.imageRegistry.get(bundleGroup.getIdentifier());
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IBundleGroup) {
                    IBundleGroup bundleGroup = (IBundleGroup)element;
                    return bundleGroup.getName();
                }
                return "";
            }
        });
        viewer.setInput((Object)TasksUiPlugin.getRepositoryManager().getRepositoryConnectors());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof IBundleGroup) {
                    SelectFeaturePage.this.selectedBundleGroup = (IBundleGroup)selection.getFirstElement();
                    SelectFeaturePage.this.setMessage(SelectFeaturePage.this.selectedBundleGroup.getDescription());
                    SelectFeaturePage.this.setPageComplete(true);
                } else {
                    SelectFeaturePage.this.setMessage(null);
                    SelectFeaturePage.this.setPageComplete(false);
                }
            }
        });
        viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (SelectFeaturePage.this.getWizard().performFinish()) {
                    ((WizardDialog)SelectFeaturePage.this.getContainer()).close();
                }
            }
        });
        viewer.getTable().showSelection();
        viewer.getTable().setFocus();
        viewer.setSorter(new ViewerSorter());
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    public void dispose() {
        if (this.imageRegistry != null) {
            this.imageRegistry.dispose();
        }
        super.dispose();
    }

    public IBundleGroup[] getSelectedBundleGroups() {
        return new IBundleGroup[]{this.selectedBundleGroup};
    }
}

