/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.ImportExportUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ExportAction
implements IViewActionDelegate {
    private ISelection selection;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        if (this.selection.isEmpty() || !(this.selection instanceof StructuredSelection)) {
            MessageDialog.openError((Shell)TasksUiInternal.getShell(), (String)Messages.ExportAction_Dialog_Title, (String)Messages.ExportAction_Nothing_selected);
            return;
        }
        FileDialog dialog = new FileDialog(TasksUiInternal.getShell(), 40960);
        dialog.setText(Messages.ExportAction_Dialog_Title);
        ImportExportUtil.configureFilter(dialog);
        dialog.setFileName("mylyn-tasks.xml.zip");
        String path = dialog.open();
        if (path != null) {
            File file = new File(path);
            if (file.exists() && !MessageDialog.openConfirm((Shell)TasksUiInternal.getShell(), (String)Messages.ExportAction_Dialog_Title, (String)NLS.bind((String)Messages.ExportAction_X_exists_Do_you_wish_to_overwrite, (Object)file.getPath()))) {
                return;
            }
            try {
                ImportExportUtil.export(file, (IStructuredSelection)this.selection);
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Problems encountered during export", (Throwable)e));
                TasksUiInternal.displayStatus(Messages.ExportAction_Dialog_Title, (IStatus)new MultiStatus("org.eclipse.mylyn.tasks.core", 0, new IStatus[]{e.getStatus()}, Messages.ExportAction_Problems_encountered, (Throwable)e));
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

