/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.views.AbstractTaskListPresentation;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class PresentationDropDownSelectionAction
extends Action
implements IMenuCreator {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.presentationselection";
    private final TaskListView view;
    private Menu dropDownMenu;

    public PresentationDropDownSelectionAction(TaskListView view) {
        this.view = view;
        this.setMenuCreator(this);
        this.setText(Messages.PresentationDropDownSelectionAction_Task_Presentation);
        this.setToolTipText(Messages.PresentationDropDownSelectionAction_Task_Presentation);
        this.setId(ID);
        this.setEnabled(true);
        this.setImageDescriptor(CommonImages.PRESENTATION);
    }

    private void addActionsToMenu() {
        for (AbstractTaskListPresentation presentation : TaskListView.getPresentations()) {
            if (!presentation.isPrimary()) continue;
            PresentationSelectionAction action = new PresentationSelectionAction(presentation);
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            action.setText(presentation.getName());
            action.setImageDescriptor(presentation.getImageDescriptor());
            action.setChecked(this.view.getCurrentPresentation().getId().equals(presentation.getId()));
            item.fill(this.dropDownMenu, -1);
        }
        boolean separatorAdded = false;
        for (AbstractTaskListPresentation presentation : TaskListView.getPresentations()) {
            if (presentation.isPrimary()) continue;
            if (!separatorAdded) {
                new Separator().fill(this.dropDownMenu, -1);
                separatorAdded = true;
            }
            PresentationSelectionAction action = new PresentationSelectionAction(presentation);
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            action.setText(presentation.getName());
            action.setImageDescriptor(presentation.getImageDescriptor());
            action.setChecked(this.view.getCurrentPresentation().getId().equals(presentation.getId()));
            item.fill(this.dropDownMenu, -1);
        }
    }

    public void run() {
        AbstractTaskListPresentation current = this.view.getCurrentPresentation();
        List<AbstractTaskListPresentation> all = TaskListView.getPresentations();
        int size = all.size();
        if (size == 0) {
            return;
        }
        int index = all.indexOf(current) + 1;
        int i = 0;
        while (i < size) {
            AbstractTaskListPresentation presentation = all.get(index % size);
            if (presentation.isPrimary()) {
                this.view.applyPresentation(presentation);
                return;
            }
            ++index;
            ++i;
        }
        index = all.indexOf(current) + 1;
        if (index < size) {
            this.view.applyPresentation(all.get(index));
        } else {
            this.view.applyPresentation(all.get(0));
        }
    }

    public void dispose() {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
            this.dropDownMenu = null;
        }
    }

    public Menu getMenu(Control parent) {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
        }
        this.dropDownMenu = new Menu(parent);
        this.addActionsToMenu();
        return this.dropDownMenu;
    }

    public Menu getMenu(Menu parent) {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
        }
        this.dropDownMenu = new Menu(parent);
        this.addActionsToMenu();
        return this.dropDownMenu;
    }

    private class PresentationSelectionAction
    extends Action {
        private final AbstractTaskListPresentation presentation;

        public PresentationSelectionAction(AbstractTaskListPresentation presentation) {
            this.presentation = presentation;
            this.setText(presentation.getName());
        }

        public void run() {
            PresentationDropDownSelectionAction.this.view.applyPresentation(this.presentation);
        }
    }
}

