/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.actions.ToggleAllWorkingSetsAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.ToggleWorkingSetAction;
import org.eclipse.mylyn.internal.tasks.ui.dialogs.AbstractWorkingSetDialogCOPY;
import org.eclipse.mylyn.internal.tasks.ui.workingsets.TaskWorkingSetUpdater;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkingSetComparator;
import org.eclipse.ui.internal.dialogs.WorkingSetFilter;
import org.eclipse.ui.internal.dialogs.WorkingSetLabelProvider;

public class TaskWorkingSetAction
extends Action
implements IMenuCreator {
    public static final String LABEL_SETS_NONE = Messages.TaskWorkingSetAction_All;
    private Menu dropDownMenu;

    public TaskWorkingSetAction() {
        this.setText(Messages.TaskWorkingSetAction_Sets);
        this.setToolTipText(Messages.TaskWorkingSetAction_Select_and_Edit_Working_Sets);
        this.setImageDescriptor(TasksUiImages.TASK_WORKING_SET);
        this.setEnabled(true);
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
            this.dropDownMenu = null;
        }
    }

    public Menu getMenu(Control parent) {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
        }
        this.dropDownMenu = new Menu(parent);
        this.addActionsToMenu();
        return this.dropDownMenu;
    }

    public Menu getMenu(Menu parent) {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
        }
        this.dropDownMenu = new Menu(parent);
        this.addActionsToMenu();
        return this.dropDownMenu;
    }

    private void addActionsToMenu() {
        IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
        if (this.doTaskWorkingSetsExist()) {
            ActionContributionItem itemAll = new ActionContributionItem((IAction)new ToggleAllWorkingSetsAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow()));
            List<IWorkingSet> sortedWorkingSets = Arrays.asList(workingSets);
            Collections.sort(sortedWorkingSets, new WorkingSetComparator());
            for (IWorkingSet workingSet : sortedWorkingSets) {
                if (workingSet == null || !workingSet.getId().equalsIgnoreCase(TaskWorkingSetUpdater.ID_TASK_WORKING_SET)) continue;
                ActionContributionItem itemSet = new ActionContributionItem((IAction)new ToggleWorkingSetAction(workingSet));
                itemSet.fill(this.dropDownMenu, -1);
            }
            Separator separator = new Separator();
            separator.fill(this.dropDownMenu, -1);
            itemAll.fill(this.dropDownMenu, -1);
        }
        ActionContributionItem editItem = new ActionContributionItem((IAction)new ManageWorkingSetsAction());
        editItem.fill(this.dropDownMenu, -1);
    }

    private boolean doTaskWorkingSetsExist() {
        IWorkingSet[] workingSets;
        IWorkingSet[] iWorkingSetArray = workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
        int n = workingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            if (workingSet != null && workingSet.getId().equalsIgnoreCase(TaskWorkingSetUpdater.ID_TASK_WORKING_SET)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void run() {
        String[] ids = new String[]{TaskWorkingSetUpdater.ID_TASK_WORKING_SET};
        ConfigureWindowWorkingSetsDialog dialog = new ConfigureWindowWorkingSetsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), ids);
        dialog.open();
    }

    public void run(IAction action) {
        this.run();
    }

    public void run(IWorkingSet editWorkingSet) {
        IWorkingSetManager manager = WorkbenchPlugin.getDefault().getWorkingSetManager();
        IWorkingSetEditWizard wizard = manager.createWorkingSetEditWizard(editWorkingSet);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.open();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConfigureWindowWorkingSetsDialog
    extends AbstractWorkingSetDialogCOPY {
        private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
        private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
        private final IWorkbenchWindow window;
        private CheckboxTableViewer viewer;
        private Set<String> taskWorkingSetIds;

        protected ConfigureWindowWorkingSetsDialog(IWorkbenchWindow window, String[] workingSetIds) {
            super(window.getShell(), workingSetIds, true);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.window = window;
            this.setTitle(Messages.TaskWorkingSetAction_Select_and_Edit_Working_Sets);
            this.setMessage("");
            if (workingSetIds == null || workingSetIds.length == 0) {
                this.taskWorkingSetIds = null;
            } else {
                this.taskWorkingSetIds = new HashSet<String>();
                String[] stringArray = workingSetIds;
                int n = workingSetIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    this.taskWorkingSetIds.add(id);
                    ++n2;
                }
            }
        }

        protected Control createDialogArea(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite viewerComposite = new Composite(composite, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            viewerComposite.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            data.heightHint = 200;
            data.widthHint = 350;
            viewerComposite.setLayoutData((Object)data);
            this.viewer = CheckboxTableViewer.newCheckList((Composite)viewerComposite, (int)2048);
            this.viewer.getControl().setLayoutData((Object)new GridData(1808));
            this.viewer.setLabelProvider((IBaseLabelProvider)new WorkingSetLabelProvider());
            this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.viewer.addFilter((ViewerFilter)new WorkingSetFilter(this.taskWorkingSetIds));
            this.viewer.setInput((Object)this.window.getWorkbench().getWorkingSetManager().getWorkingSets());
            this.viewer.setCheckedElements((Object[])this.window.getActivePage().getWorkingSets());
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ConfigureWindowWorkingSetsDialog.this.handleSelectionChanged();
                }
            });
            data = new GridData(1808);
            data.heightHint = 200;
            data.widthHint = 50;
            this.viewer.getControl().setLayoutData((Object)data);
            this.addModifyButtons(viewerComposite);
            this.addSelectionButtons(composite);
            this.availableWorkingSetsChanged();
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }

        protected void okPressed() {
            HashSet<IWorkingSet> newList = new HashSet<IWorkingSet>(Arrays.asList(TaskWorkingSetUpdater.getEnabledSets()));
            HashSet<IWorkingSet> tempList = new HashSet<IWorkingSet>();
            for (IWorkingSet workingSet : newList) {
                for (String id : this.taskWorkingSetIds) {
                    if (!workingSet.getId().equalsIgnoreCase(id)) continue;
                    tempList.add(workingSet);
                }
            }
            newList.removeAll(tempList);
            Object[] selection = this.viewer.getCheckedElements();
            IWorkingSet[] setsToEnable = new IWorkingSet[selection.length];
            System.arraycopy(selection, 0, setsToEnable, 0, selection.length);
            newList.addAll(new HashSet<IWorkingSet>(Arrays.asList(setsToEnable)));
            this.window.getActivePage().setWorkingSets(newList.toArray(new IWorkingSet[newList.size()]));
            super.okPressed();
        }

        @Override
        protected List<?> getSelectedWorkingSets() {
            ISelection selection = this.viewer.getSelection();
            if (selection instanceof IStructuredSelection) {
                return ((IStructuredSelection)selection).toList();
            }
            return null;
        }

        @Override
        protected void availableWorkingSetsChanged() {
            this.viewer.setInput((Object)this.window.getWorkbench().getWorkingSetManager().getWorkingSets());
            super.availableWorkingSetsChanged();
        }

        void handleSelectionChanged() {
            this.updateButtonAvailability();
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
        }

        @Override
        protected void selectAllSets() {
            this.viewer.setCheckedElements((Object[])this.window.getWorkbench().getWorkingSetManager().getWorkingSets());
            this.updateButtonAvailability();
        }

        @Override
        protected void deselectAllSets() {
            this.viewer.setCheckedElements(new Object[0]);
            this.updateButtonAvailability();
        }
    }

    private class ManageWorkingSetsAction
    extends Action {
        ManageWorkingSetsAction() {
            super(Messages.TaskWorkingSetAction_Edit_Label);
        }

        public void run() {
            TaskWorkingSetAction.this.run((IAction)this);
        }
    }

    protected class ToggleEnableAllSetsAction
    extends Action {
        ToggleEnableAllSetsAction() {
            super(Messages.TaskWorkingSetAction_Deselect_All, 2);
        }

        public void runWithEvent(Event event) {
            HashSet<IWorkingSet> newList = new HashSet<IWorkingSet>(Arrays.asList(TaskWorkingSetUpdater.getEnabledSets()));
            HashSet<IWorkingSet> tempList = new HashSet<IWorkingSet>();
            for (IWorkingSet workingSet : newList) {
                if (workingSet == null || !workingSet.getId().equalsIgnoreCase(TaskWorkingSetUpdater.ID_TASK_WORKING_SET)) continue;
                tempList.add(workingSet);
            }
            newList.removeAll(tempList);
            if (this.isChecked()) {
                IWorkingSet[] allWorkingSets;
                IWorkingSet[] iWorkingSetArray = allWorkingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
                int n = allWorkingSets.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkingSet workingSet = iWorkingSetArray[n2];
                    if (workingSet != null && workingSet.getId().equalsIgnoreCase(TaskWorkingSetUpdater.ID_TASK_WORKING_SET)) {
                        newList.add(workingSet);
                    }
                    ++n2;
                }
            }
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().setWorkingSets(newList.toArray(new IWorkingSet[newList.size()]));
        }
    }
}

