/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.workingsets.TaskWorkingSetUpdater;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;

public class ToggleAllWorkingSetsAction
extends Action {
    private final IWorkbenchWindow window;

    public ToggleAllWorkingSetsAction(IWorkbenchWindow window) {
        super(Messages.ToggleAllWorkingSetsAction_Show_All, 2);
        super.setChecked(TaskWorkingSetUpdater.areNoTaskWorkingSetsEnabled());
        this.window = window;
    }

    public void run() {
        HashSet<IWorkingSet> newList = new HashSet<IWorkingSet>(Arrays.asList(TaskWorkingSetUpdater.getEnabledSets()));
        HashSet<IWorkingSet> tempList = new HashSet<IWorkingSet>();
        for (IWorkingSet workingSet : newList) {
            if (workingSet == null || workingSet.getId() == null || !workingSet.getId().equalsIgnoreCase(TaskWorkingSetUpdater.ID_TASK_WORKING_SET)) continue;
            tempList.add(workingSet);
        }
        newList.removeAll(tempList);
        this.window.getActivePage().setWorkingSets(newList.toArray(new IWorkingSet[newList.size()]));
    }

    public void runWithEvent(Event event) {
        this.run();
    }
}

