/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.mylyn.internal.tasks.ui.dialogs.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TaskCompareDialog
extends SelectionDialog {
    private Combo[] priorityCombos;
    private Button[] ascendingButtons;
    private Button[] descendingButtons;
    private final String[] propertyText;
    private boolean dirty = false;
    private final TaskComparator taskComparator;
    private final Comparator<String> columnComparator = new Comparator<String>(){

        @Override
        public int compare(String arg0, String arg1) {
            int index0 = -1;
            int index1 = -1;
            int i = 0;
            while (i < TaskCompareDialog.this.propertyText.length) {
                if (TaskCompareDialog.this.propertyText[i].equals(arg0)) {
                    index0 = i;
                }
                if (TaskCompareDialog.this.propertyText[i].equals(arg1)) {
                    index1 = i;
                }
                ++i;
            }
            return index0 - index1;
        }
    };

    public TaskCompareDialog(IShellProvider parentShell, TaskComparator taskComparator) {
        super(parentShell.getShell());
        TaskComparator.SortByIndex[] values = TaskComparator.SortByIndex.values();
        this.propertyText = new String[values.length];
        int i = 0;
        while (i < values.length) {
            this.propertyText[i] = values[i].getLabel();
            ++i;
        }
        this.taskComparator = taskComparator;
        this.setTitle(Messages.TaskCompareDialog_Sorting);
    }

    protected void createDialogStartArea(Composite parent) {
        Label sortByLabel = new Label(parent, 0);
        sortByLabel.setText(Messages.TaskCompareDialog_SortOrder);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        sortByLabel.setLayoutData((Object)data);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        Composite prioritiesArea = new Composite(composite, 0);
        prioritiesArea.setLayout((Layout)new GridLayout(3, false));
        this.createDialogStartArea(prioritiesArea);
        this.ascendingButtons = new Button[2];
        this.descendingButtons = new Button[2];
        this.priorityCombos = new Combo[2];
        int i = 0;
        while (i < 2) {
            final int index = i;
            Label numberLabel = new Label(prioritiesArea, 0);
            numberLabel.setText(i + 1 + ".");
            this.priorityCombos[i] = new Combo(prioritiesArea, 8);
            this.priorityCombos[i].setLayoutData((Object)new GridData(768));
            Composite directionGroup = new Composite(prioritiesArea, 0);
            directionGroup.setLayout((Layout)new GridLayout(2, false));
            this.ascendingButtons[i] = new Button(directionGroup, 16);
            this.ascendingButtons[i].setText(Messages.TaskCompareDialog_Ascending);
            this.ascendingButtons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TaskCompareDialog.this.markDirty();
                }
            });
            this.descendingButtons[i] = new Button(directionGroup, 16);
            this.descendingButtons[i].setText(Messages.TaskCompareDialog_Descending);
            this.descendingButtons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TaskCompareDialog.this.markDirty();
                }
            });
            if (i < this.priorityCombos.length - 1) {
                this.priorityCombos[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String newSelection;
                        int oldSelectionDirection = 1;
                        if (TaskCompareDialog.this.descendingButtons[index].getSelection()) {
                            oldSelectionDirection = -1;
                        }
                        ArrayList<String> oldSelectionList = new ArrayList<String>(Arrays.asList(TaskCompareDialog.this.priorityCombos[index].getItems()));
                        oldSelectionList.removeAll(Arrays.asList(TaskCompareDialog.this.priorityCombos[index + 1].getItems()));
                        if (oldSelectionList.size() != 1) {
                            return;
                        }
                        String oldSelection = oldSelectionList.get(0);
                        if (oldSelection.equals(newSelection = TaskCompareDialog.this.priorityCombos[index].getItem(TaskCompareDialog.this.priorityCombos[index].getSelectionIndex()))) {
                            return;
                        }
                        int j = index + 1;
                        while (j < TaskCompareDialog.this.priorityCombos.length) {
                            int newSelectionIndex = TaskCompareDialog.this.priorityCombos[j].indexOf(newSelection);
                            if (TaskCompareDialog.this.priorityCombos[j].getSelectionIndex() == newSelectionIndex) {
                                TaskCompareDialog.this.priorityCombos[j].remove(newSelection);
                                int insertionPoint = -1 - Arrays.binarySearch(TaskCompareDialog.this.priorityCombos[j].getItems(), oldSelection, TaskCompareDialog.this.columnComparator);
                                if (insertionPoint >= 0 && insertionPoint <= TaskCompareDialog.this.priorityCombos[j].getItemCount()) {
                                    TaskCompareDialog.this.priorityCombos[j].add(oldSelection, insertionPoint);
                                } else {
                                    TaskCompareDialog.this.priorityCombos[j].add(oldSelection);
                                }
                                TaskCompareDialog.this.priorityCombos[j].select(TaskCompareDialog.this.priorityCombos[j].indexOf(oldSelection));
                                TaskCompareDialog.this.ascendingButtons[index].setSelection(TaskCompareDialog.this.ascendingButtons[j].getSelection());
                                TaskCompareDialog.this.descendingButtons[index].setSelection(TaskCompareDialog.this.descendingButtons[j].getSelection());
                                TaskCompareDialog.this.ascendingButtons[j].setSelection(oldSelectionDirection == 1);
                                TaskCompareDialog.this.descendingButtons[j].setSelection(oldSelectionDirection == -1);
                            } else if (newSelectionIndex >= 0) {
                                String currentText = TaskCompareDialog.this.priorityCombos[j].getText();
                                TaskCompareDialog.this.priorityCombos[j].remove(newSelection);
                                int insertionPoint = -1 - Arrays.binarySearch(TaskCompareDialog.this.priorityCombos[j].getItems(), oldSelection, TaskCompareDialog.this.columnComparator);
                                if (insertionPoint >= 0 && insertionPoint <= TaskCompareDialog.this.priorityCombos[j].getItemCount()) {
                                    TaskCompareDialog.this.priorityCombos[j].add(oldSelection, insertionPoint);
                                    TaskCompareDialog.this.priorityCombos[j].select(TaskCompareDialog.this.priorityCombos[j].indexOf(currentText));
                                } else {
                                    TaskCompareDialog.this.priorityCombos[j].add(oldSelection);
                                }
                            }
                            ++j;
                        }
                        TaskCompareDialog.this.markDirty();
                    }
                });
            } else {
                this.priorityCombos[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TaskCompareDialog.this.markDirty();
                    }
                });
            }
            ++i;
        }
        int[] a = new int[2];
        int[] b = new int[2];
        a[0] = this.taskComparator.getSortByIndex().ordinal();
        a[1] = this.taskComparator.getSortByIndex2().ordinal();
        b[0] = this.taskComparator.getSortDirection();
        b[1] = this.taskComparator.getSortDirection2();
        this.updateUI(a, b);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        if (this.isDirty()) {
            this.taskComparator.setSortByIndex(TaskComparator.SortByIndex.valueOfLabel(this.priorityCombos[0].getText()));
            this.taskComparator.setSortByIndex2(TaskComparator.SortByIndex.valueOfLabel(this.priorityCombos[1].getText()));
            if (this.descendingButtons[0].getSelection()) {
                this.taskComparator.setSortDirection(-1);
            } else {
                this.taskComparator.setSortDirection(1);
            }
            if (this.descendingButtons[1].getSelection()) {
                this.taskComparator.setSortDirection2(-1);
            } else {
                this.taskComparator.setSortDirection2(1);
            }
        }
        super.okPressed();
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    protected void markDirty() {
        this.dirty = true;
    }

    protected void updateUI(int[] priorities, int[] directions) {
        ArrayList<String> availablePriorities = new ArrayList<String>(Arrays.asList(this.propertyText));
        int i = 0;
        while (i < this.priorityCombos.length) {
            this.priorityCombos[i].removeAll();
            int j = 0;
            while (j < availablePriorities.size()) {
                this.priorityCombos[i].add(availablePriorities.get(j));
                ++j;
            }
            this.priorityCombos[i].select(this.priorityCombos[i].indexOf(this.propertyText[priorities[i]]));
            availablePriorities.remove(this.propertyText[priorities[i]]);
            this.ascendingButtons[i].setSelection(directions[i] == 1);
            this.descendingButtons[i].setSelection(directions[i] == -1);
            ++i;
        }
    }
}

