/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.notifications;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.provisional.commons.ui.AbstractNotification;
import org.eclipse.mylyn.internal.provisional.commons.ui.AbstractNotificationPopup;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.TaskHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.notifications.Messages;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListNotificationReminder;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListNotificationPopup
extends AbstractNotificationPopup {
    private static final String NOTIFICATIONS_HIDDEN = Messages.TaskListNotificationPopup_more;
    private static final int NUM_NOTIFICATIONS_TO_DISPLAY = 4;
    private List<AbstractNotification> notifications;

    public TaskListNotificationPopup(Shell parent) {
        super(parent.getDisplay());
    }

    public void setContents(List<AbstractNotification> notifications) {
        this.notifications = notifications;
    }

    public List<AbstractNotification> getNotifications() {
        return new ArrayList<AbstractNotification>(this.notifications);
    }

    protected void createTitleArea(Composite parent) {
        super.createTitleArea(parent);
    }

    protected void createContentArea(Composite parent) {
        int count = 0;
        for (final AbstractNotification notification : this.notifications) {
            Composite notificationComposite = new Composite(parent, 524288);
            GridLayout gridLayout = new GridLayout(2, false);
            GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)notificationComposite);
            notificationComposite.setLayout((Layout)gridLayout);
            notificationComposite.setBackground(parent.getBackground());
            if (count < 4) {
                AbstractTask task;
                final Label notificationLabelIcon = new Label(notificationComposite, 524288);
                notificationLabelIcon.setBackground(parent.getBackground());
                notificationLabelIcon.setImage(notification.getNotificationKindImage());
                if (!(notification instanceof TaskListNotificationReminder) && (task = (AbstractTask)notification.getAdapter(AbstractTask.class)) != null) {
                    notificationLabelIcon.addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseUp(MouseEvent e) {
                            TasksUiPlugin.getTaskDataManager().setTaskRead((ITask)task, true);
                            notificationLabelIcon.setImage(null);
                            notificationLabelIcon.setToolTipText(null);
                        }
                    });
                    notificationLabelIcon.setToolTipText(Messages.TaskListNotificationPopup_Mark_Task_Read);
                }
                TaskHyperlink itemLink = new TaskHyperlink(notificationComposite, 524289);
                GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)itemLink);
                itemLink.setText(notification.getLabel());
                itemLink.setImage(notification.getNotificationImage());
                itemLink.setBackground(parent.getBackground());
                itemLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        Shell windowShell;
                        notification.open();
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window != null && (windowShell = window.getShell()) != null) {
                            if (windowShell.getMinimized()) {
                                windowShell.setMinimized(false);
                            }
                            windowShell.open();
                            windowShell.forceActive();
                        }
                    }
                });
                String descriptionText = null;
                if (notification.getDescription() != null) {
                    descriptionText = notification.getDescription();
                }
                if (descriptionText != null && !descriptionText.trim().equals("")) {
                    Label descriptionLabel = new Label(notificationComposite, 524288);
                    descriptionLabel.setText(descriptionText);
                    descriptionLabel.setBackground(parent.getBackground());
                    GridDataFactory.fillDefaults().span(2, -1).grab(true, false).align(4, 128).applyTo((Control)descriptionLabel);
                }
            } else {
                int numNotificationsRemain = this.notifications.size() - count;
                TaskHyperlink remainingHyperlink = new TaskHyperlink(notificationComposite, 524288);
                remainingHyperlink.setBackground(parent.getBackground());
                remainingHyperlink.setText(String.valueOf(numNotificationsRemain) + " " + NOTIFICATIONS_HIDDEN);
                GridDataFactory.fillDefaults().span(2, -1).applyTo((Control)remainingHyperlink);
                remainingHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        Shell windowShell;
                        TasksUiUtil.openTasksViewInActivePerspective().setFocus();
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window != null && (windowShell = window.getShell()) != null) {
                            windowShell.setMaximized(true);
                            windowShell.open();
                        }
                    }
                });
                break;
            }
            ++count;
        }
    }
}

