/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnsubmittedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoryLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.workingsets.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TaskElementLabelProvider;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskWorkingSetPage
extends WizardPage
implements IWorkingSetPage {
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 50;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 200;
    private Text text;
    private CheckboxTreeViewer treeViewer;
    private IWorkingSet workingSet;
    private final WorkingSetPageContentProvider workingSetPageContentProvider = new WorkingSetPageContentProvider();
    private boolean firstCheck = false;

    public TaskWorkingSetPage() {
        super("taskWorkingSetPage", Messages.TaskWorkingSetPage_Select_Working_Set_Elements, null);
        this.setDescription(Messages.TaskWorkingSetPage_Page_Description);
        this.setImageDescriptor(TasksUiImages.BANNER_WORKING_SET);
    }

    public void finish() {
        Object[] elements = this.treeViewer.getCheckedElements();
        HashSet<IAdaptable> validElements = new HashSet<IAdaptable>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof AbstractTaskContainer || element instanceof IProject) {
                validElements.add((IAdaptable)element);
            }
            ++n2;
        }
        this.addSpecialContainers(validElements);
        if (this.workingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.workingSet = workingSetManager.createWorkingSet(this.getWorkingSetName(), validElements.toArray(new IAdaptable[validElements.size()]));
        } else {
            this.workingSet.setName(this.getWorkingSetName());
            this.workingSet.setElements(validElements.toArray(new IAdaptable[validElements.size()]));
        }
    }

    private void addSpecialContainers(Set<IAdaptable> validElements) {
        HashSet<Object> specialContainers = new HashSet<Object>();
        for (IAdaptable element : validElements) {
            UnsubmittedTaskContainer unsubmittedContainer;
            IRepositoryQuery query;
            if (!(element instanceof IRepositoryQuery) || (query = (IRepositoryQuery)element).getRepositoryUrl() == null) continue;
            AbstractTaskContainer orphansContainer = TasksUiPlugin.getTaskList().getUnmatchedContainer(query.getRepositoryUrl());
            if (orphansContainer != null) {
                specialContainers.add(orphansContainer);
            }
            if ((unsubmittedContainer = TasksUiPlugin.getTaskList().getUnsubmittedContainer(query.getRepositoryUrl())) == null) continue;
            specialContainers.add(unsubmittedContainer);
        }
        validElements.addAll(specialContainers);
    }

    public IWorkingSet getSelection() {
        return this.workingSet;
    }

    public void setSelection(IWorkingSet workingSet) {
        this.workingSet = workingSet;
        if (this.getShell() != null && this.text != null) {
            this.firstCheck = true;
            this.initializeCheckedState();
            this.text.setText(workingSet.getName());
        }
    }

    private String getWorkingSetName() {
        return this.text.getText();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText("");
        label.setLayoutData((Object)new GridData(772));
        this.text = new Text(composite, 2052);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TaskWorkingSetPage.this.validateInput();
            }
        });
        this.text.setFocus();
        label = new Label(composite, 64);
        label.setText("");
        label.setLayoutData((Object)new GridData(772));
        this.treeViewer = new CheckboxTreeViewer(composite);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setContentProvider((IContentProvider)this.workingSetPageContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new AggregateLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.treeViewer.setSorter((ViewerSorter)new CustomSorter());
        ArrayList<Object> containers = new ArrayList<Object>();
        for (TaskRepository repository : TasksUi.getRepositoryManager().getAllRepositories()) {
            containers.add(repository);
        }
        containers.addAll(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
        this.treeViewer.setInput(containers);
        GridData data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 50;
        this.treeViewer.getControl().setLayoutData((Object)data);
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                TaskWorkingSetPage.this.handleCheckStateChange(event);
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(256));
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setText(Messages.TaskWorkingSetPage_Select_All);
        selectAllButton.setToolTipText("");
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TaskWorkingSetPage.this.treeViewer.setCheckedElements(TaskWorkingSetPage.this.workingSetPageContentProvider.getElements(TaskWorkingSetPage.this.treeViewer.getInput()));
                TaskWorkingSetPage.this.validateInput();
            }
        });
        this.setButtonLayoutData(selectAllButton);
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setText(Messages.TaskWorkingSetPage_Deselect_All);
        deselectAllButton.setToolTipText("");
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TaskWorkingSetPage.this.treeViewer.setCheckedElements(new Object[0]);
                TaskWorkingSetPage.this.validateInput();
            }
        });
        this.setButtonLayoutData(deselectAllButton);
        if (this.workingSet != null) {
            IAdaptable[] iAdaptableArray = this.workingSet.getElements();
            int n = iAdaptableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable object = iAdaptableArray[n2];
                this.treeViewer.expandToLevel((Object)object, 1);
                ++n2;
            }
        } else {
            this.treeViewer.expandToLevel(2);
        }
        this.initializeCheckedState();
        if (this.workingSet != null) {
            this.text.setText(this.workingSet.getName());
        }
        this.setPageComplete(false);
        Dialog.applyDialogFont((Control)composite);
    }

    private void initializeCheckedState() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object[] items = null;
                if (TaskWorkingSetPage.this.workingSet != null && (items = TaskWorkingSetPage.this.workingSet.getElements()) != null) {
                    TaskWorkingSetPage.this.treeViewer.setCheckedElements(new Object[0]);
                    Object[] objectArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object item = objectArray[n2];
                        if (item != null) {
                            TaskWorkingSetPage.this.treeViewer.setChecked(item, true);
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    protected void handleCheckStateChange(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IAdaptable element = (IAdaptable)event.getElement();
                this.handleCheckStateChangeHelper(event, element);
                TaskWorkingSetPage.this.validateInput();
            }

            private void handleCheckStateChangeHelper(CheckStateChangedEvent event2, IAdaptable element) {
                block4: {
                    block5: {
                        block3: {
                            if (!(element instanceof AbstractTaskContainer) && !(element instanceof IProject)) break block3;
                            TaskWorkingSetPage.this.treeViewer.setGrayed((Object)element, false);
                            break block4;
                        }
                        if (!(element instanceof ElementCategory)) break block5;
                        Object[] objectArray = ((ElementCategory)element).getChildren(null);
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object child = objectArray[n2];
                            TaskWorkingSetPage.this.treeViewer.setChecked(child, event2.getChecked());
                            if (child instanceof IAdaptable) {
                                this.handleCheckStateChangeHelper(event2, (IAdaptable)child);
                            }
                            ++n2;
                        }
                        break block4;
                    }
                    if (!(element instanceof TaskRepository) && !(element instanceof TaskRepositoryProjectMapping)) break block4;
                    Object[] objectArray = TaskWorkingSetPage.this.workingSetPageContentProvider.getChildren(element);
                    int n = objectArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Object child = objectArray[n3];
                        TaskWorkingSetPage.this.treeViewer.setChecked(child, event2.getChecked());
                        ++n3;
                    }
                }
            }
        });
    }

    protected void validateInput() {
        String errorMessage = null;
        String infoMessage = null;
        String newText = this.text.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = Messages.TaskWorkingSetPage_The_name_must_not_have_a_leading_or_trailing_whitespace;
        } else if (this.firstCheck) {
            this.firstCheck = false;
            return;
        }
        if ("".equals(newText)) {
            errorMessage = Messages.TaskWorkingSetPage_The_name_must_not_be_empty;
        }
        if (!(errorMessage != null || this.workingSet != null && newText.equals(this.workingSet.getName()))) {
            IWorkingSet[] workingSets;
            IWorkingSet[] iWorkingSetArray = workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int n = workingSets.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet workingSet2 = iWorkingSetArray[n2];
                if (newText.equals(workingSet2.getName())) {
                    errorMessage = Messages.TaskWorkingSetPage_A_working_set_with_the_same_name_already_exists;
                }
                ++n2;
            }
        }
        if (this.treeViewer.getCheckedElements().length == 0) {
            infoMessage = Messages.TaskWorkingSetPage_No_categories_queries_selected;
        }
        this.setMessage(infoMessage, 1);
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    class AggregateLabelProvider
    implements ILabelProvider {
        private final TaskElementLabelProvider taskLabelProvider = new TaskElementLabelProvider(false);
        private final TaskRepositoryLabelProvider taskRepositoryLabelProvider = new TaskRepositoryLabelProvider();
        private final WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();

        AggregateLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof AbstractTaskContainer) {
                return this.taskLabelProvider.getImage(element);
            }
            if (element instanceof TaskRepository) {
                return this.taskRepositoryLabelProvider.getImage(element);
            }
            if (element instanceof TaskRepositoryProjectMapping) {
                return this.getImage(((TaskRepositoryProjectMapping)((Object)element)).getTaskRepository());
            }
            return this.workbenchLabelProvider.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof AbstractTaskContainer) {
                return this.taskLabelProvider.getText(element);
            }
            if (element instanceof TaskRepository) {
                return this.taskRepositoryLabelProvider.getText(element);
            }
            if (element instanceof TaskRepositoryProjectMapping) {
                return this.getText(((TaskRepositoryProjectMapping)((Object)element)).getTaskRepository());
            }
            return this.workbenchLabelProvider.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class CustomSorter
    extends ViewerSorter {
        CustomSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof TaskRepository || e1 instanceof TaskRepositoryProjectMapping) {
                return -1;
            }
            if (e2 instanceof TaskRepository || e2 instanceof TaskRepositoryProjectMapping) {
                return 1;
            }
            if (e1 instanceof ElementCategory && ((ElementCategory)((Object)e1)).getLabel(e1).equals(Messages.TaskWorkingSetPage_Tasks)) {
                return -1;
            }
            if (e2 instanceof ElementCategory && ((ElementCategory)((Object)e1)).getLabel(e1).equals(Messages.TaskWorkingSetPage_Tasks)) {
                return 1;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ElementCategory
    extends PlatformObject
    implements IWorkbenchAdapter {
        private final String label;
        private final List<IAdaptable> children;

        public ElementCategory(String label, List<IAdaptable> children) {
            this.label = label;
            this.children = children;
        }

        public Object[] getChildren(Object o) {
            return this.children.toArray();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return WorkbenchImages.getImageDescriptor((String)"IMG_OBJ_WORKING_SETS");
        }

        public String getLabel(Object o) {
            return this.label;
        }

        public Object getParent(Object o) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskRepositoryProjectMapping
    extends PlatformObject {
        private final TaskRepository taskRepository;
        private final Set<IProject> projects;

        public TaskRepositoryProjectMapping(TaskRepository taskRepository, Set<IProject> mappedProjects) {
            this.taskRepository = taskRepository;
            this.projects = mappedProjects;
        }

        public Set<IProject> getProjects() {
            return this.projects;
        }

        public TaskRepository getTaskRepository() {
            return this.taskRepository;
        }
    }

    private final class WorkingSetPageContentProvider
    implements ITreeContentProvider {
        private ElementCategory tasksContainer;
        private ElementCategory resourcesContainer;
        private final Map<IRepositoryQuery, TaskRepository> queryMap = new HashMap<IRepositoryQuery, TaskRepository>();
        private final Map<IProject, TaskRepositoryProjectMapping> projectMap = new HashMap<IProject, TaskRepositoryProjectMapping>();

        private WorkingSetPageContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof List) {
                ArrayList<IAdaptable> taskRepositoriesContainers = new ArrayList<IAdaptable>();
                ArrayList<IAdaptable> resourcesRepositoriesContainers = new ArrayList<IAdaptable>();
                for (AbstractTaskContainer category : TasksUiInternal.getTaskList().getCategories()) {
                    taskRepositoriesContainers.add((IAdaptable)category);
                }
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                HashSet<IProject> unmappedProjects = new HashSet<IProject>();
                for (Object container : (List)parentElement) {
                    if (!(container instanceof TaskRepository)) continue;
                    if (this.hasChildren(container)) {
                        taskRepositoriesContainers.add((IAdaptable)((TaskRepository)container));
                    }
                    HashSet<IProject> mappedProjects = new HashSet<IProject>();
                    IProject[] iProjectArray = projects;
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project = iProjectArray[n2];
                        TaskRepository taskRepository = TasksUiPlugin.getDefault().getRepositoryForResource((IResource)project);
                        if (container.equals(taskRepository)) {
                            mappedProjects.add(project);
                        } else if (taskRepository == null) {
                            unmappedProjects.add(project);
                        }
                        ++n2;
                    }
                    if (mappedProjects.isEmpty()) continue;
                    TaskRepositoryProjectMapping projectMapping = new TaskRepositoryProjectMapping((TaskRepository)container, mappedProjects);
                    resourcesRepositoriesContainers.add((IAdaptable)projectMapping);
                    for (IProject mappedProject : mappedProjects) {
                        this.projectMap.put(mappedProject, projectMapping);
                    }
                }
                resourcesRepositoriesContainers.addAll(unmappedProjects);
                this.tasksContainer = new ElementCategory(Messages.TaskWorkingSetPage_Tasks, taskRepositoriesContainers);
                this.resourcesContainer = new ElementCategory(Messages.TaskWorkingSetPage_Resources, resourcesRepositoriesContainers);
                return new Object[]{this.tasksContainer, this.resourcesContainer};
            }
            if (parentElement instanceof TaskRepository) {
                ArrayList<AbstractTaskContainer> taskContainers = new ArrayList<AbstractTaskContainer>();
                for (AbstractTaskContainer element : TasksUiPlugin.getTaskList().getRepositoryQueries(((TaskRepository)parentElement).getRepositoryUrl())) {
                    if (!(element instanceof IRepositoryQuery)) continue;
                    taskContainers.add(element);
                    this.queryMap.put((IRepositoryQuery)element, (TaskRepository)parentElement);
                }
                return taskContainers.toArray();
            }
            if (parentElement instanceof TaskRepositoryProjectMapping) {
                return ((TaskRepositoryProjectMapping)((Object)parentElement)).getProjects().toArray();
            }
            if (parentElement instanceof ElementCategory) {
                return ((ElementCategory)((Object)parentElement)).getChildren(parentElement);
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public Object getParent(Object element) {
            if (element instanceof AbstractTaskCategory || element instanceof TaskRepository) {
                return this.tasksContainer;
            }
            if (element instanceof IRepositoryQuery) {
                return this.queryMap.get(element);
            }
            if (element instanceof TaskRepositoryProjectMapping) {
                return this.resourcesContainer;
            }
            if (element instanceof IProject) {
                TaskRepositoryProjectMapping repository = this.projectMap.get(element);
                if (repository != null) {
                    return repository;
                }
                return this.resourcesContainer;
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

