/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentModel;
import org.eclipse.mylyn.tasks.ui.LegendElement;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskSearchPage;
import org.eclipse.mylyn.tasks.ui.wizards.TaskAttachmentPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepositoryConnectorUi {
    private static final String LABEL_TASK_DEFAULT = Messages.AbstractRepositoryConnectorUi_Task;
    private final boolean customNotificationHandling = false;

    public abstract String getConnectorKind();

    public abstract ITaskRepositoryPage getSettingsPage(TaskRepository var1);

    public abstract IWizard getQueryWizard(TaskRepository var1, IRepositoryQuery var2);

    public abstract IWizard getNewTaskWizard(TaskRepository var1, ITaskMapping var2);

    public String getTaskEditorId(ITask repositoryTask) {
        return "org.eclipse.mylyn.tasks.ui.editors.task";
    }

    public abstract boolean hasSearchPage();

    @Deprecated
    public List<ITask> getLegendItems() {
        return Collections.emptyList();
    }

    public List<LegendElement> getLegendElements() {
        return Collections.emptyList();
    }

    public String getTaskKindLabel(ITask task) {
        return LABEL_TASK_DEFAULT;
    }

    public ImageDescriptor getImageDescriptor(IRepositoryElement element) {
        if (element instanceof IRepositoryQuery) {
            return TasksUiImages.QUERY;
        }
        if (element instanceof ITask) {
            return TasksUiImages.TASK;
        }
        return null;
    }

    public ImageDescriptor getTaskKindOverlay(ITask task) {
        return null;
    }

    public ImageDescriptor getTaskPriorityOverlay(ITask task) {
        return TasksUiInternal.getPriorityImage(task);
    }

    @Deprecated
    public IWizard getAddExistingTaskWizard(TaskRepository repository) {
        return null;
    }

    public ITaskSearchPage getSearchPage(TaskRepository repository, IStructuredSelection selection) {
        return null;
    }

    public String getAccountCreationUrl(TaskRepository taskRepository) {
        return null;
    }

    public String getAccountManagementUrl(TaskRepository taskRepository) {
        return null;
    }

    public String getTaskHistoryUrl(TaskRepository taskRepository, ITask task) {
        return null;
    }

    public String getReplyText(TaskRepository taskRepository, ITask task, ITaskComment taskComment, boolean includeTask) {
        return null;
    }

    public IHyperlink[] findHyperlinks(TaskRepository repository, String text, int index, int textOffset) {
        return null;
    }

    public boolean hasCustomNotifications() {
        return false;
    }

    public boolean hasStrictSubtaskHierarchy() {
        return false;
    }

    public IWizardPage getTaskAttachmentPage(TaskAttachmentModel model) {
        return new TaskAttachmentPage(model);
    }
}

