/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.tasks.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.wikitext.tasks.ui.WikiTextTasksUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.editor.IFoldingStructure;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActiveFoldingListener
extends AbstractContextListener {
    private final IEditorPart part;
    private final IFoldingStructure foldingStructure;
    private IPropertyChangeListener preferenceListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("org.eclipse.mylyn.context.ui.editor.folding.enabled".equals(event.getProperty())) {
                Object newValue = event.getNewValue();
                ActiveFoldingListener.this.foldingEnabled = Boolean.TRUE.toString().equals(newValue.toString());
                ActiveFoldingListener.this.updateFolding(false);
            }
        }
    };
    private boolean foldingEnabled;
    private final AbstractContextStructureBridge bridge;
    private final IPreferenceStore preferences;

    public ActiveFoldingListener(IEditorPart part, IFoldingStructure foldingStructure) {
        this.part = part;
        this.foldingStructure = foldingStructure;
        this.bridge = ContextCore.getStructureBridge((String)"org.eclipse.mylyn.wikitext");
        ContextCore.getContextManager().addListener((AbstractContextListener)this);
        this.preferences = WikiTextTasksUiPlugin.getDefault().getPreferenceStore();
        this.preferences.addPropertyChangeListener(this.preferenceListener);
        this.foldingEnabled = this.preferences.getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled");
        this.updateFolding(false);
    }

    private void updateFolding(boolean elementsDeleted) {
        if (!this.foldingStructure.isFoldingEnabled()) {
            return;
        }
        if (!this.foldingEnabled || !ContextCore.getContextManager().isContextActive()) {
            this.foldingStructure.expandAll();
        } else {
            OutlineItem outline = (OutlineItem)this.part.getAdapter(OutlineItem.class);
            if (outline != null) {
                final ArrayList toExpand = new ArrayList();
                outline.accept(new OutlineItem.Visitor(){

                    public boolean visit(OutlineItem item) {
                        String identifier = ActiveFoldingListener.this.bridge.getHandleIdentifier((Object)item);
                        IInteractionElement element = ContextCore.getContextManager().getElement(identifier);
                        if (element != null && element.getInterest().isInteresting()) {
                            toExpand.add(item);
                        }
                        return true;
                    }
                });
                if (toExpand.isEmpty()) {
                    this.foldingStructure.collapseAll(elementsDeleted);
                } else {
                    this.foldingStructure.expandElementsExclusive(toExpand, elementsDeleted);
                }
            }
        }
    }

    public void contextActivated(IInteractionContext context) {
        if (this.foldingStructure.isFoldingEnabled()) {
            this.updateFolding(false);
        }
    }

    public void contextCleared(IInteractionContext context) {
        if (this.foldingStructure.isFoldingEnabled()) {
            if (!this.foldingEnabled || !ContextCore.getContextManager().isContextActive()) {
                this.foldingStructure.expandAll();
            } else {
                this.foldingStructure.collapseAll(true);
            }
        }
    }

    public void contextDeactivated(IInteractionContext context) {
        if (this.foldingStructure.isFoldingEnabled()) {
            this.foldingStructure.expandAll();
        }
    }

    public void interestChanged(List<IInteractionElement> elements) {
        if (this.foldingStructure.isFoldingEnabled()) {
            this.updateFolding(false);
        }
    }

    public void elementsDeleted(List<IInteractionElement> elements) {
        if (this.foldingStructure.isFoldingEnabled()) {
            this.updateFolding(true);
        }
    }

    public void dispose() {
        if (this.preferenceListener != null) {
            this.preferences.removePropertyChangeListener(this.preferenceListener);
            this.preferenceListener = null;
        }
        ContextCore.getContextManager().removeListener((AbstractContextListener)this);
    }
}

