/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.tasks.ui.util;

import org.eclipse.mylyn.internal.wikitext.tasks.ui.util.bugzilla.BugzillaGeneratedCommentBlock;
import org.eclipse.mylyn.internal.wikitext.tasks.ui.util.bugzilla.BugzillaQuoteBlock;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguageConfiguration;

public class Util {
    private static final String BUGZILLA = "bugzilla";

    public static MarkupLanguageConfiguration create(String repositoryKind) {
        MarkupLanguageConfiguration configuration = new MarkupLanguageConfiguration();
        configuration.setEnableUnwrappedParagraphs(false);
        configuration.setEscapingHtmlAndXml(true);
        configuration.setNewlinesMustCauseLineBreak(true);
        configuration.setOptimizeForRepositoryUsage(true);
        if (Util.isBugzillaOrDerivative(repositoryKind)) {
            configuration.getBlocks().add(new BugzillaQuoteBlock());
            configuration.getBlocks().add(new BugzillaGeneratedCommentBlock());
        }
        return configuration;
    }

    private static boolean isBugzillaOrDerivative(String repositoryKind) {
        return BUGZILLA.equals(repositoryKind);
    }
}

