/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.wikitext.ui.Messages;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;

public class WikiTextNature
implements IProjectNature {
    public static final String ID = "org.eclipse.mylyn.wikitext.ui.wikiTextNature";
    private IProject project;

    public static void install(IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = ID;
        IStatus status = ResourcesPlugin.getWorkspace().validateNatureSet(natures);
        if (status.getCode() != 0) {
            throw new CoreException(WikiTextUiPlugin.getDefault().createStatus(Messages.getString("WikiTextNature.1"), 4, null));
        }
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }

    public static void uninstall(IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        ArrayList<String> newNatures = new ArrayList<String>(natures.length);
        String[] stringArray = natures;
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            if (!n3.equals(ID)) {
                newNatures.add(n3);
            }
            ++n2;
        }
        if (newNatures.size() != natures.length) {
            natures = newNatures.toArray(new String[newNatures.size()]);
            IStatus status = ResourcesPlugin.getWorkspace().validateNatureSet(natures);
            if (status.getCode() == 0) {
                description.setNatureIds(natures);
                project.setDescription(description, monitor);
            } else {
                throw new CoreException(WikiTextUiPlugin.getDefault().createStatus(Messages.getString("WikiTextNature.1"), 4, null));
            }
        }
    }

    public void configure() throws CoreException {
        ICommand command;
        IProjectDescription desc = this.project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        boolean found = false;
        ICommand[] iCommandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            command = iCommandArray[n2];
            if (command.getBuilderName().equals("org.eclipse.mylyn.wikitext.ui.wikiTextValidationBuilder")) {
                found = true;
                break;
            }
            ++n2;
        }
        if (!found) {
            command = desc.newCommand();
            command.setBuilderName("org.eclipse.mylyn.wikitext.ui.wikiTextValidationBuilder");
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = command;
            desc.setBuildSpec(newCommands);
            this.project.setDescription(desc, null);
        }
    }

    public void deconfigure() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        ArrayList<ICommand> newCommands = new ArrayList<ICommand>(commands.length);
        ICommand[] iCommandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (!command.getBuilderName().equals("org.eclipse.mylyn.wikitext.ui.wikiTextValidationBuilder")) {
                newCommands.add(command);
            }
            ++n2;
        }
        if (newCommands.size() == commands.length - 1) {
            desc.setBuildSpec(newCommands.toArray(new ICommand[newCommands.size()]));
            this.project.setDescription(desc, null);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

