/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.URLHyperlink;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.editor.FoldingStructure;
import org.eclipse.mylyn.internal.wikitext.ui.editor.HeadingProjectionAnnotation;
import org.eclipse.mylyn.internal.wikitext.ui.editor.IFoldingStructure;
import org.eclipse.mylyn.internal.wikitext.ui.editor.MarkupEditorOutline;
import org.eclipse.mylyn.internal.wikitext.ui.editor.MarkupProjectionViewer;
import org.eclipse.mylyn.internal.wikitext.ui.editor.MarkupSourceViewerConfiguration;
import org.eclipse.mylyn.internal.wikitext.ui.editor.Messages;
import org.eclipse.mylyn.internal.wikitext.ui.editor.actions.SetMarkupLanguageAction;
import org.eclipse.mylyn.internal.wikitext.ui.editor.operations.AbstractDocumentCommand;
import org.eclipse.mylyn.internal.wikitext.ui.editor.operations.CommandManager;
import org.eclipse.mylyn.internal.wikitext.ui.editor.preferences.Preferences;
import org.eclipse.mylyn.internal.wikitext.ui.editor.reconciler.MarkupMonoReconciler;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.FastMarkupPartitioner;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.MarkupDocumentProvider;
import org.eclipse.mylyn.wikitext.core.WikiText;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineParser;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.swt.IFocusService;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupEditor
extends TextEditor
implements IShowInTarget,
IShowInSource,
CommandManager {
    private static final String RULER_CONTEXT_MENU_ID = "org.eclipse.mylyn.internal.wikitext.ui.editor.MarkupEditor.ruler";
    private static final String MARKUP_LANGUAGE = "markupLanguage";
    public static final String CONTEXT = "org.eclipse.mylyn.wikitext.ui.editor.markupSourceContext";
    public static final String ID = "org.eclipse.mylyn.wikitext.ui.editor.markupEditor";
    private static final String[] SHOW_IN_TARGETS = new String[]{"org.eclipse.ui.views.ResourceNavigator", "org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.views.ContentOutline"};
    private static IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return SHOW_IN_TARGETS;
        }
    };
    private IDocument document;
    private IDocumentListener documentListener;
    private boolean previewDirty = true;
    private boolean outlineDirty = true;
    private Browser browser;
    private MarkupEditorOutline outlinePage;
    private OutlineItem outlineModel;
    private final OutlineParser outlineParser = new OutlineParser();
    private boolean disableReveal;
    private ISourceViewer viewer;
    private IPropertyChangeListener preferencesListener;
    private IDocumentPartitioningListener documentPartitioningListener;
    private final MarkupSourceViewerConfiguration sourceViewerConfiguration;
    private CTabItem sourceTab;
    private ProjectionSupport projectionSupport;
    private Map<String, HeadingProjectionAnnotation> projectionAnnotationById;
    private boolean updateJobScheduled;
    protected int documentGeneration;
    public static final String EDITOR_SOURCE_VIEWER = "org.eclipse.mylyn.wikitext.ui.editor.sourceViewer";
    private UIJob updateOutlineJob;
    private IFoldingStructure foldingStructure;
    private CTabFolder tabFolder;
    private CTabItem previewTab;

    public MarkupEditor() {
        this.outlineParser.setLabelMaxLength(48);
        this.outlineModel = this.outlineParser.createRootItem();
        this.disableReveal = false;
        this.updateJobScheduled = false;
        this.documentGeneration = 0;
        this.setDocumentProvider((IDocumentProvider)new MarkupDocumentProvider());
        this.sourceViewerConfiguration = new MarkupSourceViewerConfiguration(this.getPreferenceStore());
        this.sourceViewerConfiguration.setOutline(this.outlineModel);
        this.sourceViewerConfiguration.setShowInTarget(this);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.sourceViewerConfiguration);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.tabFolder = new CTabFolder(parent, 1024);
        this.sourceTab = new CTabItem(this.tabFolder, 0);
        this.updateSourceTabLabel();
        this.viewer = new MarkupProjectionViewer((Composite)this.tabFolder, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles | 0x40);
        this.sourceTab.setControl((Control)(this.viewer instanceof Viewer ? ((Viewer)this.viewer).getControl() : this.viewer.getTextWidget()));
        this.tabFolder.setSelection(this.sourceTab);
        this.previewTab = new CTabItem(this.tabFolder, 0);
        this.previewTab.setText(Messages.getString("MarkupEditor.PreviewView_label"));
        this.previewTab.setToolTipText(Messages.getString("MarkupEditor.PreviewView_tooltip"));
        this.browser = new Browser((Composite)this.tabFolder, 0);
        this.browser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent event) {
                event.doit = false;
            }

            public void changing(LocationEvent event) {
                if (event.location.matches("([a-zA-Z]{3,8})://?.*")) {
                    int idxOfSlashHash = event.location.indexOf("/#");
                    if (idxOfSlashHash != -1) {
                        if (!event.location.startsWith("file:///#")) {
                            event.doit = false;
                        }
                        return;
                    }
                    event.doit = false;
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().createBrowser("org.eclipse.ui.browser").openURL(new URL(event.location));
                    }
                    catch (Exception exception) {
                        new URLHyperlink((IRegion)new Region(0, 1), event.location).open();
                    }
                }
            }
        });
        this.previewTab.setControl((Control)this.browser);
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionevent) {
                this.widgetSelected(selectionevent);
            }

            public void widgetSelected(SelectionEvent selectionevent) {
                if (MarkupEditor.this.tabFolder.getSelection() == MarkupEditor.this.previewTab) {
                    MarkupEditor.this.updatePreview(MarkupEditor.this.getNearestMatchingOutlineItem());
                }
            }
        });
        this.viewer.getTextWidget().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                MarkupEditor.this.updateOutlineSelection();
            }
        });
        this.viewer.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (this.isRelevantKeyCode(e.keyCode)) {
                    MarkupEditor.this.updateOutlineSelection();
                }
            }

            private boolean isRelevantKeyCode(int keyCode) {
                switch (keyCode) {
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000003: 
                    case 0x1000004: 
                    case 0x1000005: 
                    case 0x1000006: {
                        return true;
                    }
                }
                return false;
            }
        });
        this.viewer.getTextWidget().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                MarkupEditor.this.updateOutlineSelection();
            }
        });
        IFocusService focusService = (IFocusService)PlatformUI.getWorkbench().getService(IFocusService.class);
        if (focusService != null) {
            focusService.addFocusTracker((Control)this.viewer.getTextWidget(), EDITOR_SOURCE_VIEWER);
        }
        this.viewer.getTextWidget().setData(MarkupLanguage.class.getName(), (Object)this.getMarkupLanguage());
        this.viewer.getTextWidget().setData(ISourceViewer.class.getName(), (Object)this.viewer);
        this.getSourceViewerDecorationSupport(this.viewer);
        this.updateDocument();
        if (this.preferencesListener == null) {
            this.preferencesListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (MarkupEditor.this.viewer.getTextWidget().isDisposed()) {
                        return;
                    }
                    MarkupEditor.this.viewer.getTextWidget().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MarkupEditor.this.reloadPreferences();
                        }
                    });
                }
            };
            WikiTextUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferencesListener);
        }
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        this.syncProjectionModeWithPreferences();
        viewer.addProjectionListener(new IProjectionListener(){

            public void projectionDisabled() {
                MarkupEditor.this.projectionAnnotationById = null;
                MarkupEditor.this.saveProjectionPreferences();
            }

            public void projectionEnabled() {
                MarkupEditor.this.saveProjectionPreferences();
                MarkupEditor.this.updateProjectionAnnotations();
            }
        });
        if (!this.outlineDirty && this.isFoldingEnabled()) {
            this.updateProjectionAnnotations();
        }
    }

    private void reloadPreferences() {
        this.syncProjectionModeWithPreferences();
        this.viewer.invalidateTextPresentation();
    }

    private void syncProjectionModeWithPreferences() {
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        if (viewer.isProjectionMode() != WikiTextUiPlugin.getDefault().getPreferences().isEditorFolding()) {
            viewer.doOperation(19);
        }
    }

    public void updatePartControl(IEditorInput input) {
        super.updatePartControl(input);
        this.updateDocument();
    }

    public void saveProjectionPreferences() {
        if (this.isFoldingEnabled() != WikiTextUiPlugin.getDefault().getPreferences().isEditorFolding()) {
            Preferences preferences = WikiTextUiPlugin.getDefault().getPreferences().clone();
            preferences.setEditorFolding(this.isFoldingEnabled());
            preferences.save(WikiTextUiPlugin.getDefault().getPreferenceStore(), false);
        }
    }

    public void dispose() {
        if (this.document != null) {
            if (this.documentListener != null) {
                this.document.removeDocumentListener(this.documentListener);
            }
            if (this.documentPartitioningListener != null) {
                this.document.removeDocumentPartitioningListener(this.documentPartitioningListener);
            }
            this.document = null;
        }
        if (this.preferencesListener != null) {
            WikiTextUiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferencesListener);
            this.preferencesListener = null;
        }
        super.dispose();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setHelpContextId(CONTEXT);
        this.setRulerContextMenuId(RULER_CONTEXT_MENU_ID);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.updateDocument();
        IFile file = this.getFile();
        if (this.sourceViewerConfiguration != null) {
            this.sourceViewerConfiguration.setFile(file);
        }
        this.initializeMarkupLanguage(input);
        this.outlineModel.setResourcePath(file == null ? null : file.getFullPath().toString());
    }

    private void updateDocument() {
        if (this.getSourceViewer() != null) {
            IDocument previousDocument = this.document;
            this.document = this.getSourceViewer().getDocument();
            if (previousDocument == this.document) {
                return;
            }
            if (previousDocument != null && this.documentListener != null) {
                previousDocument.removeDocumentListener(this.documentListener);
            }
            if (previousDocument != null && this.documentPartitioningListener != null) {
                previousDocument.removeDocumentPartitioningListener(this.documentPartitioningListener);
            }
            if (this.document != null) {
                if (this.documentListener == null) {
                    this.documentListener = new IDocumentListener(){

                        public void documentAboutToBeChanged(DocumentEvent event) {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void documentChanged(DocumentEvent event) {
                            MarkupEditor.this.previewDirty = true;
                            MarkupEditor.this.outlineDirty = true;
                            MarkupEditor markupEditor = MarkupEditor.this;
                            synchronized (markupEditor) {
                                ++MarkupEditor.this.documentGeneration;
                            }
                            MarkupEditor.this.scheduleOutlineUpdate();
                        }
                    };
                }
                this.document.addDocumentListener(this.documentListener);
                if (this.documentPartitioningListener == null) {
                    this.documentPartitioningListener = new IDocumentPartitioningListener(){

                        public void documentPartitioningChanged(IDocument document) {
                            MarkupEditor.this.scheduleOutlineUpdate();
                        }
                    };
                }
                this.document.addDocumentPartitioningListener(this.documentPartitioningListener);
            }
            this.previewDirty = true;
            this.outlineDirty = true;
            this.updateOutline();
        }
    }

    private void updatePreview(final OutlineItem item) {
        boolean revealItem;
        boolean bl = revealItem = item != null;
        if (this.previewDirty && this.browser != null) {
            String xhtml = null;
            if (this.document == null) {
                xhtml = "<?xml version=\"1.0\" ?><html xmlns=\"http://www.w3.org/1999/xhtml\"><body></body></html>";
            } else {
                try {
                    String css;
                    MarkupParser markupParser = new MarkupParser();
                    IFile file = this.getFile();
                    String title = file.getName();
                    if (title.lastIndexOf(46) != -1) {
                        title = title.substring(0, title.lastIndexOf(46));
                    }
                    StringWriter writer = new StringWriter();
                    HtmlDocumentBuilder builder = new HtmlDocumentBuilder(writer){

                        protected void emitAnchorHref(String href) {
                            if (href.startsWith("#")) {
                                this.writer.writeAttribute("onclick", String.format("javascript: window.location.hash = '%s'; return false;", href));
                                this.writer.writeAttribute("href", "#");
                            } else {
                                super.emitAnchorHref(href);
                            }
                        }
                    };
                    builder.setTitle(title);
                    IPath location = file.getLocation();
                    if (location != null) {
                        builder.setBaseInHead(true);
                        builder.setBase(location.removeLastSegments(1).toFile().toURI());
                    }
                    if ((css = WikiTextUiPlugin.getDefault().getPreferences().getMarkupViewerCss()) != null && css.length() > 0) {
                        builder.addCssStylesheet(new HtmlDocumentBuilder.Stylesheet((Reader)new StringReader(css)));
                    }
                    markupParser.setBuilder((DocumentBuilder)builder);
                    markupParser.setMarkupLanguage(this.getMarkupLanguage());
                    if (markupParser.getMarkupLanguage() == null) {
                        builder.beginDocument();
                        builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, new Attributes());
                        builder.characters(this.document.get());
                        builder.endBlock();
                        builder.endDocument();
                    } else {
                        markupParser.getMarkupLanguage().setBlocksOnly(false);
                        markupParser.getMarkupLanguage().setFilterGenerativeContents(false);
                        markupParser.parse(this.document.get());
                    }
                    xhtml = writer.toString();
                }
                catch (Exception e) {
                    StringWriter stackTrace = new StringWriter();
                    PrintWriter writer = new PrintWriter(stackTrace);
                    e.printStackTrace(writer);
                    writer.close();
                    StringWriter documentWriter = new StringWriter();
                    HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)documentWriter);
                    builder.beginDocument();
                    builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, new Attributes());
                    builder.characters(stackTrace.toString());
                    builder.endBlock();
                    builder.endDocument();
                    xhtml = writer.toString();
                }
            }
            if (revealItem) {
                revealItem = false;
                this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){

                    public void completed(ProgressEvent event) {
                        MarkupEditor.this.browser.removeProgressListener((ProgressListener)this);
                        MarkupEditor.this.revealInBrowser(item);
                    }
                });
            }
            this.browser.setText(xhtml);
            this.previewDirty = false;
        }
        if (revealItem) {
            this.revealInBrowser(item);
        }
    }

    public IFile getFile() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return fileEditorInput.getFile();
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class == adapter) {
            if (this.outlinePage == null || this.outlinePage.getControl() == null || this.outlinePage.getControl().isDisposed()) {
                this.outlinePage = new MarkupEditorOutline(this);
            }
            return this.outlinePage;
        }
        if (adapter == OutlineItem.class) {
            return this.getOutlineModel();
        }
        if (adapter == IFoldingStructure.class) {
            if (!this.isFoldingEnabled()) {
                return null;
            }
            if (this.foldingStructure == null) {
                this.foldingStructure = new FoldingStructure(this);
            }
            return this.foldingStructure;
        }
        if (adapter == IShowInTargetList.class) {
            return SHOW_IN_TARGET_LIST;
        }
        return super.getAdapter(adapter);
    }

    public ISourceViewer getViewer() {
        return this.viewer;
    }

    public OutlineItem getOutlineModel() {
        if (this.outlineDirty) {
            this.updateOutlineNow();
        }
        return this.outlineModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleOutlineUpdate() {
        MarkupEditor markupEditor = this;
        synchronized (markupEditor) {
            if (this.updateJobScheduled) {
                return;
            }
        }
        this.updateOutlineJob = new UIJob(Messages.getString("MarkupEditor.2")){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInUIThread(IProgressMonitor monitor) {
                MarkupEditor markupEditor = MarkupEditor.this;
                synchronized (markupEditor) {
                    MarkupEditor.this.updateJobScheduled = false;
                }
                if (!MarkupEditor.this.outlineDirty) {
                    return Status.CANCEL_STATUS;
                }
                MarkupEditor.this.updateOutline();
                return Status.OK_STATUS;
            }
        };
        this.updateOutlineJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void scheduled(IJobChangeEvent event) {
                MarkupEditor markupEditor = MarkupEditor.this;
                synchronized (markupEditor) {
                    MarkupEditor.this.updateJobScheduled = true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                MarkupEditor markupEditor = MarkupEditor.this;
                synchronized (markupEditor) {
                    MarkupEditor.this.updateJobScheduled = false;
                    MarkupEditor.this.updateOutlineJob = null;
                }
            }
        });
        this.updateOutlineJob.setUser(false);
        this.updateOutlineJob.setSystem(true);
        this.updateOutlineJob.setPriority(10);
        this.updateOutlineJob.schedule(600L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOutlineNow() {
        int contentGeneration;
        if (!this.outlineDirty) {
            return;
        }
        if (this.getSourceViewer().getTextWidget().isDisposed()) {
            return;
        }
        MarkupLanguage markupLanguage = this.getMarkupLanguage();
        if (markupLanguage == null) {
            return;
        }
        MarkupLanguage language = markupLanguage.clone();
        String content = this.document.get();
        MarkupEditor markupEditor = this;
        synchronized (markupEditor) {
            contentGeneration = this.documentGeneration;
        }
        this.outlineParser.setMarkupLanguage(language);
        OutlineItem rootItem = this.outlineParser.parse(content);
        this.updateOutline(contentGeneration, rootItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOutline() {
        int contentGeneration;
        if (!this.outlineDirty) {
            return;
        }
        if (this.getSourceViewer().getTextWidget().isDisposed()) {
            return;
        }
        MarkupLanguage markupLanguage = this.getMarkupLanguage();
        if (markupLanguage == null) {
            return;
        }
        final MarkupLanguage language = markupLanguage.clone();
        final Display display = this.getSourceViewer().getTextWidget().getDisplay();
        final String content = this.document.get();
        MarkupEditor markupEditor = this;
        synchronized (markupEditor) {
            contentGeneration = this.documentGeneration;
        }
        Job parseOutlineJob = new Job(String.valueOf(MarkupEditor.class.getSimpleName()) + "#updateOutline"){

            protected IStatus run(IProgressMonitor monitor) {
                MarkupEditor.this.outlineParser.setMarkupLanguage(language);
                if (this.shouldCancel()) {
                    return Status.CANCEL_STATUS;
                }
                final OutlineItem rootItem = MarkupEditor.this.outlineParser.parse(content);
                if (this.shouldCancel()) {
                    return Status.CANCEL_STATUS;
                }
                display.asyncExec(new Runnable(){

                    public void run() {
                        MarkupEditor.this.updateOutline(contentGeneration, rootItem);
                    }
                });
                return Status.OK_STATUS;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean shouldCancel() {
                MarkupEditor markupEditor = MarkupEditor.this;
                synchronized (markupEditor) {
                    block4: {
                        if (contentGeneration == MarkupEditor.this.documentGeneration) break block4;
                        return true;
                    }
                }
                return false;
            }
        };
        parseOutlineJob.setPriority(10);
        parseOutlineJob.setSystem(true);
        parseOutlineJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOutline(int contentGeneration, OutlineItem rootItem) {
        if (this.getSourceViewer().getTextWidget().isDisposed()) {
            return;
        }
        MarkupEditor markupEditor = this;
        synchronized (markupEditor) {
            if (contentGeneration != this.documentGeneration) {
                return;
            }
        }
        this.outlineDirty = false;
        this.outlineModel.clear();
        this.outlineModel.moveChildren(rootItem);
        if (this.outlinePage != null && this.outlinePage.getControl() != null && !this.outlinePage.getControl().isDisposed()) {
            this.outlinePage.refresh();
            this.outlinePage.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (MarkupEditor.this.outlinePage != null && MarkupEditor.this.outlinePage.getControl() != null && !MarkupEditor.this.outlinePage.getControl().isDisposed()) {
                        MarkupEditor.this.updateOutlineSelection();
                    }
                }
            });
        }
        this.updateProjectionAnnotations();
    }

    private void updateProjectionAnnotations() {
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        ProjectionAnnotationModel projectionAnnotationModel = viewer.getProjectionAnnotationModel();
        if (projectionAnnotationModel != null) {
            ArrayList<Annotation> newProjectionAnnotations = new ArrayList<Annotation>(this.projectionAnnotationById == null ? 10 : this.projectionAnnotationById.size() + 2);
            HashMap<HeadingProjectionAnnotation, Position> annotationToPosition = new HashMap<HeadingProjectionAnnotation, Position>();
            List children = this.outlineModel.getChildren();
            if (!children.isEmpty()) {
                this.createProjectionAnnotations(newProjectionAnnotations, annotationToPosition, children, this.document.getLength());
            }
            if (newProjectionAnnotations.isEmpty() && (this.projectionAnnotationById == null || this.projectionAnnotationById.isEmpty())) {
                return;
            }
            HashMap<String, HeadingProjectionAnnotation> newProjectionAnnotationById = new HashMap<String, HeadingProjectionAnnotation>();
            if (this.projectionAnnotationById != null) {
                HashSet<HeadingProjectionAnnotation> toDelete = new HashSet<HeadingProjectionAnnotation>(this.projectionAnnotationById.size());
                Iterator newPositionIt = annotationToPosition.entrySet().iterator();
                while (newPositionIt.hasNext()) {
                    Map.Entry newAnnotationEnt = newPositionIt.next();
                    HeadingProjectionAnnotation newAnnotation = (HeadingProjectionAnnotation)((Object)newAnnotationEnt.getKey());
                    Position newPosition = (Position)newAnnotationEnt.getValue();
                    HeadingProjectionAnnotation annotation = this.projectionAnnotationById.get(newAnnotation.getHeadingId());
                    if (annotation != null) {
                        Position position = projectionAnnotationModel.getPosition((Annotation)annotation);
                        if (newPosition.equals((Object)position)) {
                            newPositionIt.remove();
                            newProjectionAnnotationById.put(annotation.getHeadingId(), annotation);
                            continue;
                        }
                        toDelete.add(annotation);
                        if (annotation.isCollapsed()) {
                            newAnnotation.markCollapsed();
                        } else {
                            newAnnotation.markExpanded();
                        }
                        newProjectionAnnotationById.put(annotation.getHeadingId(), newAnnotation);
                        continue;
                    }
                    newProjectionAnnotationById.put(newAnnotation.getHeadingId(), newAnnotation);
                }
                Iterator annotationIt = projectionAnnotationModel.getAnnotationIterator();
                while (annotationIt.hasNext()) {
                    HeadingProjectionAnnotation projectionAnnotation;
                    Annotation annotation = (Annotation)annotationIt.next();
                    if (!(annotation instanceof HeadingProjectionAnnotation) || this.projectionAnnotationById.containsKey((projectionAnnotation = (HeadingProjectionAnnotation)annotation).getHeadingId()) || toDelete.contains((Object)projectionAnnotation)) continue;
                    toDelete.add(projectionAnnotation);
                }
                projectionAnnotationModel.modifyAnnotations(toDelete.isEmpty() ? null : toDelete.toArray(new Annotation[toDelete.size()]), annotationToPosition, null);
            } else {
                projectionAnnotationModel.modifyAnnotations(null, annotationToPosition, null);
                for (HeadingProjectionAnnotation annotation : annotationToPosition.keySet()) {
                    newProjectionAnnotationById.put(annotation.getHeadingId(), annotation);
                }
            }
            this.projectionAnnotationById = newProjectionAnnotationById;
        } else {
            this.projectionAnnotationById = null;
        }
    }

    private void createProjectionAnnotations(List<Annotation> newProjectionAnnotations, Map<HeadingProjectionAnnotation, Position> annotationToPosition, List<OutlineItem> children, int endOffset) {
        int size = children.size();
        int lastIndex = size - 1;
        int x = 0;
        while (x < size) {
            OutlineItem child = children.get(x);
            if (child.getId() != null && child.getId().length() != 0) {
                int offset;
                int end = x == lastIndex ? endOffset : children.get(x + 1).getOffset();
                int length = end - (offset = child.getOffset());
                if (length > 0) {
                    HeadingProjectionAnnotation annotation = new HeadingProjectionAnnotation(child.getId());
                    Position position = new Position(offset, length);
                    newProjectionAnnotations.add((Annotation)annotation);
                    annotationToPosition.put(annotation, position);
                }
                if (!child.getChildren().isEmpty()) {
                    this.createProjectionAnnotations(newProjectionAnnotations, annotationToPosition, child.getChildren(), end);
                }
            }
            ++x;
        }
    }

    private void updateOutlineSelection() {
        if (this.disableReveal) {
            return;
        }
        if (this.outlineModel != null && this.outlinePage != null) {
            this.disableReveal = true;
            try {
                OutlineItem item = this.getNearestMatchingOutlineItem();
                if (item != null) {
                    this.outlinePage.setSelection((ISelection)new StructuredSelection((Object)item));
                }
            }
            finally {
                this.disableReveal = false;
            }
        }
    }

    private OutlineItem getNearestMatchingOutlineItem() {
        Point selectedRange = this.getSourceViewer().getSelectedRange();
        if (selectedRange != null) {
            return this.outlineModel.findNearestMatchingOffset(selectedRange.x);
        }
        return null;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{CONTEXT});
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        IContextService contextService = (IContextService)site.getService(IContextService.class);
        contextService.activateContext(CONTEXT);
    }

    private void initializeMarkupLanguage(IEditorInput input) {
        MarkupLanguage markupLanguage = this.loadMarkupLanguagePreference();
        if (markupLanguage == null) {
            String name = input.getName();
            if (input instanceof IFileEditorInput) {
                name = ((IFileEditorInput)input).getFile().getName();
            } else if (input instanceof IPathEditorInput) {
                name = ((IPathEditorInput)input).getPath().lastSegment();
            }
            markupLanguage = WikiText.getMarkupLanguageForFilename((String)name);
            if (markupLanguage == null) {
                markupLanguage = WikiText.getMarkupLanguage((String)"Textile");
            }
        }
        this.setMarkupLanguage(markupLanguage, false);
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage, boolean persistSetting) {
        IReconciler reconciler;
        ISourceViewer sourceViewer;
        ((MarkupDocumentProvider)this.getDocumentProvider()).setMarkupLanguage(markupLanguage);
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        IDocumentPartitioner partitioner = document.getDocumentPartitioner();
        if (partitioner instanceof FastMarkupPartitioner) {
            FastMarkupPartitioner fastMarkupPartitioner = (FastMarkupPartitioner)partitioner;
            fastMarkupPartitioner.setMarkupLanguage(markupLanguage);
        }
        this.sourceViewerConfiguration.setMarkupLanguage(markupLanguage);
        if (this.getSourceViewer() != null) {
            this.getSourceViewer().invalidateTextPresentation();
        }
        this.outlineDirty = true;
        this.scheduleOutlineUpdate();
        this.updateSourceTabLabel();
        if (this.viewer != null) {
            this.viewer.getTextWidget().setData(MarkupLanguage.class.getName(), (Object)this.getMarkupLanguage());
        }
        if (persistSetting && markupLanguage != null) {
            this.storeMarkupLanguagePreference(markupLanguage);
        }
        if (persistSetting && (sourceViewer = this.getSourceViewer()) instanceof MarkupProjectionViewer && (reconciler = ((MarkupProjectionViewer)sourceViewer).getReconciler()) instanceof MarkupMonoReconciler) {
            ((MarkupMonoReconciler)reconciler).forceReconciling();
        }
    }

    private void updateSourceTabLabel() {
        if (this.sourceTab != null) {
            MarkupLanguage markupLanguage = this.getMarkupLanguage();
            if (markupLanguage == null) {
                this.sourceTab.setText(Messages.getString("MarkupEditor.SourceView_label"));
                this.sourceTab.setToolTipText(Messages.getString("MarkupEditor.SourceView_tooltip"));
            } else {
                this.sourceTab.setText(Messages.getMessage("MarkupEditor.SourceView_label2", markupLanguage.getName()));
                this.sourceTab.setToolTipText(Messages.getMessage("MarkupEditor.SourceView_tooltip2", markupLanguage.getName()));
            }
        }
    }

    private MarkupLanguage loadMarkupLanguagePreference() {
        IFile file = this.getFile();
        if (file != null) {
            return MarkupEditor.loadMarkupLanguagePreference(file);
        }
        return null;
    }

    public static MarkupLanguage loadMarkupLanguagePreference(IFile file) {
        String languageName = MarkupEditor.getMarkupLanguagePreference(file);
        if (languageName != null) {
            return WikiText.getMarkupLanguage((String)languageName);
        }
        return null;
    }

    public static String getMarkupLanguagePreference(IFile file) {
        String languageName;
        try {
            languageName = file.getPersistentProperty(new QualifiedName(WikiTextUiPlugin.getDefault().getPluginId(), MARKUP_LANGUAGE));
        }
        catch (CoreException e) {
            WikiTextUiPlugin.getDefault().log(4, Messages.getString("MarkupEditor.0"), e);
            return null;
        }
        return languageName;
    }

    private void storeMarkupLanguagePreference(MarkupLanguage markupLanguage) {
        if (markupLanguage == null) {
            throw new IllegalArgumentException();
        }
        IFile file = this.getFile();
        if (file != null) {
            String preference;
            MarkupLanguage defaultMarkupLanguage = WikiText.getMarkupLanguageForFilename((String)file.getName());
            String string = preference = markupLanguage == null ? null : markupLanguage.getName();
            if (defaultMarkupLanguage != null && defaultMarkupLanguage.getName().equals(preference)) {
                preference = null;
            }
            try {
                file.setPersistentProperty(new QualifiedName(WikiTextUiPlugin.getDefault().getPluginId(), MARKUP_LANGUAGE), preference);
            }
            catch (CoreException e) {
                WikiTextUiPlugin.getDefault().log(4, MessageFormat.format(Messages.getString("MarkupEditor.1"), preference), e);
            }
        }
    }

    public MarkupLanguage getMarkupLanguage() {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        IDocumentPartitioner partitioner = document.getDocumentPartitioner();
        MarkupLanguage markupLanguage = null;
        if (partitioner instanceof FastMarkupPartitioner) {
            markupLanguage = ((FastMarkupPartitioner)partitioner).getMarkupLanguage();
        }
        return markupLanguage;
    }

    protected void createActions() {
        super.createActions();
        ContentAssistAction action = new ContentAssistAction(Messages.getBundle(), "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
    }

    public void setAction(String actionID, IAction action) {
        if (action.getActionDefinitionId() != null) {
            IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
            handlerService.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler(action));
        }
        super.setAction(actionID, action);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        MarkupLanguage markupLanguage = this.getMarkupLanguage();
        MenuManager markupLanguageMenu = new MenuManager(Messages.getString("MarkupEditor.MarkupLanguage"));
        for (String markupLanguageName : new TreeSet(WikiText.getMarkupLanguageNames())) {
            markupLanguageMenu.add((IAction)new SetMarkupLanguageAction(this, markupLanguageName, markupLanguage != null && markupLanguageName.equals(markupLanguage.getName())));
        }
        menu.prependToGroup("settings", (IContributionItem)markupLanguageMenu);
    }

    public boolean isFoldingEnabled() {
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        return viewer.getProjectionAnnotationModel() != null;
    }

    protected boolean isLineNumberRulerVisible() {
        return false;
    }

    public boolean show(ShowInContext context) {
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof OutlineItem) {
                    OutlineItem item = (OutlineItem)element;
                    this.selectAndReveal(item);
                    if (this.outlinePage != null && this.outlinePage.getControl() != null && !this.outlinePage.getControl().isDisposed()) {
                        this.outlinePage.setSelection(selection);
                    }
                    return true;
                }
                ++n2;
            }
        } else if (selection instanceof ITextSelection) {
            ITextSelection textSel = (ITextSelection)selection;
            this.selectAndReveal(textSel.getOffset(), textSel.getLength());
            return true;
        }
        return false;
    }

    public void selectAndReveal(OutlineItem item) {
        this.selectAndReveal(item.getOffset(), item.getLength());
        if (this.tabFolder.getSelection() == this.previewTab) {
            this.revealInBrowser(item);
        }
    }

    private void revealInBrowser(OutlineItem item) {
        this.browser.execute(String.format("window.location.hash = '%s';", item.getId()));
    }

    public ShowInContext getShowInContext() {
        OutlineItem item = this.getNearestMatchingOutlineItem();
        return new ShowInContext((Object)this.getEditorInput(), (ISelection)(item == null ? new StructuredSelection() : new StructuredSelection((Object)item)));
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        menu.remove("Linenumbers.Toggle");
    }

    @Override
    public void perform(AbstractDocumentCommand command) throws CoreException {
        this.disableReveal = true;
        try {
            command.execute(((ITextViewerExtension6)this.getViewer()).getUndoManager(), this.getViewer().getDocument());
        }
        finally {
            this.disableReveal = false;
        }
        this.updateOutlineSelection();
    }
}

