/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.preferences;

import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.mylyn.internal.wikitext.ui.editor.preferences.Messages;
import org.eclipse.mylyn.internal.wikitext.ui.util.css.CssParser;
import org.eclipse.mylyn.internal.wikitext.ui.util.css.CssRule;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.CssStyleManager;
import org.eclipse.swt.widgets.Composite;

public class CssStyleFieldEditor
extends StringFieldEditor {
    private final CssStyleManager cssStyleManager;

    public CssStyleFieldEditor(CssStyleManager cssStyleManager, String preferenceKey, String key, Composite parent) {
        super(preferenceKey, key, parent);
        this.cssStyleManager = cssStyleManager;
    }

    protected boolean doCheckState() {
        String value = this.getStringValue();
        if (value != null && value.trim().length() > 0) {
            String gap;
            int offset = 0;
            Iterator<CssRule> ruleIterator = new CssParser().createRuleIterator(value);
            while (ruleIterator.hasNext()) {
                Integer rgb;
                String gap2;
                CssRule rule = ruleIterator.next();
                if (rule.offset > offset && (gap2 = value.substring(offset, rule.offset)).trim().length() != 0) {
                    this.setErrorMessage(MessageFormat.format(Messages.getString("CssStyleFieldEditor.1"), gap2.trim(), offset));
                    return false;
                }
                offset = rule.offset + rule.length;
                if (!this.cssStyleManager.isKnownRule(rule)) {
                    StringBuilder recognizedNames = new StringBuilder();
                    for (String recognizedName : this.cssStyleManager.getRecognizedRuleNames()) {
                        if (recognizedNames.length() > 0) {
                            recognizedNames.append(Messages.getString("CssStyleFieldEditor.2"));
                        }
                        recognizedNames.append(recognizedName);
                    }
                    this.setErrorMessage(MessageFormat.format(Messages.getString("CssStyleFieldEditor.0"), rule.name, recognizedNames));
                    return false;
                }
                if (!"color".equals(rule.name) && !"background-color".equals(rule.name) || (rgb = CssStyleManager.cssColorRgb(rule.value)) != null) continue;
                this.setErrorMessage(MessageFormat.format(Messages.getString("CssStyleFieldEditor.3"), rule.value));
                return false;
            }
            if (offset < value.length() - 1 && (gap = value.substring(offset, value.length())).trim().length() != 0) {
                this.setErrorMessage(MessageFormat.format(Messages.getString("CssStyleFieldEditor.1"), gap.trim(), offset));
                return false;
            }
        }
        return super.doCheckState();
    }
}

