/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.preferences;

import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.editor.preferences.CssStyleFieldEditor;
import org.eclipse.mylyn.internal.wikitext.ui.editor.preferences.Messages;
import org.eclipse.mylyn.internal.wikitext.ui.editor.preferences.Preferences;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.CssStyleManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class EditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public EditorPreferencePage() {
        super(1);
        this.setPreferenceStore(WikiTextUiPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.getString("EditorPreferencePage.0"));
    }

    public Control createContents(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768){

            public Point computeSize(int hint, int hint2, boolean changed) {
                return new Point(64, 64);
            }
        };
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite body = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)body);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(1).applyTo(body);
        Control contents = super.createContents(body);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(contents);
        scrolledComposite.setMinSize(body.computeSize(-1, -1, true));
        return scrolledComposite;
    }

    public void createFieldEditors() {
        Preferences prefs = new Preferences();
        Layout fieldEditorParentLayout = this.getFieldEditorParent().getLayout();
        if (fieldEditorParentLayout instanceof GridLayout) {
            GridLayout layout = (GridLayout)fieldEditorParentLayout;
            layout.marginRight = 5;
        }
        Group blockGroup = new Group(this.getFieldEditorParent(), 0);
        blockGroup.setText(Messages.getString("EditorPreferencePage.1"));
        blockGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        CssStyleManager cssStyleManager = new CssStyleManager(this.getFont());
        for (Map.Entry<String, String> ent : prefs.getCssByBlockModifierType().entrySet()) {
            String preferenceKey = Preferences.toPreferenceKey(ent.getKey(), true);
            this.addField((FieldEditor)new CssStyleFieldEditor(cssStyleManager, preferenceKey, ent.getKey(), (Composite)blockGroup));
        }
        Layout layout = blockGroup.getLayout();
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).marginWidth = 5;
        }
        Group phraseModifierGroup = new Group(this.getFieldEditorParent(), 0);
        phraseModifierGroup.setText(Messages.getString("EditorPreferencePage.2"));
        phraseModifierGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        for (Map.Entry<String, String> ent : prefs.getCssByPhraseModifierType().entrySet()) {
            String preferenceKey = Preferences.toPreferenceKey(ent.getKey(), false);
            this.addField((FieldEditor)new CssStyleFieldEditor(cssStyleManager, preferenceKey, ent.getKey(), (Composite)phraseModifierGroup));
        }
        layout = phraseModifierGroup.getLayout();
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).marginWidth = 5;
        }
        this.applyDialogFont(this.getFieldEditorParent());
        blockGroup.setFont(this.getFieldEditorParent().getFont());
        phraseModifierGroup.setFont(this.getFieldEditorParent().getFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), String.valueOf(WikiTextUiPlugin.getDefault().getPluginId()) + ".preferences");
    }

    public void init(IWorkbench workbench) {
    }
}

