/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.validation;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.mylyn.internal.wikitext.ui.editor.validation.Messages;
import org.eclipse.mylyn.wikitext.core.WikiText;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.validation.MarkupValidator;
import org.eclipse.mylyn.wikitext.core.validation.ValidationProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocumentRegionValidator {
    protected IResource resource;
    protected IAnnotationModel annotationModel;
    protected MarkupLanguage markupLanguage;
    protected MarkupValidator delegate;

    public void validate(IProgressMonitor monitor, IDocument document, IRegion region) throws CoreException {
        if (region.getLength() == 0) {
            return;
        }
        int totalWork = region.getLength() * 2;
        monitor.beginTask(Messages.getString("DocumentRegionValidator.0"), totalWork);
        try {
            this.clearProblems((IProgressMonitor)new SubProgressMonitor(monitor, totalWork / 2), document, region);
            this.computeProblems((IProgressMonitor)new SubProgressMonitor(monitor, totalWork / 2), document, region);
        }
        finally {
            monitor.done();
        }
    }

    protected void computeProblems(IProgressMonitor monitor, IDocument document, IRegion region) throws CoreException {
        if (this.delegate == null) {
            return;
        }
        monitor.beginTask(Messages.getString("DocumentRegionValidator.1"), 0x3FFFFFFF);
        try {
            List problems = this.delegate.validate((IProgressMonitor)new SubProgressMonitor(monitor, 0x1FFFFFFF), document.get(), region.getOffset(), region.getLength());
            this.createProblems((IProgressMonitor)new SubProgressMonitor(monitor, 0x1FFFFFFF), document, region, problems);
        }
        finally {
            monitor.done();
        }
    }

    protected abstract void createProblems(IProgressMonitor var1, IDocument var2, IRegion var3, List<ValidationProblem> var4) throws CoreException;

    protected abstract void clearProblems(IProgressMonitor var1, IDocument var2, IRegion var3) throws CoreException;

    public MarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        if (markupLanguage == this.markupLanguage || markupLanguage != null && this.markupLanguage != null && markupLanguage.getName().equals(this.markupLanguage.getName())) {
            return;
        }
        this.markupLanguage = markupLanguage;
        this.delegate = markupLanguage == null ? null : WikiText.getMarkupValidator((String)markupLanguage.getName());
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public IAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }

    public void setAnnotationModel(IAnnotationModel annotationModel) {
        this.annotationModel = annotationModel;
    }

    protected boolean overlaps(IRegion region, int offset, int length) {
        int end = offset + length;
        if (region.getOffset() > offset) {
            return end > region.getOffset();
        }
        return offset < region.getOffset() + region.getLength();
    }
}

